/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.dto;

import com.sapphireims.exception.DomainException;
import com.sapphireims.model.PattarenMatchTypeEnum;

public class PattarenMatchedDTO {
    private final int groupOccurrence;
    private final int startIndex;
    private final int endIndex;
    private final String matchedPattaren;
    private final PattarenMatchTypeEnum pattarenMatchType;

    private PattarenMatchedDTO(Builder builder) {
        this.groupOccurrence = builder.groupOccurrence;
        this.startIndex = builder.startIndex;
        this.endIndex = builder.endIndex;
        this.matchedPattaren = builder.matchedPattaren;
        this.pattarenMatchType = builder.pattarenMatchType;
    }

    public PattarenMatchedDTO(int groupOccurrence, int startIndex, int endIndex, String matchedPattaren, PattarenMatchTypeEnum type) {
        this.groupOccurrence = groupOccurrence;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.matchedPattaren = matchedPattaren;
        this.pattarenMatchType = type;
    }

    public String getOldKeyValue() throws DomainException {
        String[] split = this.matchedPattaren.split(this.pattarenMatchType.getSplitValue());
        if (split != null && split.length == 2) {
            return split[1];
        }
        throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Invelid pattarenMatchType " + this.pattarenMatchType.getSplitValue());
    }

    public String getNewValue(String newValue) throws DomainException {
        if (this.matchedPattaren != null) {
            String[] split = this.matchedPattaren.split(this.pattarenMatchType.getSplitValue());
            if (split != null && split.length == 2) {
                return split[0] + this.pattarenMatchType.getSplitValue() + newValue;
            }
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Invelid pattarenMatchType " + this.pattarenMatchType.getSplitValue());
        }
        throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Invelid matchedPattaren " + this.matchedPattaren);
    }

    public int getGroupOccurrence() {
        return this.groupOccurrence;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public String getMatchedPattaren() {
        return this.matchedPattaren;
    }

    public PattarenMatchTypeEnum getPattarenMatchType() {
        return this.pattarenMatchType;
    }

    public String toString() {
        return "PattarenMatchedDTO [groupOccurrence=" + this.groupOccurrence + ", startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + ", matchedPattaren=" + this.matchedPattaren + ", pattarenMatchType=" + String.valueOf((Object)this.pattarenMatchType) + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int groupOccurrence;
        private int startIndex;
        private int endIndex;
        private String matchedPattaren;
        private PattarenMatchTypeEnum pattarenMatchType;

        private Builder() {
        }

        public Builder withGroupOccurrence(int groupOccurrence) {
            this.groupOccurrence = groupOccurrence;
            return this;
        }

        public Builder withStartIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public Builder withEndIndex(int endIndex) {
            this.endIndex = endIndex;
            return this;
        }

        public Builder withMatchedPattaren(String matchedPattaren) {
            this.matchedPattaren = matchedPattaren;
            return this;
        }

        public Builder withPattarenMatchType(PattarenMatchTypeEnum pattarenMatchType) {
            this.pattarenMatchType = pattarenMatchType;
            return this;
        }

        public PattarenMatchedDTO build() {
            return new PattarenMatchedDTO(this);
        }
    }
}

