/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.dto.rpa;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.MoreObjects;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.dto.rpa.RpaProcessDTO;
import com.sapphireims.itsm.model.enummodel.PostAction;
import com.sapphireims.model.rpa.RpaEvent;
import java.util.Objects;

public class RpaEventDTO
extends BaseDTO {
    private static final long serialVersionUID = 4450862689205895928L;
    @JsonIgnore
    private RpaProcessDTO process;
    private int projectId;
    private String eventType;
    private String stateIds;
    private String description;
    private PostAction actiontype;
    private boolean asynchronous;
    private Integer processId;
    private int assetModuleId;
    private int isCMDB;
    @JsonIgnore
    private boolean active;
    @JsonIgnore
    private String name;

    private RpaEventDTO(Builder builder) {
        this.id = builder.id;
        this.updated = builder.updated;
        this.tenanatId = builder.tenanatId;
        this.history = builder.history;
        this.process = builder.process;
        this.projectId = builder.projectId;
        this.eventType = builder.eventType;
        this.stateIds = builder.stateIds;
        this.description = builder.description;
        this.actiontype = builder.actiontype;
        this.asynchronous = builder.asynchronous;
        this.assetModuleId = builder.assetModuleId;
        this.isCMDB = builder.isCMDB;
        this.name = builder.name;
        this.active = builder.active;
    }

    public RpaEventDTO() {
    }

    public RpaEventDTO(RpaEvent e, RpaProcessDTO process) {
        this.id = e.getId();
        this.process = process;
        this.projectId = e.getProjectId();
        this.eventType = e.getEventType();
        this.stateIds = e.getStateIds();
        this.description = e.getDescription();
        this.actiontype = e.getActiontype();
        this.asynchronous = e.isAsynchronous();
        this.name = process.getName();
        this.active = process.isActive();
    }

    public RpaEventDTO(Integer id, RpaProcessDTO process, int projectId, String eventType, String stateIds, String description, PostAction actiontype) {
        this.id = id;
        this.process = process;
        this.projectId = projectId;
        this.eventType = eventType;
        this.stateIds = stateIds;
        this.description = description;
        this.actiontype = actiontype;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public RpaProcessDTO getProcess() {
        return this.process;
    }

    public void setProcess(RpaProcessDTO process) {
        this.process = process;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getStateIds() {
        return this.stateIds;
    }

    public void setStateIds(String stateIds) {
        this.stateIds = stateIds;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PostAction getActiontype() {
        return this.actiontype;
    }

    public void setActiontype(PostAction actiontype) {
        this.actiontype = actiontype;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public Integer getProcessId() {
        return this.processId;
    }

    public void setProcessId(Integer processId) {
        this.processId = processId;
    }

    public int getAssetModuleId() {
        return this.assetModuleId;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setAssetModuleId(int assetModuleId) {
        this.assetModuleId = assetModuleId;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int getIsCMDB() {
        return this.isCMDB;
    }

    public void setIsCMDB(int isCMDB) {
        this.isCMDB = isCMDB;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.process, this.projectId, this.eventType, this.stateIds, this.description, this.actiontype, this.asynchronous, this.name, this.active});
    }

    public boolean equals(Object object) {
        if (object instanceof RpaEventDTO) {
            if (!super.equals(object)) {
                return false;
            }
            RpaEventDTO that = (RpaEventDTO)((Object)object);
            return Objects.equals((Object)this.process, (Object)that.process) && this.projectId == that.projectId && Objects.equals(this.eventType, that.eventType) && Objects.equals(this.stateIds, that.stateIds) && Objects.equals(this.description, that.description) && Objects.equals((Object)this.actiontype, (Object)that.actiontype) && this.asynchronous == that.asynchronous && Objects.equals(this.name, that.name) && Objects.equals(this.active, that.active);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", 4450862689205895928L).add("process", (Object)this.process).add("projectId", this.projectId).add("eventType", (Object)this.eventType).add("stateIds", (Object)this.stateIds).add("description", (Object)this.description).add("actiontype", (Object)this.actiontype).add("asynchronous", this.asynchronous).add("name", (Object)this.name).add("isActive", this.active).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private boolean updated;
        private String tenanatId;
        private Object history;
        private RpaProcessDTO process;
        private int projectId;
        private String eventType;
        private String stateIds;
        private String description;
        private PostAction actiontype;
        private boolean asynchronous;
        private int assetModuleId;
        private int isCMDB;
        private boolean active;
        private String name;

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withTenanatId(String tenanatId) {
            this.tenanatId = tenanatId;
            return this;
        }

        public Builder withHistory(Object history) {
            this.history = history;
            return this;
        }

        public Builder withProcess(RpaProcessDTO process) {
            this.process = process;
            return this;
        }

        public Builder withProjectId(int projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withEventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder withStateIds(String stateIds) {
            this.stateIds = stateIds;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withActiontype(PostAction actiontype) {
            this.actiontype = actiontype;
            return this;
        }

        public Builder withAsynchronous(boolean asynchronous) {
            this.asynchronous = asynchronous;
            return this;
        }

        public Builder withAssetModuleId(int assetModuleId) {
            this.assetModuleId = assetModuleId;
            return this;
        }

        public Builder withIsCMDB(int isCMDB) {
            this.isCMDB = isCMDB;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withIsActive(boolean isActive) {
            this.active = isActive;
            return this;
        }

        public RpaEventDTO build() {
            return new RpaEventDTO(this);
        }
    }
}

