/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.dto.rpa;

import com.sapphireims.dto.BaseDTO;
import com.sapphireims.dto.rpa.RpaEventDTO;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.model.rpa.ProcessType;
import com.sapphireims.model.rpa.RpaEvent;
import com.sapphireims.model.rpa.RpaProcess;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RpaProcessDTO
extends BaseDTO {
    private static final long serialVersionUID = -3985092037907230710L;
    private String name;
    private String description;
    private int projectId;
    private String process;
    private ProcessType type;
    private String externalRefId;
    private boolean active;
    private String processId;
    private int assetModuleId;
    private int isCMDB;
    private List<RpaEventDTO> events;

    private RpaProcessDTO(Builder builder) {
        this.id = builder.id;
        this.updated = builder.updated;
        this.tenanatId = builder.tenanatId;
        this.history = builder.history;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.projectId = builder.projectId;
        this.process = builder.process;
        this.type = builder.type;
        this.externalRefId = builder.externalRefId;
        this.active = builder.active;
        this.processId = builder.processId;
        this.events = builder.events;
        this.assetModuleId = builder.assetModuleId;
        this.isCMDB = builder.isCMDB;
    }

    public RpaProcessDTO() {
    }

    public RpaProcessDTO(Integer id) {
        super(id);
    }

    public RpaProcessDTO(Integer id, String name, String description, int projectId, String process, ProcessType type, String externalRefId, boolean active, String processId) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.projectId = projectId;
        this.process = process;
        this.type = type;
        this.externalRefId = externalRefId;
        this.active = active;
        this.processId = processId;
    }

    public RpaProcessDTO(RpaProcess p) {
        this.id = p.getId();
        this.name = p.getName();
        this.description = p.getDescription();
        this.projectId = p.getProjectId();
        this.process = p.getProcess();
        this.type = p.getType();
        this.externalRefId = p.getExternalRefId();
        this.active = p.isActive();
        if (CollectionUtil.isNotEmpty(p.getEvents())) {
            this.events = new ArrayList<RpaEventDTO>(p.getEvents().size());
            for (RpaEvent e : p.getEvents()) {
                this.events.add(new RpaEventDTO(e, this));
            }
        }
        this.processId = p.getProcessId();
    }

    public void validate() throws DomainException, ValidationException {
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getProcess() {
        return this.process;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    public ProcessType getType() {
        return this.type;
    }

    public void setType(ProcessType type) {
        this.type = type;
    }

    public String getExternalRefId() {
        return this.externalRefId;
    }

    public void setExternalRefId(String externalRefId) {
        this.externalRefId = externalRefId;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public List<RpaEventDTO> getEvents() {
        return this.events;
    }

    public void setEvents(List<RpaEventDTO> events) {
        this.events = events;
    }

    public int getAssetModuleId() {
        return this.assetModuleId;
    }

    public void setAssetModuleId(int assetModuleId) {
        this.assetModuleId = assetModuleId;
    }

    public int getIsCMDB() {
        return this.isCMDB;
    }

    public void setIsCMDB(int isCMDB) {
        this.isCMDB = isCMDB;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private boolean updated;
        private String tenanatId;
        private Object history;
        private String name;
        private String description;
        private int projectId;
        private String process;
        private ProcessType type;
        private String externalRefId;
        private boolean active;
        private String processId;
        private int assetModuleId;
        private int isCMDB;
        private List<RpaEventDTO> events = Collections.emptyList();

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withTenanatId(String tenanatId) {
            this.tenanatId = tenanatId;
            return this;
        }

        public Builder withHistory(Object history) {
            this.history = history;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withProjectId(int projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withProcess(String process) {
            this.process = process;
            return this;
        }

        public Builder withType(ProcessType type) {
            this.type = type;
            return this;
        }

        public Builder withExternalRefId(String externalRefId) {
            this.externalRefId = externalRefId;
            return this;
        }

        public Builder withActive(boolean active) {
            this.active = active;
            return this;
        }

        public Builder withProcessId(String processId) {
            this.processId = processId;
            return this;
        }

        public Builder withEvents(List<RpaEventDTO> events) {
            this.events = events;
            return this;
        }

        public Builder withAssetModuleId(int assetModuleId) {
            this.assetModuleId = assetModuleId;
            return this;
        }

        public Builder withIsCMDB(int isCMDB) {
            this.isCMDB = isCMDB;
            return this;
        }

        public RpaProcessDTO build() {
            return new RpaProcessDTO(this);
        }
    }
}

