/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.auditlog.util;

import com.sapphireims.itsm.auditlog.model.AuditContext;
import com.sapphireims.itsm.auditlog.model.AuditContextBuilder;
import com.sapphireims.itsm.auditlog.util.IAuditLogManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service
public class AuditLogManagerImpl
implements IAuditLogManager {
    private static final Log logger = LogFactory.getLog(AuditLogManagerImpl.class);

    @Override
    public boolean checkOldAndNewValue(String oldValue, String newValue) {
        boolean isModified = false;
        try {
            isModified = oldValue.equals(newValue);
        }
        catch (Exception e) {
            logger.error((Object)(" AuditLogManagerImpl :: (--Exception Caught--) occurred in checkOldAndNewValue " + e.getMessage()), (Throwable)e);
        }
        return isModified;
    }

    @Override
    public void saveAuditContext(AuditContext context) {
    }

    @Override
    public boolean checkOldAndNewValue(int oldValue, int newValue) {
        boolean isModified = false;
        try {
            if (oldValue == newValue) {
                isModified = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)(" AuditLogManagerImpl :: (--Exception Caught--) occurred in checkOldAndNewValue " + e.getMessage()), (Throwable)e);
        }
        return isModified;
    }

    @Override
    public AuditContext buildAuditContext(String ipAddress, String actionPerformedBy, String parameterName, String oldValue, String newValue, int actionType) {
        AuditContext context = new AuditContext();
        try {
            switch (actionType) {
                case 2: {
                    context = new AuditContextBuilder(ipAddress, actionPerformedBy).setParameter(parameterName).setNewValue(newValue).setOldValue(oldValue).setActionType(2).getAuditContext();
                    break;
                }
                case 3: {
                    context = new AuditContextBuilder(ipAddress, actionPerformedBy).setParameter(parameterName).setNewValue(newValue).setOldValue(oldValue).setActionType(3).getAuditContext();
                    break;
                }
                default: {
                    context = new AuditContextBuilder(ipAddress, actionPerformedBy).setParameter(parameterName).setNewValue(newValue).setOldValue(oldValue).setActionType(1).getAuditContext();
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)(" AuditLogManagerImpl :: (--Exception Caught--) occurred in buildAuditContext " + e.getMessage()), (Throwable)e);
        }
        return context;
    }

    @Override
    public List getAuditData() {
        return null;
    }

    @Override
    public List<AuditContext> getAuditLogByModule(int moduleId) {
        return null;
    }

    @Override
    public void saveMultipleAuditContextFromList(List<AuditContext> context) {
        try {
            for (AuditContext audit : context) {
                this.saveAuditContext(audit);
            }
        }
        catch (Exception e) {
            logger.error((Object)(" AuditLogManagerImpl :: (--Exception Caught--) occurred in saveMultipleAuditContextFromList " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void generateExcel(HttpServletRequest request, HttpServletResponse response) {
    }
}

