/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.IHibernateRepositoryOperations;
import com.sapphireims.itsm.dao.IEscalationBackUpInfoDAO;
import com.sapphireims.itsm.dao.IEscalationLookupDAO;
import com.sapphireims.itsm.model.EscalationBackupinfo;
import com.sapphireims.itsm.model.EscalationDetails;
import com.sapphireims.itsm.model.EscalationLookup;
import com.sapphireims.itsm.model.SdServiceReqMaster;
import com.sapphireims.util.CollectionUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class EscalationBackUpInfoDAO
implements IEscalationBackUpInfoDAO {
    @Autowired
    @Qualifier(value="hibernateRepositoryOperations")
    protected IHibernateRepositoryOperations hibernateDaoOperations;
    @Autowired
    private IEscalationLookupDAO escalationLookupDAO;

    @Override
    public void deleteEscalationBackUpInfo(Integer problemId) {
        String query = "delete from EscalationBackupinfo where sdServicereqmaster.problemId=:problemId";
        String[] paramNames = new String[]{"problemId"};
        Object[] values = new Object[]{problemId};
        this.hibernateDaoOperations.bulkUpdateOrDeleteByParam(query, paramNames, values);
    }

    @Override
    public void saveEscalationLookupList(List<EscalationLookup> escalationLookupList) {
        if (CollectionUtil.isNotEmpty(escalationLookupList)) {
            for (EscalationLookup el : escalationLookupList) {
                EscalationDetails ed = new EscalationDetails();
                ed.setSlaId(el.getSlaId());
                SdServiceReqMaster sr = new SdServiceReqMaster();
                sr.setProblemId(el.getProblemId());
                EscalationBackupinfo eb = new EscalationBackupinfo(ed, sr, el.getEsca1(), el.getEsca2(), el.getEmailEsca1(), el.getEmailEsca2(), el.getSlaBreachTime(), el.getEsca1BreachTime(), el.getEsca1SendTime(), el.getEsca2BreachTime(), el.getEsca2SendTime(), el.getEsca3(), el.getEmailEsca3(), el.getEsca3BreachTime(), el.getEsca3SendTime());
                this.hibernateDaoOperations.saveOrUpdate(eb);
            }
        }
    }

    @Override
    public List<EscalationBackupinfo> getEscalationBackUpInfo(Integer problemId) {
        String query = " from EscalationBackupinfo where sdServicereqmaster.problemId = :problemId ";
        String[] paramNames = new String[]{"problemId"};
        Object[] values = new Object[]{problemId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, EscalationBackupinfo.class);
    }

    @Override
    public void saveEscalationBackUpInfoList(List<EscalationBackupinfo> escalationBackUpInfoList) {
        if (CollectionUtil.isNotEmpty(escalationBackUpInfoList)) {
            for (EscalationBackupinfo escalationBackupinfo : escalationBackUpInfoList) {
            }
        }
    }

    @Override
    public void saveEscalationInfoList(List<EscalationLookup> escalationLookupList) {
        if (CollectionUtil.isNotEmpty(escalationLookupList)) {
            escalationLookupList.forEach(eb -> this.updateEscalationLookup(eb.getProblemId(), eb.getSlaId(), (EscalationLookup)eb));
        }
    }

    public void updateEscalationLookup(Integer problemId, Integer slaId, EscalationLookup eb) {
        EscalationLookup el = this.escalationLookupDAO.getEscalationLookupForProblemIdAndSlaId(problemId, slaId);
        if (el != null && eb != null) {
            el.setEsca1(eb.getEsca1());
            el.setEsca2(eb.getEsca2());
            el.setEsca3(eb.getEsca3());
            el.setEmailEsca1(eb.getEmailEsca1());
            el.setEmailEsca2(eb.getEmailEsca2());
            el.setEmailEsca3(eb.getEmailEsca3());
            if (eb.getSlaBreachTime() != null) {
                el.setSlaBreachTime(eb.getSlaBreachTime());
            }
            if (eb.getEsca1BreachTime() != null) {
                el.setEsca1BreachTime(eb.getEsca1BreachTime());
            }
            if (eb.getEsca1SendTime() != null) {
                el.setEsca1SendTime(eb.getEsca1SendTime());
            }
            if (eb.getEsca2BreachTime() != null) {
                el.setEsca2BreachTime(eb.getEsca2BreachTime());
            }
            if (eb.getEsca2SendTime() != null) {
                el.setEsca2SendTime(eb.getEsca2SendTime());
            }
            if (eb.getEsca3BreachTime() != null) {
                el.setEsca3BreachTime(eb.getEsca3BreachTime());
            }
            if (eb.getEsca3SendTime() != null) {
                el.setEsca3SendTime(eb.getEsca3SendTime());
            }
        }
    }
}

