/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.IEscalationLookupDAO;
import com.sapphireims.itsm.model.EscalationLookup;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class EscalationLookupDAO
extends GenericHibernateRepository<EscalationLookup, Integer>
implements IEscalationLookupDAO {
    @Override
    public List<EscalationLookup> getEscalationLookupForTicketId(Integer ticketId) {
        String query = " from EscalationLookup where problemId = :ticketId ";
        String[] paramNames = new String[]{"ticketId"};
        Object[] values = new Object[]{ticketId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, EscalationLookup.class);
    }

    @Override
    public void deleteEntryForProblemId(Integer problemId) {
        String query = "delete from EscalationLookup where problemId=:problemId";
        String[] paramNames = new String[]{"problemId"};
        Object[] values = new Object[]{problemId};
        this.hibernateDaoOperations.bulkUpdateOrDeleteByParam(query, paramNames, values);
    }

    @Override
    public List<EscalationLookup> getEscalationLookupForTicketIdAndSlaId(Integer ticketId, Integer slaId) {
        String query = " from EscalationLookup where problemId = :ticketId and slaId =:slaId";
        String[] paramNames = new String[]{"ticketId", "slaId"};
        Object[] values = new Object[]{ticketId, slaId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, EscalationLookup.class);
    }

    @Override
    public EscalationLookup getEscalationLookupForProblemIdAndSlaId(Integer problemId, Integer slaId) {
        String query = " from EscalationLookup where problemId = :problemId and slaId =:slaId";
        String[] paramNames = new String[]{"problemId", "slaId"};
        Object[] values = new Object[]{problemId, slaId};
        return (EscalationLookup)this.hibernateDaoOperations.findByNamedParamMaxResult(query, paramNames, values, 1);
    }

    @Override
    public List<EscalationLookup> getEscalationLookupForProblemId(Integer problemId) {
        String query = " from EscalationLookup where problemId = :problemId";
        String[] paramNames = new String[]{"problemId"};
        Object[] values = new Object[]{problemId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, EscalationLookup.class);
    }

    @Override
    public List<EscalationLookup> getEscalationLookupList(String whereCondition) {
        String query = " from EscalationLookup where isTicketActive != 0 and previousStatus != 0 " + whereCondition;
        return this.hibernateDaoOperations.find(query, EscalationLookup.class);
    }
}

