/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.IHtmlTemplateDAO;
import com.sapphireims.itsm.model.HtmlTemplate;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class HtmlTemplateDAO
extends GenericHibernateRepository<HtmlTemplate, Integer>
implements IHtmlTemplateDAO {
    private static final Log logger = LogFactory.getLog((String)"ITSM.log");

    @Override
    @Transactional
    public void deleteHtmlTemplate(HtmlTemplate htmlTemplate) {
        try {
            this.hibernateDaoOperations.delete((Object)htmlTemplate);
        }
        catch (Exception e) {
            logger.error((Object)("HtmlTemplateDAO :: (--Exception Caught--) occured in deleteHtmlTemplate " + e.getMessage()));
        }
    }

    @Override
    @Transactional(readOnly=true)
    public HtmlTemplate getHtmlTemplateById(Integer templateId) {
        try {
            return (HtmlTemplate)((Object)this.hibernateDaoOperations.get(HtmlTemplate.class, (Serializable)templateId));
        }
        catch (Exception e) {
            logger.error((Object)("HtmlTemplateDAO :: (--Exception Caught--) occured in getHtmlTemplateById " + e.getMessage()));
            return null;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public boolean isDuplicateTemplateName(String templateName) {
        try {
            String hql = "SELECT COUNT(*) FROM HtmlTemplate t WHERE t.templateName = :templateName";
            String[] paramNames = new String[]{"templateName"};
            Object[] values = new Object[]{templateName};
            Long count = (Long)this.hibernateDaoOperations.findByNamedParamUniqueResult(hql, paramNames, values, Long.class);
            return count > 0L;
        }
        catch (Exception e) {
            logger.error((Object)("HtmlTemplateDAO :: (--Exception Caught--) occured in isDuplicateTemplateName " + e.getMessage()));
            return false;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<HtmlTemplate> getAllHtmlTemplate() {
        List templateList = null;
        try {
            String queryString = "from HtmlTemplate";
            String[] paramNames = new String[]{};
            Object[] values = new Object[]{};
            templateList = this.hibernateDaoOperations.findByNamedParam(queryString, paramNames, values, HtmlTemplate.class);
        }
        catch (Exception e) {
            logger.error((Object)("HtmlTemplateDAO :: (--Exception Caught--) occurred in getAllHtmlTemplate " + e.getMessage()), (Throwable)e);
        }
        return templateList;
    }
}

