/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdCategorymasterDAO;
import com.sapphireims.itsm.dto.SdCategoryDTO;
import com.sapphireims.itsm.dto.SdCategoryMasterDTO;
import com.sapphireims.itsm.mindto.CategoryMinDTO;
import com.sapphireims.itsm.model.SdCategorymaster;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Repository;

@Repository
public class SdCategorymasterDAO
extends GenericHibernateRepository<SdCategorymaster, Integer>
implements ISdCategorymasterDAO {
    @Override
    public List<SdCategorymaster> getSdCategorymasterByProjectId(Integer projectId) {
        String query = " from SdCategorymaster where sdProjectMaster.projectId = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdCategorymaster.class);
    }

    @Override
    public List<CategoryMinDTO> getSdCategorymasterByProjectIdAndService(Integer projectId, String services) {
        String[] serviceArray = services.split(",");
        ArrayList<Integer> serviceList = new ArrayList<Integer>();
        for (String service : serviceArray) {
            serviceList.add(Integer.parseInt(service));
        }
        String query = "select distinct sc.categoryId AS categoryId,sc.categoryName AS categoryName from SdCategorymaster sc, SdServiceParametersDetails ssp where sc.categoryId = ssp.parameterValue and sc.status=0 and sc.sdProjectMaster.projectId=:projectId and ssp.serviceId in (:serviceId) and ssp.sdServiceParametersMaster.parameterId=1 order by sc.categoryName";
        String[] paramNames = new String[]{"projectId", "serviceId"};
        Object[] values = new Object[]{projectId, serviceList};
        return this.genericHibernateDaoOperations.findByNamedParam(query, paramNames, values, SdDTOEnum.CATEGORY_MIN_DTO);
    }

    @Override
    public SdCategorymaster getCategoryByName(String categoryName, Integer projectId) {
        String query = " from SdCategorymaster where sdProjectMaster.projectId = :projectId and  categoryName=:categoryName";
        String[] paramNames = new String[]{"projectId", "categoryName"};
        Object[] values = new Object[]{projectId, categoryName};
        return (SdCategorymaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdCategorymaster.class));
    }

    @Override
    public List<CategoryMinDTO> getCategoryListBySubcategory(List<Integer> subcatList) {
        String query = "Select sc.categoryId AS categoryId,sc.categoryName AS categoryName from SdCategorymaster sc,SdSubcategorymaster ssub where sc.categoryId=ssub.sdCategorymaster.categoryId and ssub.subCategoryId IN(:subcategoryList)";
        String[] paramNames = new String[]{"subcategoryList"};
        Object[] values = new Object[]{subcatList};
        return this.genericHibernateDaoOperations.findByNamedParam(query, paramNames, values, SdDTOEnum.CATEGORY_MIN_DTO);
    }

    @Override
    public List<SdCategorymaster> getSdCategoryMasterByProjectId(Integer projectId, Integer pageNo, Integer pageSize) {
        String query = " from SdCategorymaster where sdProjectMaster.projectId = :projectId";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.genericHibernateDaoOperations.findByNamedParamAndPagesize(query, paramNames, values, pageNo, pageSize, SdDTOEnum.SD_CATEGORY_MASTER);
    }

    @Override
    public SdCategorymaster getServiceByProjectIdAndCategoryId(Integer categoryId, Integer projectId) {
        String query = " from SdCategorymaster where sdProjectMaster.projectId = :projectId and categoryId =:categoryId";
        String[] paramNames = new String[]{"projectId", "categoryId"};
        Object[] values = new Object[]{projectId, categoryId};
        List category = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdCategorymaster.class);
        return category != null && !category.isEmpty() ? (SdCategorymaster)((Object)category.get(0)) : null;
    }

    @Override
    public int saveSdCategoryName(SdCategoryMasterDTO categoryDTO, int projectId) {
        SdProjectMaster sdProjectMaster = (SdProjectMaster)((Object)this.hibernateDaoOperations.get(SdProjectMaster.class, (Serializable)Integer.valueOf(projectId)));
        SdCategorymaster sdCategorymaster = new SdCategorymaster();
        sdCategorymaster.setCategoryName(categoryDTO.getCategoryName());
        sdCategorymaster.setCategoryDescription(categoryDTO.getCategoryDescription());
        sdCategorymaster.setShortname(categoryDTO.getShortname());
        sdCategorymaster.setSdProjectMaster(sdProjectMaster);
        this.hibernateDaoOperations.save((Object)sdCategorymaster);
        return sdCategorymaster.getCategoryId();
    }

    @Override
    public void updateSdCategoryName(SdCategoryMasterDTO categoryDTO, int projectId) {
        SdCategorymaster sdCategorymaster = (SdCategorymaster)((Object)this.hibernateDaoOperations.get(SdCategorymaster.class, (Serializable)categoryDTO.getCategoryId()));
        sdCategorymaster.setCategoryName(categoryDTO.getCategoryName());
        this.hibernateDaoOperations.saveOrUpdate((Object)sdCategorymaster);
    }

    @Override
    public void saveCategoryDescription(Integer categoryId, String description) {
        SdCategorymaster sdCategorymaster = (SdCategorymaster)((Object)this.hibernateDaoOperations.get(SdCategorymaster.class, (Serializable)categoryId));
        sdCategorymaster.setCategoryDescription(description);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdCategorymaster);
    }

    @Override
    public void saveShortName(Integer categoryId, String shortName) {
        SdCategorymaster sdCategorymaster = (SdCategorymaster)((Object)this.hibernateDaoOperations.get(SdCategorymaster.class, (Serializable)categoryId));
        sdCategorymaster.setShortname(shortName);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdCategorymaster);
    }

    @Override
    public void saveSdCategoryStatus(int categoryId, int status) {
        SdCategorymaster sdCategorymaster = (SdCategorymaster)((Object)this.hibernateDaoOperations.get(SdCategorymaster.class, (Serializable)Integer.valueOf(categoryId)));
        sdCategorymaster.setStatus(status);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdCategorymaster);
    }

    @Override
    public Integer checkDuplicateCategoryName(String categoryName, Integer projectId, Integer categoryId) {
        Integer isDuplicate = 0;
        String query = "SELECT categoryName FROM SdCategorymaster WHERE categoryName=:categoryName and sdProjectMaster.projectId=:projectId and categoryId <> :categoryId";
        String[] paramNames = new String[]{"categoryName", "projectId", "categoryId"};
        Object[] values = new Object[]{categoryName, projectId, categoryId};
        List categoryList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, String.class);
        if (categoryList != null && categoryList.size() > 0) {
            isDuplicate = 1;
        }
        return isDuplicate;
    }

    @Override
    public List<SdCategorymaster> getCategoryNameByWorkgroupId(Integer workGroupID) {
        String query = " SELECT sc.* FROM Sd_Workgroupdetails sw,Sd_Categorymaster sc where sc.categoryId= CAST(sw.WorkGroupValue AS UNSIGNED) and sw.workGroupType=2 and sw.workGroupId=:workGroupID";
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("workGroupID", workGroupID);
        return this.hibernateDaoOperations.sqlQuery(query, paramMap, SdCategorymaster.class);
    }

    @Override
    public List<SdCategorymaster> getCategoryListByCategory(List<Integer> categoryIdList) {
        String query = "from SdCategorymaster where categoryId in(:categoryIdList)";
        String[] paramNames = new String[]{"categoryIdList"};
        Object[] values = new Object[]{categoryIdList};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdCategorymaster.class);
    }

    @Override
    public List<SdCategorymaster> getCategoryByProjectId(Integer projectId) {
        String query = " from SdCategorymaster where sdProjectMaster.projectId = :projectId and status=0";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdCategorymaster.class);
    }

    @Override
    public List<CategoryMinDTO> getSdCategorymasterByProjectIdAndService(Integer projectId) {
        String query = "select distinct sc.categoryId AS categoryId,sc.categoryName AS categoryName from SdCategorymaster sc, SdServiceParametersDetails ssp where sc.categoryId = ssp.parameterValue and sc.status=0 and sc.sdProjectMaster.projectId=:projectId and ssp.sdServiceParametersMaster.parameterId=1 order by sc.categoryName";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.genericHibernateDaoOperations.findByNamedParam(query, paramNames, values, SdDTOEnum.CATEGORY_MIN_DTO);
    }

    @Override
    public List<SdCategoryDTO> getSortedCategoryRecordsByProject(Integer projectId, Integer pageNo, Integer pageSize, String sortColumn, String sortDir) {
        int offset = (pageNo - 1) * pageSize;
        StringBuilder sql = new StringBuilder("    SELECT\n        cat.CategoryId,\n        cat.CategoryName,\n        cat.CategoryDescription,\n        cat.ShortName,\n        cat.Status,\n        COALESCE(GROUP_CONCAT(DISTINCT srv.ServiceName ORDER BY srv.ServiceName SEPARATOR ','), 'All') AS service_name\n    FROM\n        sd_categorymaster cat\n    LEFT JOIN\n        sd_service_parameters_details spd ON cat.CategoryId = spd.ParameterValue AND spd.ParameterId = 1\n    LEFT JOIN\n        sd_service srv ON spd.ServiceId = srv.ServiceId\n    WHERE\n        cat.ProjectID = :projectId\n    GROUP BY\n        cat.CategoryId, cat.CategoryName, cat.CategoryDescription, cat.ShortName, cat.Status\n");
        if (sortColumn != null) {
            sql.append(" ORDER BY ").append(sortColumn).append(" ").append(sortDir);
        }
        if (pageSize != null && pageSize > 0) {
            sql.append(" LIMIT :limit OFFSET :offset");
        }
        NativeQuery query = this.hibernateDaoOperations.getSessionFactory().getCurrentSession().createNativeQuery(sql.toString(), Object[].class);
        query.setParameter("projectId", (Object)projectId);
        if (pageSize != null && pageSize > 0) {
            query.setParameter("limit", (Object)pageSize);
            query.setParameter("offset", (Object)offset);
        }
        List rows = query.getResultList();
        ArrayList<SdCategoryDTO> dtoList = new ArrayList<SdCategoryDTO>();
        for (Object[] row : rows) {
            Integer categoryId = ((Number)row[0]).intValue();
            String categoryName = (String)row[1];
            String categoryDesc = (String)row[2];
            String shortName = (String)row[3];
            Integer statusCode = ((Number)row[4]).intValue();
            String serviceName = (String)row[5];
            SdCategoryDTO dto = new SdCategoryDTO(categoryId, categoryName, categoryDesc, shortName, statusCode, serviceName);
            dtoList.add(dto);
        }
        return dtoList;
    }
}

