/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdConfigSettingsDAO;
import com.sapphireims.itsm.model.SdConfigsettings;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.MutationQuery;
import org.springframework.stereotype.Repository;

@Repository
public class SdConfigSettingsDAO
extends GenericHibernateRepository<SdConfigsettings, Integer>
implements ISdConfigSettingsDAO {
    @Override
    public List<SdConfigsettings> getSdConfigSettingsByProjectId(Integer projectId) {
        String query = " from SdConfigsettings where sdProjectMaster.projectId = :projectId";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdConfigsettings.class);
    }

    @Override
    public void saveSdConfigSettings(List<SdConfigsettings> entity) {
        Session session = this.hibernateDaoOperations.getSessionFactory().getCurrentSession();
        MutationQuery sqlQuery = null;
        String Query2 = "insert into sd_configsettings (ProjectID, ServiceID, Description, DisplayName, SettingKEY, SettingValue, UnitTypes, SettingEditable, Validation, MinValue, `MaxValue`, IsServiceRestartRequired, SettingCategory, MailType) values(:projectID,:serviceID,:description,:displayName,:settingKEY,:settingValue,:unitTypes,:settingEditable,:validation,:minValue,:maxValue,:isServiceRestartRequired,:settingCategory,:mailType)";
        for (SdConfigsettings sdcs : entity) {
            sqlQuery = session.createNativeMutationQuery(Query2);
            sqlQuery.setParameter("projectID", (Object)sdcs.getSdProjectMaster().getProjectId());
            sqlQuery.setParameter("serviceID", (Object)sdcs.getServiceId());
            sqlQuery.setParameter("description", (Object)sdcs.getDescription());
            sqlQuery.setParameter("displayName", (Object)sdcs.getDisplayName());
            sqlQuery.setParameter("settingKEY", (Object)sdcs.getSettingKey());
            sqlQuery.setParameter("settingValue", (Object)sdcs.getSettingValue());
            sqlQuery.setParameter("unitTypes", (Object)sdcs.getUnitTypes());
            sqlQuery.setParameter("settingEditable", (Object)sdcs.getSettingEditable());
            sqlQuery.setParameter("validation", (Object)sdcs.getValidation());
            sqlQuery.setParameter("minValue", (Object)sdcs.getMinValue());
            sqlQuery.setParameter("maxValue", (Object)sdcs.getMaxValue());
            sqlQuery.setParameter("isServiceRestartRequired", (Object)sdcs.getIsServiceRestartRequired());
            sqlQuery.setParameter("settingCategory", (Object)sdcs.getSettingCategory());
            sqlQuery.setParameter("mailType", (Object)sdcs.getMailType());
            sqlQuery.executeUpdate();
        }
    }

    @Override
    public String getSdSettingValue(String settingKey, Integer projectId, Integer serviceId) {
        String query = "SELECT sdc.settingValue FROM SdConfigsettings sdc where sdc.sdProjectMaster.projectId = :projectId and (sdc.serviceId = :serviceId or sdc.serviceId =0 ) and sdc.settingKey=:settingKey";
        String[] paramNames = new String[]{"projectId", "serviceId", "settingKey"};
        Object[] values = new Object[]{projectId, serviceId, settingKey};
        return (String)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, String.class);
    }

    @Override
    public List<SdConfigsettings> getSdConfigSettingsByProjectIds(List<Integer> projectIds) {
        String query = " from SdConfigsettings where sdProjectMaster.projectId in (:projectIds)";
        String[] paramNames = new String[]{"projectIds"};
        Object[] values = new Object[]{projectIds};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdConfigsettings.class);
    }

    @Override
    public void updateSettingKey(String settingsKey, Integer projectId, String settingValue) {
        Session session = this.hibernateDaoOperations.getSessionFactory().getCurrentSession();
        MutationQuery sqlQuery = null;
        String Query2 = "update sd_configsettings set SettingValue=:settingValue where SettingKEY=:settingsKey and ProjectID= :projectId";
        sqlQuery = session.createNativeMutationQuery(Query2);
        sqlQuery.setParameter("settingValue", (Object)settingValue);
        sqlQuery.setParameter("settingsKey", (Object)settingsKey);
        sqlQuery.setParameter("projectId", (Object)projectId);
        sqlQuery.executeUpdate();
    }

    @Override
    public List<SdConfigsettings> getSdConfigSettingsBySettingKeyAndValue(String settingValue, String settingKey) {
        String query = "from SdConfigsettings where settingKey = :settingKey and settingValue = :settingValue  ";
        String[] paramNames = new String[]{"settingKey", "settingValue"};
        Object[] values = new Object[]{settingKey, settingValue};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdConfigsettings.class);
    }

    @Override
    public void updateSettingKey(String settingKey, String settingValue, Integer projectId) {
        String updateQuery = "update SdConfigsettings set settingValue = :settingValue where sdProjectMaster.projectId = :projectId and settingKey = :settingKey";
        HashMap<String, Object> namedParams = new HashMap<String, Object>();
        namedParams.put("settingValue_1", settingValue);
        namedParams.put("projectId_2", projectId);
        namedParams.put("settingKey_1", settingKey);
        this.hibernateDaoOperations.updateByNamedParam(updateQuery, namedParams);
    }
}

