/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdCustomSpecializationDAO;
import com.sapphireims.itsm.dto.SdCustomSpecializationDTO;
import com.sapphireims.itsm.model.SdCustomSpecialization;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SdCustomSpecializationDAO
extends GenericHibernateRepository<SdCustomSpecialization, Integer>
implements ISdCustomSpecializationDAO {
    @Override
    @Transactional(readOnly=true)
    public List<SdCustomSpecialization> getSdCustomSpecializationByProjectId(Integer projectId) {
        String query = " from SdCustomSpecialization where sdProjectMaster.projectId = :projectId and status=0 ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdCustomSpecialization.class);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdCustomSpecialization> getSdCustomSpecializationByProjectId(Integer projectId, Integer pageNo, Integer pageSize, String columnSort, String sortDir) {
        Object query = " from SdCustomSpecialization where sdProjectMaster.projectId = :projectId and status=0 ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        if (columnSort != null && !columnSort.isEmpty()) {
            query = (String)query + " order by " + columnSort + " " + sortDir;
        }
        return this.genericHibernateDaoOperations.findByNamedParamAndPagesize((String)query, paramNames, values, pageNo, pageSize, SdDTOEnum.SD_CUSTOM_SPECIALIZATION);
    }

    @Override
    @Transactional(readOnly=true)
    public SdCustomSpecialization getSpecializationDetails(Integer projectId, Integer specializationId) {
        String query = " from SdCustomSpecialization where sdProjectMaster.projectId = :projectId and specializationId = :specializationId";
        String[] paramNames = new String[]{"projectId", "specializationId"};
        Object[] values = new Object[]{projectId, specializationId};
        List specializationList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdCustomSpecialization.class);
        return specializationList != null && !specializationList.isEmpty() ? (SdCustomSpecialization)((Object)specializationList.get(0)) : null;
    }

    @Override
    @Transactional
    public int saveSpecializationName(SdCustomSpecializationDTO sdCustomSpecializationDTO, int projectId) {
        SdCustomSpecialization sdCustomSpecialization = new SdCustomSpecialization();
        sdCustomSpecialization.setSpecializationName(sdCustomSpecializationDTO.getSpecializationName());
        SdProjectMaster sdProjectMaster = (SdProjectMaster)((Object)this.hibernateDaoOperations.get(SdProjectMaster.class, (Serializable)Integer.valueOf(projectId)));
        sdCustomSpecialization.setSdProjectMaster(sdProjectMaster);
        this.hibernateDaoOperations.save((Object)sdCustomSpecialization);
        return sdCustomSpecialization.getSpecializationId();
    }

    @Override
    @Transactional
    public void updateSpecializationName(int specializationId, String specializationName) {
        SdCustomSpecialization sdCustomSpecialization = (SdCustomSpecialization)((Object)this.hibernateDaoOperations.get(SdCustomSpecialization.class, (Serializable)Integer.valueOf(specializationId)));
        sdCustomSpecialization.setSpecializationName(specializationName);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdCustomSpecialization);
    }

    @Override
    @Transactional
    public void saveSpecializationDescription(int specializationId, String specializationDescription) {
        SdCustomSpecialization sdCustomSpecialization = (SdCustomSpecialization)((Object)this.hibernateDaoOperations.get(SdCustomSpecialization.class, (Serializable)Integer.valueOf(specializationId)));
        sdCustomSpecialization.setSpecializationDescription(specializationDescription);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdCustomSpecialization);
    }

    @Override
    @Transactional
    public void deleteSpecializationId(int specializationId) {
        this.hibernateDaoOperations.delete(this.hibernateDaoOperations.get(SdCustomSpecialization.class, (Serializable)Integer.valueOf(specializationId)));
    }

    @Override
    @Transactional(readOnly=true)
    public Integer checkDuplicateSpecializationName(String specializationName, Integer projectId) {
        Integer isDuplicate = 0;
        String query = "SELECT specializationName FROM SdCustomSpecialization WHERE specializationName=:specializationName and sdProjectMaster.projectId=:projectId and status=0";
        String[] paramNames = new String[]{"specializationName", "projectId"};
        Object[] values = new Object[]{specializationName, projectId};
        List specializationList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, String.class);
        if (specializationList != null && specializationList.size() > 0) {
            isDuplicate = 1;
        }
        return isDuplicate;
    }
}

