/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdEnclosureTemplateDAO;
import com.sapphireims.itsm.dto.SdEnclosureTemplateDTO;
import com.sapphireims.itsm.model.SdEnclosureTemplate;
import com.sapphireims.itsm.model.SdFixedfieldmacros;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class SdEnclosureTemplateDAO
extends GenericHibernateRepository<SdEnclosureTemplate, Integer>
implements ISdEnclosureTemplateDAO {
    @Override
    public List<SdEnclosureTemplate> getSdEnclosureTemplateByProjectId(Integer projectId) {
        String query = " from SdEnclosureTemplate where sdProjectMaster.projectId = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdEnclosureTemplate.class);
    }

    @Override
    public List<SdEnclosureTemplate> getSdEnclosureTemplateByProjectId(Integer projectId, Integer type, Integer pageNo, Integer pageSize) {
        String query = " from SdEnclosureTemplate where sdProjectMaster.projectId = :projectId and type=" + type;
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.genericHibernateDaoOperations.findByNamedParamAndPagesize(query, paramNames, values, pageNo, pageSize, SdDTOEnum.SD_ENCLOSURE_TEMPLATE);
    }

    @Override
    public int saveSdEnclosureTemplate(SdEnclosureTemplateDTO enclosureTemplateDTO) {
        SdProjectMaster sdProjectMaster = (SdProjectMaster)((Object)this.hibernateDaoOperations.get(SdProjectMaster.class, (Serializable)enclosureTemplateDTO.getProjectId()));
        SdEnclosureTemplate sdEnclosureTemplate = new SdEnclosureTemplate();
        sdEnclosureTemplate.setTemplateName(enclosureTemplateDTO.getTemplateName());
        sdEnclosureTemplate.setDescription(enclosureTemplateDTO.getDescription());
        sdEnclosureTemplate.setTemplateBody(enclosureTemplateDTO.getTemplateBody());
        sdEnclosureTemplate.setSdProjectMaster(sdProjectMaster);
        sdEnclosureTemplate.setType(enclosureTemplateDTO.getType());
        this.hibernateDaoOperations.save((Object)sdEnclosureTemplate);
        return sdEnclosureTemplate.getTemplateId();
    }

    @Override
    public void updateSdEnclosureTemplate(SdEnclosureTemplateDTO enclosureTemplateDTO) {
        SdEnclosureTemplate sdEnclosureTemplate = (SdEnclosureTemplate)((Object)this.hibernateDaoOperations.get(SdEnclosureTemplate.class, (Serializable)enclosureTemplateDTO.getTemplateId()));
        sdEnclosureTemplate.setTemplateName(enclosureTemplateDTO.getTemplateName());
        this.hibernateDaoOperations.saveOrUpdate((Object)sdEnclosureTemplate);
    }

    @Override
    public void saveSdEnclosureTemplateDescription(SdEnclosureTemplateDTO enclosureTemplateDTO) {
        SdEnclosureTemplate sdEnclosureTemplate = (SdEnclosureTemplate)((Object)this.hibernateDaoOperations.get(SdEnclosureTemplate.class, (Serializable)enclosureTemplateDTO.getTemplateId()));
        sdEnclosureTemplate.setDescription(enclosureTemplateDTO.getDescription());
        this.hibernateDaoOperations.saveOrUpdate((Object)sdEnclosureTemplate);
    }

    @Override
    public void saveSdEnclosureTemplateBody(SdEnclosureTemplateDTO enclosureTemplateDTO) {
        SdEnclosureTemplate sdEnclosureTemplate = (SdEnclosureTemplate)((Object)this.hibernateDaoOperations.get(SdEnclosureTemplate.class, (Serializable)enclosureTemplateDTO.getTemplateId()));
        sdEnclosureTemplate.setTemplateBody(enclosureTemplateDTO.getTemplateBody());
        this.hibernateDaoOperations.saveOrUpdate((Object)sdEnclosureTemplate);
    }

    @Override
    public Integer checkDuplicateTemplateName(String templateName, Integer projectId, Integer templateId) {
        Integer isDuplicate = 0;
        String query = "SELECT templateName FROM SdEnclosureTemplate WHERE templateName=:templateName and sdProjectMaster.projectId=:projectId and templateId <> :templateId";
        String[] paramNames = new String[]{"templateName", "projectId", "templateId"};
        Object[] values = new Object[]{templateName, projectId, templateId};
        List templateList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, String.class);
        if (templateList != null && templateList.size() > 0) {
            isDuplicate = 1;
        }
        return isDuplicate;
    }

    @Override
    public void deleteSdEnclosureTemplates(Integer templateId) {
        this.hibernateDaoOperations.delete(this.hibernateDaoOperations.get(SdEnclosureTemplate.class, (Serializable)templateId));
    }

    @Override
    public List<SdFixedfieldmacros> getSdFixedFieldsMacro(int groupId) {
        String query = " from SdFixedfieldmacros where macroType in(0,1,2) and status=0 and groupId = :groupId order by displayName";
        String[] paramNames = new String[]{"groupId"};
        Object[] values = new Object[]{groupId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdFixedfieldmacros.class);
    }

    @Override
    public List getSdCustomFieldsMacro(int projectId) {
        String query = "Select sa.fieldid, sa.fieldDisplayname from SdAdditionalparams sa,Macromaster mm where sa.sdProjectMaster.projectId=:projectId and sa.status=0 and sa.macroid=mm.macroid and mm.macroHtmlType not in(14,18)";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, Object[].class);
    }
}

