/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.dto.SearchEntityResponce;
import com.sapphireims.dto.SearchRequestDTO;
import com.sapphireims.itsm.dao.ISdIntegrationConfigDAO;
import com.sapphireims.itsm.model.SdIntegrationConfig;
import com.sapphireims.util.CollectionUtil;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class SdIntegrationConfigDAO
extends GenericHibernateRepository<SdIntegrationConfig, Integer>
implements ISdIntegrationConfigDAO {
    @Override
    public SdIntegrationConfig getConfigByProjectIdAndConfigName(Integer projectId, String name) {
        String query = " from SdIntegrationConfig where projectId  = :projectId and integrationName=:integrationName ";
        String[] paramNames = new String[]{"projectId", "integrationName"};
        Object[] values = new Object[]{projectId, name};
        List configs = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdIntegrationConfig.class);
        if (configs != null && !configs.isEmpty()) {
            return (SdIntegrationConfig)((Object)configs.getFirst());
        }
        return null;
    }

    @Override
    public SdIntegrationConfig getConfigIdByTemplateId(Integer templateId) {
        String query = " from SdIntegrationConfig where sdTemplate.id  = :templateId";
        String[] paramNames = new String[]{"templateId"};
        Object[] values = new Object[]{templateId};
        List configs = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdIntegrationConfig.class);
        if (configs != null && !configs.isEmpty()) {
            return (SdIntegrationConfig)((Object)configs.get(0));
        }
        return null;
    }

    @Override
    public SearchEntityResponce getIntegrationConfig(SearchRequestDTO search) {
        String query = " from SdIntegrationConfig where projectId = :projectId ";
        String countQuery = " select count(id) from SdIntegrationConfig where projectId= :projectId ";
        String[] paramNames = new String[4];
        paramNames[0] = "projectId";
        Object[] values = new Object[4];
        values[0] = search.getProjectId();
        if (search.getSearchAttribute1() != null) {
            query = query.concat(" and sdTemplate.id=:template");
            countQuery = countQuery.concat(" and sdTemplate.id=:template");
            paramNames[1] = "template";
            values[1] = Integer.parseInt(search.getSearchAttribute1());
        }
        return this.hibernateDaoOperations.findByNamedParam(query, countQuery, paramNames, values, search);
    }

    @Override
    public SdIntegrationConfig getSdIntegrationConfigByName(String name) {
        List templates = this.hibernateDaoOperations.findByProperty(SdIntegrationConfig.class, "integrationName", (Object)name);
        if (CollectionUtil.isNotEmpty(templates)) {
            return (SdIntegrationConfig)((Object)templates.get(0));
        }
        return null;
    }
}

