/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdNotificationDetailsDAO;
import com.sapphireims.itsm.dto.SdNotificationDetailsDTO;
import com.sapphireims.itsm.model.SdNotificationDetails;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class SdNotificationDetailsDAO
extends GenericHibernateRepository<SdNotificationDetails, Integer>
implements ISdNotificationDetailsDAO {
    @Override
    public List<SdNotificationDetails> getSdNotificationDetailsBySdNotificationMasterId(Integer notificationId) {
        String query = " from SdNotificationDetails where sdNotificationMaster.notificationId = :notificationId ";
        String[] paramNames = new String[]{"notificationId"};
        Object[] values = new Object[]{notificationId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdNotificationDetails.class);
    }

    @Override
    public List<SdNotificationDetailsDTO> getSdNotificationDetailsDTO(Integer notificationId1, Integer notificationId2) {
        SdNotificationDetailsDTO userMapdto;
        ArrayList<SdNotificationDetailsDTO> sdNotificationDetailsList = new ArrayList<SdNotificationDetailsDTO>();
        LinkedHashMap<Integer, String> userMap = new LinkedHashMap<Integer, String>();
        LinkedHashMap<Integer, String> infoUserMap = new LinkedHashMap<Integer, String>();
        String query = "Select parameterType AS parameterType ,parameterValue AS parameterValue from SdNotificationDetails where sdNotificationMaster.notificationId=:notificationId1 OR sdNotificationMaster.notificationId=:notificationId2";
        String[] paramNames = new String[]{"notificationId1", "notificationId2"};
        Object[] values = new Object[]{notificationId1, notificationId2};
        List detailList = this.genericHibernateDaoOperations.findByNamedParam(query, paramNames, values, SdDTOEnum.SD_NOTIFICATION_DETAILS_DTO);
        boolean isPM = false;
        boolean isCC = false;
        boolean isExtMail = false;
        for (SdNotificationDetailsDTO dto : detailList) {
            block0 : switch (dto.getParameterType()) {
                case 6: {
                    switch (dto.getParameterValue()) {
                        case "1": {
                            userMap.put(Integer.parseInt(dto.getParameterValue()), "Submitter");
                            break block0;
                        }
                        case "2": {
                            userMap.put(Integer.parseInt(dto.getParameterValue()), "Owner");
                            break block0;
                        }
                        case "3": {
                            userMap.put(Integer.parseInt(dto.getParameterValue()), "Approval Manager");
                        }
                    }
                    break;
                }
                case 7: {
                    String infouserQuery = "Select roleDisplayName from SdProjectRoles where projectRoleId=:projectRoleId";
                    String[] infoparamName = new String[]{"projectRoleId"};
                    Object[] infovalue = new Object[]{Integer.parseInt(dto.getParameterValue())};
                    String infofullNameObj = (String)this.hibernateDaoOperations.findByNamedParamUniqueResult(infouserQuery, infoparamName, infovalue, String.class);
                    if (infofullNameObj == null) break;
                    infoUserMap.put(Integer.parseInt(dto.getParameterValue()), infofullNameObj);
                    break;
                }
                case 8: {
                    SdNotificationDetailsDTO pmdto = new SdNotificationDetailsDTO();
                    pmdto.setParameterType(8);
                    pmdto.setParameterValue(dto.getParameterValue());
                    sdNotificationDetailsList.add(pmdto);
                    isPM = true;
                    break;
                }
                case 9: {
                    SdNotificationDetailsDTO extdto = new SdNotificationDetailsDTO();
                    extdto.setParameterType(9);
                    extdto.setParameterValue(dto.getParameterValue());
                    sdNotificationDetailsList.add(extdto);
                    isExtMail = true;
                    break;
                }
                case 10: {
                    SdNotificationDetailsDTO ccdto = new SdNotificationDetailsDTO();
                    ccdto.setParameterType(10);
                    ccdto.setParameterValue(dto.getParameterValue());
                    sdNotificationDetailsList.add(ccdto);
                    isCC = true;
                }
            }
        }
        if (userMap.size() > 0) {
            userMapdto = new SdNotificationDetailsDTO();
            userMapdto.setParameterType(6);
            userMapdto.setParameterValue("");
            userMapdto.setSpecificUsers(userMap);
            sdNotificationDetailsList.add(userMapdto);
        }
        if (infoUserMap.size() > 0) {
            userMapdto = new SdNotificationDetailsDTO();
            userMapdto.setParameterType(7);
            userMapdto.setParameterValue("");
            userMapdto.setInfoUsers(infoUserMap);
            sdNotificationDetailsList.add(userMapdto);
        }
        if (!isPM) {
            SdNotificationDetailsDTO pmdto = new SdNotificationDetailsDTO();
            pmdto.setParameterType(8);
            pmdto.setParameterValue("0");
            sdNotificationDetailsList.add(pmdto);
        }
        if (!isCC) {
            SdNotificationDetailsDTO ccdto = new SdNotificationDetailsDTO();
            ccdto.setParameterType(10);
            ccdto.setParameterValue("0");
            sdNotificationDetailsList.add(ccdto);
        }
        if (!isExtMail) {
            SdNotificationDetailsDTO extMaildto = new SdNotificationDetailsDTO();
            extMaildto.setParameterType(9);
            extMaildto.setParameterValue("");
            sdNotificationDetailsList.add(extMaildto);
        }
        return sdNotificationDetailsList;
    }

    @Override
    public Integer deleteSdNotificationDetails(Integer stateId) {
        String query = "SELECT notificationId FROM SdNotificationMaster WHERE forState=:forState";
        String paramName = "forState";
        Integer value = stateId;
        List notificationIds = this.hibernateDaoOperations.findByNamedParam(query, paramName, (Object)value, Integer.class);
        if (notificationIds == null || notificationIds.size() == 0) {
            notificationIds.add(0);
        }
        String deleteQuery = "delete from SdNotificationDetails where sdNotificationMaster.notificationId IN(:notificationId)";
        String[] paramNames = new String[]{"notificationId"};
        Object[] values = new Object[]{notificationIds};
        return this.hibernateDaoOperations.bulkUpdateOrDeleteByParam(deleteQuery, paramNames, values);
    }

    @Override
    public Integer deleteSdNotificationDetails(Integer notificationId, String parameterType) {
        String query = "delete from SdNotificationDetails where sdNotificationMaster.notificationId=:notificationId and parameterType=:parameterType";
        String[] paramNames = new String[]{"notificationId", "parameterType"};
        Object[] values = new Object[]{notificationId, parameterType};
        return this.hibernateDaoOperations.bulkUpdateOrDeleteByParam(query, paramNames, values);
    }
}

