/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphire.itsm.mailrouting.model.SdMailroutingconfigurationmaster;
import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdNotificationMasterDAO;
import com.sapphireims.itsm.dto.SdMailRoutingConfigurationMasterDTO;
import com.sapphireims.itsm.dto.SdNotificationMasterDTO;
import com.sapphireims.itsm.model.SdNotificationDetails;
import com.sapphireims.itsm.model.SdNotificationMaster;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import com.sapphireims.util.CollectionUtil;
import java.util.Iterator;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class SdNotificationMasterDAO
extends GenericHibernateRepository<SdNotificationMaster, Integer>
implements ISdNotificationMasterDAO {
    @Override
    public List<SdNotificationMaster> getSdNotificationMasterByProjectId(Integer projectId) {
        String query = " from SdNotificationMaster where sdProjectMaster.projectId = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdNotificationMaster.class);
    }

    @Override
    public void saveSdNotificationDetailses(List<SdNotificationDetails> sdnd) {
        if (CollectionUtil.isNotEmpty(sdnd)) {
            for (SdNotificationDetails s : sdnd) {
                this.hibernateDaoOperations.save((Object)s);
            }
        }
    }

    @Override
    public Integer getIsRuleConfiguredForState(Integer stateId) {
        int isRuleConfigured = 0;
        String query = "Select distinct forState from SdNotificationMaster where forState=:forState";
        String[] paramName = new String[]{"forState"};
        Object[] value = new Object[]{stateId};
        Object isConfigured = this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramName, value, Object.class);
        if (isConfigured != null) {
            isRuleConfigured = 1;
        }
        return isRuleConfigured;
    }

    @Override
    public SdNotificationMasterDTO getSdNotificationMasterDto(Integer stateId) {
        String query = "Select sn.templateId AS templateId,st.templateName AS templateName,sn.notificationId AS notificationId,sn.templateType AS templateType from SdNotificationMaster sn,SdNotificationTemplate st where sn.templateId=st.templateId and sn.forState=:forState and sn.templateType=0";
        String[] paramName = new String[]{"forState"};
        Object[] value = new Object[]{stateId};
        List masterList = this.genericHibernateDaoOperations.findByNamedParam(query, paramName, value, SdDTOEnum.SD_NOTIFICATION_DTO);
        SdNotificationMasterDTO sdNotificationMasterDto = null;
        if (masterList != null && masterList.size() > 0) {
            sdNotificationMasterDto = (SdNotificationMasterDTO)((Object)masterList.get(0));
        }
        String query2 = "Select sn.templateId AS infoTemplateId,st.templateName AS infoTemplateName,sn.notificationId AS infoNotificationId,sn.templateType AS templateType from SdNotificationMaster sn,SdNotificationTemplate st where sn.templateId=st.templateId and sn.forState=:forState and sn.templateType=1";
        String[] paramNames = new String[]{"forState"};
        Object[] values = new Object[]{stateId};
        List masterList2 = this.genericHibernateDaoOperations.findByNamedParam(query2, paramNames, values, SdDTOEnum.SD_NOTIFICATION_DTO);
        for (SdNotificationMasterDTO dto : masterList2) {
            if (sdNotificationMasterDto == null) {
                sdNotificationMasterDto = new SdNotificationMasterDTO();
            }
            sdNotificationMasterDto.setInfoTemplateId(dto.getInfoTemplateId());
            sdNotificationMasterDto.setInfoTemplateName(dto.getInfoTemplateName());
            sdNotificationMasterDto.setInfoNotificationId(dto.getInfoNotificationId());
        }
        return sdNotificationMasterDto;
    }

    @Override
    public Integer deleteSdNotificationMaster(Integer stateId, Integer projectId) {
        String query = "delete from SdNotificationMaster where forState=:forState and sdProjectMaster.projectId=:projectId";
        String[] paramNames = new String[]{"forState", "projectId"};
        Object[] values = new Object[]{stateId, projectId};
        return this.hibernateDaoOperations.bulkUpdateOrDeleteByParam(query, paramNames, values);
    }

    @Override
    public SdMailRoutingConfigurationMasterDTO getSdMailRoutingConfigurationMasterDTO(Integer stateId, Integer projectId) {
        Iterator iterator;
        String query = " from SdMailroutingconfigurationmaster where projectId = :projectId and stateId=:stateId and isEnabled=1";
        String[] paramNames = new String[]{"projectId", "stateId"};
        Object[] values = new Object[]{projectId, stateId};
        List sdMailRoutingConfigurationMasterList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdMailroutingconfigurationmaster.class);
        if (CollectionUtil.isNotEmpty(sdMailRoutingConfigurationMasterList) && (iterator = sdMailRoutingConfigurationMasterList.iterator()).hasNext()) {
            SdMailroutingconfigurationmaster sdmrm = (SdMailroutingconfigurationmaster)((Object)iterator.next());
            SdMailRoutingConfigurationMasterDTO sdmrcmdto = new SdMailRoutingConfigurationMasterDTO(sdmrm.getRoutingId(), sdmrm.getTitle(), sdmrm.getDescription(), sdmrm.getRuleType(), sdmrm.getConsiderPropertyFile(), sdmrm.getPropertyFile(), sdmrm.getClassFile(), sdmrm.getIsEnabled(), sdmrm.getTimePeriod(), sdmrm.getProjectId(), sdmrm.getTemplateId(), sdmrm.getStateId(), sdmrm.getSdMailroutingconfigurationRules());
            return sdmrcmdto;
        }
        return null;
    }

    @Override
    public SdNotificationMasterDTO getSdNotificationMasterDto(Integer stateId, SdProjectMaster sdp, byte templateType) {
        Iterator iterator;
        String query = " from SdNotificationMaster where sdProjectMaster.projectId = :projectId and forState=:stateId and templateType=:templateType";
        String[] paramNames = new String[]{"projectId", "stateId", "templateType"};
        Object[] values = new Object[]{sdp.getProjectId(), stateId, templateType};
        List sdNotificationMasterList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdNotificationMaster.class);
        if (CollectionUtil.isNotEmpty(sdNotificationMasterList) && (iterator = sdNotificationMasterList.iterator()).hasNext()) {
            SdNotificationMaster sdnm = (SdNotificationMaster)((Object)iterator.next());
            SdNotificationMasterDTO sdnmdto = new SdNotificationMasterDTO(sdnm, sdnm.getSdNotificationDetailses(), sdp);
            return sdnmdto;
        }
        return null;
    }

    @Override
    public void saveSdNotificationMaster(SdNotificationMaster snm) {
        this.hibernateDaoOperations.saveOrUpdate((Object)snm);
    }

    @Override
    public String getNotificationTemplateName(Integer templateId) {
        String tempName = "";
        String query = "Select templateName from SdNotificationTemplate where templateId=:templateId";
        String[] paramNames = new String[]{"templateId"};
        Object[] values = new Object[]{templateId};
        String templateName = (String)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, String.class);
        if (templateName != null) {
            tempName = templateName;
        }
        return tempName;
    }
}

