/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.google.common.collect.ImmutableMap;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdOnactionDAO;
import com.sapphireims.itsm.dto.SdOnactionDTO;
import com.sapphireims.itsm.model.SdOnaction;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class SdOnactionDAO
extends GenericHibernateRepository<SdOnaction, Integer>
implements ISdOnactionDAO {
    private static final String SQL = "SELECT  * FROM  sd_onaction WHERE  `ModuleID` IN (4,                 5,                 6) AND  `LoadOn` IN (SELECT                `SubCategoryId`               FROM                sd_subcategorymaster               WHERE                `ProjectID` = :projectId) UNION SELECT  DISTINCT oa.* FROM  sd_onaction          oa,  sd_dependent_master  dm,  sd_dependent_master  dm1 WHERE  oa.LoadOn = dm.DependentFieldID AND  oa.ValuesToLoad = dm1.DependentFieldID AND  oa.ModuleID IN (7,                  8) AND  dm.DependentFieldID IN (SELECT                           DISTINCT dm.DependentFieldID                          FROM                           sd_onaction           oa,                           sd_subcategorymaster  scm,                           sd_dependent_master   dm                          WHERE                           oa.LoadOn = scm.SubCategoryID AND                           oa.ValuesToLoad = dm.DependentFieldID AND                           oa.ModuleID IN (4,                                           5,                                           6) AND                           scm.projectid = :projectId1 AND                           scm.status = 0)";
    private static final String SQL_LINK_TICKET = "FROM SdOnaction s WHERE moduleId IN(9,10,11,13) AND valuesToLoad=:parentId";

    @Override
    public List<SdOnaction> getSdOnactionByProjectId(Integer projectId) {
        ImmutableMap ma = ImmutableMap.of((Object)"projectId", (Object)projectId, (Object)"projectId1", (Object)projectId);
        List lsts = this.hibernateDaoOperations.sqlQuery(SQL, (Map)ma, Object[].class);
        ArrayList<SdOnaction> sts = null;
        if (CollectionUtil.isNotEmpty(lsts)) {
            sts = new ArrayList<SdOnaction>(lsts.size());
            for (Object[] o : lsts) {
                Integer sno = (Integer)o[0];
                Integer moduleId = (Integer)o[1];
                Integer loadOn = (Integer)o[2];
                Integer valuesToLoad = (Integer)o[3];
                SdOnaction s = new SdOnaction(moduleId, loadOn, valuesToLoad);
                s.setSno(sno);
                sts.add(s);
            }
        }
        return sts;
    }

    @Override
    public List<SdOnaction> getSdOnactionForLinkedTicket(Integer parentId) {
        String[] paramNames = new String[]{"parentId"};
        Object[] values = new Object[]{parentId};
        return this.hibernateDaoOperations.findByNamedParam(SQL_LINK_TICKET, paramNames, values, SdOnaction.class);
    }

    @Override
    public List<SdOnaction> getSdOnactionByValuesToLoad(Integer moduleId, Integer valuesToLoad) {
        String query = " FROM SdOnaction where moduleId = :moduleId and valuesToLoad= :valuesToLoad";
        String[] params = new String[]{"moduleId", "valuesToLoad"};
        Object[] values = new Object[]{moduleId, valuesToLoad};
        List sdOnaction = this.hibernateDaoOperations.findByNamedParam(query, params, values, SdOnaction.class);
        return CollectionUtils.isNotEmpty((Collection)sdOnaction) ? sdOnaction : null;
    }

    @Override
    public SdOnaction saveSdOnaction(SdOnactionDTO sdOnactionDTO) {
        SdOnaction sdOnaction = new SdOnaction();
        sdOnaction.setModuleId(sdOnactionDTO.getModuleId());
        sdOnaction.setValuesToLoad(sdOnactionDTO.getValuesToLoad());
        sdOnaction.setLoadOn(sdOnactionDTO.getLoadOn());
        this.hibernateDaoOperations.saveOrUpdate((Object)sdOnaction);
        return sdOnaction;
    }

    @Override
    public void deleteSdOnaction(Integer moduleId, Integer valuesToLoad) {
        String query = "delete from SdOnaction where moduleId = " + moduleId + " and valuesToLoad = " + valuesToLoad;
        this.hibernateDaoOperations.deleteUpdate((Object)query);
    }
}

