/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdPrePostActionsDAO;
import com.sapphireims.itsm.dto.SdPrePostActionsDTO;
import com.sapphireims.itsm.model.SdPrePostActions;
import com.sapphireims.itsm.model.SdPrePostActionsContent;
import com.sapphireims.itsm.model.SdPrePostActionsDetails;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import com.sapphireims.util.CollectionUtil;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class SdPrePostActionsDAO
extends GenericHibernateRepository<SdPrePostActions, Integer>
implements ISdPrePostActionsDAO {
    private static final String PRE_POST_ACTION_ID = "prePostActionId";

    @Override
    public List<SdPrePostActions> getSdPrePostActionsByProjectId(Integer projectId) {
        String query = " from SdPrePostActions where sdProjectMaster.projectId = :projectId";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdPrePostActions.class);
    }

    @Override
    public void saveSdPrePostActionsDetailsDAO(List<SdPrePostActionsDetails> snd) {
        if (CollectionUtil.isNotEmpty(snd)) {
            for (SdPrePostActionsDetails s : snd) {
                this.hibernateDaoOperations.save((Object)s);
            }
        }
    }

    @Override
    public Integer getLaunchingOrder(Integer projectId) {
        int launchOrder = 0;
        String query = "Select max(launchingOrder) from SdPrePostActions where sdProjectMaster.projectId=:projectId";
        String[] paramName = new String[]{"projectId"};
        Object[] value = new Object[]{projectId};
        Integer order = (Integer)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramName, value, Integer.class);
        launchOrder = order != null ? order + 1 : 1;
        return launchOrder;
    }

    @Override
    public List<SdPrePostActionsDTO> getPrePostActionListByState(Integer stateId, Integer pageNo, Integer pageSize) {
        String query = "Select sp.id AS prePostActionId,sp.name AS name,sp.description AS description,sp.prePostAction AS prePostAction,sp.launchingOrder AS launchingOrder  from SdPrePostActions sp,SdPrePostActionsDetails spd where sp.id=spd.sdPrePostActions.id and spd.categoryId=3 and spd.categoryValue=:stateId";
        String[] paramName = new String[]{"stateId"};
        Object[] value = new Object[]{String.valueOf(stateId)};
        return this.genericHibernateDaoOperations.findByNamedParamAndPagesize(query, paramName, value, pageNo, pageSize, SdDTOEnum.SD_PREPOST_ACTIONS_DTO);
    }

    @Override
    public Long getPrePostActionListByStateCount(Integer stateId) {
        String query = "Select count(sp.id) from SdPrePostActions sp,SdPrePostActionsDetails spd where sp.id=spd.sdPrePostActions.id and spd.categoryId=3 and spd.categoryValue=:stateId";
        String[] paramName = new String[]{"stateId"};
        Object[] value = new Object[]{String.valueOf(stateId)};
        return (Long)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramName, value, Long.class);
    }

    @Override
    public SdPrePostActionsDTO getPrePostActionDetails(Integer prePostActionId) {
        String query = "Select id AS prePostActionId,name AS name,description AS description,prePostAction AS prePostAction,launchingOrder AS launchingOrder,className AS className,propertyFileName AS  propertyFileName  from SdPrePostActions where id=:prePostActionId";
        String[] paramName = new String[]{PRE_POST_ACTION_ID};
        Object[] value = new Object[]{prePostActionId};
        List sdPrePostActionsDTOList = this.genericHibernateDaoOperations.findByNamedParam(query, paramName, value, SdDTOEnum.SD_PREPOST_ACTIONS_DTO);
        SdPrePostActionsDTO sdPrePostActionsDTO = (SdPrePostActionsDTO)((Object)sdPrePostActionsDTOList.get(0));
        if (sdPrePostActionsDTO.getPrePostAction() == 1) {
            sdPrePostActionsDTO.setPrePostActionName("Pre Action");
        } else {
            sdPrePostActionsDTO.setPrePostActionName("Post Action");
        }
        String detailsQuery = "Select categoryValue from SdPrePostActionsDetails where sdPrePostActions.id=:prePostActionId and categoryId=5";
        String[] paramNames = new String[]{PRE_POST_ACTION_ID};
        Object[] values = new Object[]{prePostActionId};
        List detailsList = this.hibernateDaoOperations.findByNamedParam(detailsQuery, paramNames, values, String.class);
        if (detailsList == null || detailsList.isEmpty()) {
            sdPrePostActionsDTO.setEnableOnUpdate(0);
        } else {
            sdPrePostActionsDTO.setEnableOnUpdate(1);
        }
        if (detailsList != null && detailsList.contains("0")) {
            sdPrePostActionsDTO.setEnableAllOnUpdate(1);
        } else {
            sdPrePostActionsDTO.setEnableAllOnUpdate(0);
            String stateQuery = "Select spd.categoryValue AS categoryValue,sm.stateName AS name from SdPrePostActionsDetails spd,SdStatesMaster sm where spd.sdPrePostActions.id=:prePostActionId and spd.categoryId=5 and spd.categoryValue=sm.stateId";
            String[] paramState = new String[]{PRE_POST_ACTION_ID};
            Object[] valueState = new Object[]{prePostActionId};
            List detailsDtoList = this.genericHibernateDaoOperations.findByNamedParam(stateQuery, paramState, valueState, SdDTOEnum.SD_PREPOST_ACTIONS_DETAILS_DTO);
            sdPrePostActionsDTO.setSdPrePostActionsDetailses(detailsDtoList);
        }
        return sdPrePostActionsDTO;
    }

    @Override
    public Integer updateSdPrePostAction(SdPrePostActionsDTO prepostActionDto) {
        String query = "Update SdPrePostActions set name=:name,description=:description,prePostAction=:prePostAction,launchingOrder=:launchingOrder,className=:className,propertyFileName=:propertyFileName where id=:prePostActionId";
        String[] paramNames = new String[]{"name", "description", "prePostAction", "launchingOrder", "className", "propertyFileName", PRE_POST_ACTION_ID};
        Object[] values = new Object[]{prepostActionDto.getName(), prepostActionDto.getDescription(), prepostActionDto.getPrePostAction(), prepostActionDto.getLaunchingOrder(), prepostActionDto.getClassName(), prepostActionDto.getPropertyFileName(), prepostActionDto.getPrePostActionId()};
        return this.hibernateDaoOperations.bulkUpdateOrDeleteByParam(query, paramNames, values);
    }

    @Override
    public void saveSdPrePostActionsContentDAO(List<SdPrePostActionsContent> snd) {
        if (CollectionUtil.isNotEmpty(snd)) {
            for (SdPrePostActionsContent s : snd) {
                this.hibernateDaoOperations.save((Object)s);
            }
        }
    }
}

