/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdProjectMasterDAO;
import com.sapphireims.itsm.dao.ISdProjectRolesDetailsDAO;
import com.sapphireims.itsm.mindto.ProjectMinDTO;
import com.sapphireims.itsm.model.SdCategorymaster;
import com.sapphireims.itsm.model.SdProjectDetails;
import com.sapphireims.itsm.model.SdProjectParametersMaster;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import com.sapphireims.util.CollectionUtil;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SdProjectMasterDAO
extends GenericHibernateRepository<SdProjectMaster, Integer>
implements ISdProjectMasterDAO {
    @Autowired
    private ISdProjectRolesDetailsDAO sdProjectRolesDetailsDAO;

    @Override
    public List<SdProjectDetails> getProjectDetails(Integer projectId) {
        String query = " from SdProjectDetails where sdProjectMaster.projectId = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdProjectDetails.class);
    }

    @Override
    public List<SdProjectMaster> getAllProject() {
        String query = " from SdProjectMaster where status = 0";
        String[] paramNames = new String[]{};
        Object[] values = new Object[]{};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdProjectMaster.class);
    }

    @Override
    public SdProjectParametersMaster getProjectParametersMasterById(Integer parameterId) {
        return (SdProjectParametersMaster)this.hibernateDaoOperations.get(SdProjectParametersMaster.class, (Serializable)parameterId);
    }

    @Override
    public void saveSdProjectDetails(List<SdProjectDetails> projectDetails) {
        if (CollectionUtil.isNotEmpty(projectDetails)) {
            for (SdProjectDetails s : projectDetails) {
                this.hibernateDaoOperations.save((Object)s);
            }
        }
    }

    @Override
    public SdProjectMaster getSdProjectDetailsByName(String projectName) {
        String query = " from SdProjectMaster where projectName = :projectName ";
        String[] paramNames = new String[]{"projectName"};
        Object[] values = new Object[]{projectName};
        List projects = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdProjectMaster.class);
        if (CollectionUtil.isNotEmpty(projects)) {
            return (SdProjectMaster)((Object)projects.getFirst());
        }
        return null;
    }

    @Override
    public List<ProjectMinDTO> getAllUsersProjects(Integer userId) {
        String query = "SELECT DISTINCT  sdrd.sdProjectRoles.sdProjectMaster.projectId AS id ,  sdrd.sdProjectRoles.sdProjectMaster.projectName as name  FROM   SdProjectRolesDetails sdrd    INNER JOIN sdrd.sdProjectRoles     WHERE sdrd.userId = :userId   AND sdrd.sdProjectRoles.sdProjectMaster.status = 0    ORDER BY sdrd.sdProjectRoles.sdProjectMaster.projectName DESC ";
        String[] paramNames = new String[]{"userId"};
        Object[] values = new Object[]{userId};
        return this.genericHibernateDaoOperations.findByNamedParam(query, paramNames, values, SdDTOEnum.PROJECT_MIN_DTO);
    }

    @Override
    public SdProjectMaster getProjectMaster(Integer projectId) {
        String query = " from SdProjectMaster where projectId = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return (SdProjectMaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdProjectMaster.class));
    }

    @Override
    public List<Object[]> getAllSDDefaultRoles() {
        Session session = this.hibernateDaoOperations.getSessionFactory().getCurrentSession();
        String sql = "SELECT sd.ProjectId,sd.ParameterValue FROM sd_project_details sd INNER JOIN sd_project_master sm ON sd.ProjectId = sm.ProjectId WHERE sd.ParameterID =2 AND sm.Status=0";
        NativeQuery query = session.createNativeQuery(sql, Object[].class);
        return query.list();
    }

    @Override
    public List<ProjectMinDTO> getAllUsersProjectsBasedOnDisplayOrder(Integer userId) {
        String query = "SELECT DISTINCT  sdrd.sdProjectRoles.sdProjectMaster.projectId AS id ,  sdrd.sdProjectRoles.sdProjectMaster.projectName as name, sdrd.sdProjectRoles.sdProjectMaster.image AS image, spd.parameterValue AS projectType FROM   SdProjectRolesDetails sdrd, SdProjectDetails spd INNER JOIN sdrd.sdProjectRoles     WHERE sdrd.userId = :userId   AND sdrd.sdProjectRoles.sdProjectMaster.status = 0  AND spd.sdProjectMaster.projectId = sdrd.sdProjectRoles.sdProjectMaster.projectId AND spd.sdProjectParametersMaster.parameterId = 3  ORDER BY sdrd.sdProjectRoles.sdProjectMaster.displayOrder ";
        String[] paramNames = new String[]{"userId"};
        Object[] values = new Object[]{userId};
        return this.genericHibernateDaoOperations.findByNamedParam(query, paramNames, values, SdDTOEnum.PROJECT_MIN_DTO);
    }

    @Override
    public List<SdProjectDetails> getProjectDetailsByProjectIds(List<Integer> projectId) {
        String query = " from SdProjectDetails where sdProjectMaster.projectId in (:projectId) ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdProjectDetails.class);
    }

    @Override
    public void populateDefaultRoles(int userId) {
        List<Object[]> defaultRoles = this.getAllSDDefaultRoles();
        for (Object[] obj : defaultRoles) {
            String s = String.valueOf(obj[1]);
            this.sdProjectRolesDetailsDAO.saveSdprojectRoleDetails(userId, Integer.parseInt(s));
        }
    }

    @Override
    public void deleteSdProjectDetails(int projectId) {
        String query = " SdProjectDetails where sdProjectMaster.projectId = :projectId and sdProjectParametersMaster.parameterId=6";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        SdProjectDetails sdProjectDetails = (SdProjectDetails)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdProjectDetails.class));
        this.hibernateDaoOperations.delete(this.hibernateDaoOperations.get(SdCategorymaster.class, (Serializable)sdProjectDetails.getProjectDetailsId()));
    }
}

