/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphire.itsm.mailrouting.model.SdProjectRoles;
import com.sapphire.itsm.mailrouting.model.SdProjectRolesAccess;
import com.sapphire.itsm.mailrouting.model.SdProjectRolesDetails;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdProjectRolesDAO;
import com.sapphireims.itsm.dto.SdProjectRolesDTO;
import com.sapphireims.itsm.mindto.ProjectRolesMinDTO;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import com.sapphireims.util.CollectionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.MutationQuery;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SdProjectRolesDAO
extends GenericHibernateRepository<SdProjectRoles, Integer>
implements ISdProjectRolesDAO {
    @Override
    public List<SdProjectRoles> getSdServiceByProjectId(Integer projectId) {
        String query = " from SdProjectRoles where sdProjectMaster.projectId = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdProjectRoles.class);
    }

    @Override
    public List<Integer> getSdProjectRoleIdByUserId(Integer userId) {
        String query = " Select distinct sd.projectRoleId from SdProjectRoles sd,SdProjectRolesDetails sdpr where sdpr.userId=:userId and sdpr.sdProjectRoles.projectRoleId = sd.projectRoleId";
        String[] paramNames = new String[]{"userId"};
        Object[] values = new Object[]{userId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, Integer.class);
    }

    @Override
    public void saveSdProjectRolesAccess(List<SdProjectRolesAccess> roleACess) {
        if (CollectionUtil.isNotEmpty(roleACess)) {
            for (SdProjectRolesAccess sd : roleACess) {
                this.hibernateDaoOperations.save((Object)sd);
            }
        }
    }

    @Override
    public List<ProjectRolesMinDTO> getSdProjectRolesMinDataByProject(Integer projectId) {
        String query = "Select projectRoleId AS id,roleDisplayName AS name from SdProjectRoles where sdProjectMaster.projectId = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.genericHibernateDaoOperations.findByNamedParam(query, paramNames, values, SdDTOEnum.PROJECT_ROLE_MIN_DTO);
    }

    @Override
    public List<ProjectRolesMinDTO> getSdProjectRolesMinDataByProjectAndRoleName(Integer projectId, String roleName) {
        String query = "Select projectRoleId AS id,roleDisplayName AS name from SdProjectRoles where sdProjectMaster.projectId =:projectId and roleName=:roleName order by roleDisplayName";
        String[] paramNames = new String[]{"projectId", "roleName"};
        Object[] values = new Object[]{projectId, roleName};
        return this.genericHibernateDaoOperations.findByNamedParam(query, paramNames, values, SdDTOEnum.PROJECT_ROLE_MIN_DTO);
    }

    @Override
    public List<ProjectRolesMinDTO> getSdProjectRolesByWorkflow(String stateMovementId) {
        String roleQuery = "Select sd.workflowCategoryValue from SdWorkFlowDetail sd where  sd.workflowCategoryId=3 and sd.sdWorkFlowMaster.stateMovementID=:stateMovementId";
        String paramNames = "stateMovementId";
        Integer values = Integer.parseInt(stateMovementId);
        List roleList = this.hibernateDaoOperations.findByNamedParam(roleQuery, paramNames, (Object)values, Integer.class);
        String query = "Select projectRoleId AS projectRoleId,roleDisplayName AS roleDisplayName from SdProjectRoles where projectRoleId IN(:roleList)";
        String[] paramnameArray = new String[]{"roleList"};
        Object[] valueArray = new Object[]{roleList};
        return this.genericHibernateDaoOperations.findByNamedParam(query, paramnameArray, valueArray, SdDTOEnum.PROJECT_ROLE_MIN_DTO);
    }

    @Override
    @Transactional(readOnly=true)
    public Integer checkIsDuplicateRole(String roleDisplayName, Integer projectId) {
        Integer isDuplicate = 0;
        String query = "SELECT roleDisplayName FROM SdProjectRoles WHERE  sdProjectMaster.projectId=:projectId and roleDisplayName=:roleDisplayName";
        String[] paramNames = new String[]{"projectId", "roleDisplayName"};
        Object[] values = new Object[]{projectId, roleDisplayName};
        List roleList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, String.class);
        if (roleList != null && roleList.size() > 0) {
            isDuplicate = 1;
        }
        return isDuplicate;
    }

    @Override
    @Transactional(readOnly=true)
    public String getRoleNameForID(Integer roleId) {
        String sbName = "";
        String query = "select roleDisplayName FROM SdProjectRoles WHERE projectRoleId=:roleId";
        String[] paramNames = new String[]{"roleId"};
        Object[] values = new Object[]{roleId};
        String subCatName = (String)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, String.class);
        if (subCatName != null) {
            sbName = subCatName;
        }
        return sbName;
    }

    @Override
    public List<SdProjectRoles> getProjectRoleIdsForUserIdProjectIds(List<Integer> projectIds, Integer userId) {
        ArrayList<SdProjectRoles> rolesList = new ArrayList<SdProjectRoles>(1);
        String query = "FROM SdProjectRoles WHERE sdProjectMaster.projectId in (:projectIds) and sdProjectMaster.status = 0";
        String[] paramNames = new String[]{"projectIds"};
        Object[] values = new Object[]{projectIds};
        List roles = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdProjectRoles.class);
        if (CollectionUtil.isNotEmpty(roles)) {
            block0: for (SdProjectRoles role : roles) {
                Set<SdProjectRolesDetails> details = role.getSdProjectRolesDetailses();
                if (!CollectionUtil.isNotEmpty(details)) continue;
                for (SdProjectRolesDetails detail : details) {
                    if (detail.getUserId() != userId.intValue()) continue;
                    rolesList.add(role);
                    continue block0;
                }
            }
        }
        return rolesList;
    }

    @Override
    public List<SdProjectRoles> getSdServiceByProjectId(Integer projectId, Integer pageNo, Integer pageSize, String columnSort, String sortDir) {
        Object query = " from SdProjectRoles where sdProjectMaster.projectId = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        query = (String)query + " order by " + columnSort + " " + sortDir;
        return this.genericHibernateDaoOperations.findByNamedParamAndPagesize((String)query, paramNames, values, pageNo, pageSize, SdDTOEnum.SD_PROJECT_ROLES);
    }

    @Override
    public SdProjectRoles getProjectRoleDetailsByRoleId(Integer roleId) {
        String sbName = "";
        String query = " FROM SdProjectRoles WHERE projectRoleId=:roleId";
        String[] paramNames = new String[]{"roleId"};
        Object[] values = new Object[]{roleId};
        return (SdProjectRoles)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdProjectRoles.class));
    }

    @Override
    public List<String> getProjectRoleIdsForUserIdProjectId(Integer projectId, Integer userId) {
        String query = "select sr.roleDisplayName FROM SdProjectRoles sr, SdProjectRolesDetails sd WHERE sr.sdProjectMaster.projectId =:projectId and sr.projectRoleId = sd.sdProjectRoles.projectRoleId and sd.userId = :userId";
        String[] paramNames = new String[]{"projectId", "userId"};
        Object[] values = new Object[]{projectId, userId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, String.class);
    }

    @Override
    public List<Integer> getProjectUserIdsForRoleIdProjectId(Integer projectId, Integer roleId) {
        String query = "select sd.userId FROM SdProjectRoles sr, SdProjectRolesDetails sd WHERE sr.sdProjectMaster.projectId =:projectId and sr.projectRoleId = sd.sdProjectRoles.projectRoleId and sd.sdProjectRoles.projectRoleId = :roleId";
        String[] paramNames = new String[]{"projectId", "roleId"};
        Object[] values = new Object[]{projectId, roleId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, Integer.class);
    }

    @Override
    public Integer getDefaultRoleId(int projectId) {
        Integer defaultServiceID = 0;
        String query = "SELECT sd.parameterValue FROM SdProjectDetails sd WHERE sd.sdProjectParametersMaster.parameterId = 2 AND sd.sdProjectMaster.projectId = :projectId";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        List serviceList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, String.class);
        if (serviceList != null && serviceList.size() > 0) {
            defaultServiceID = Integer.parseInt((String)serviceList.get(0));
        }
        return defaultServiceID;
    }

    @Override
    @Transactional(readOnly=true)
    public SdProjectRoles getServiceByProjectIdAndRolesId(Integer rolesId, Integer projectId) {
        String query = " from SdProjectRoles where sdProjectMaster.projectId = :projectId and projectRoleId =:rolesId";
        String[] paramNames = new String[]{"projectId", "rolesId"};
        Object[] values = new Object[]{projectId, rolesId};
        List services = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdProjectRoles.class);
        return services != null && !services.isEmpty() ? (SdProjectRoles)((Object)services.get(0)) : null;
    }

    @Override
    @Transactional
    public SdProjectRoles saveRolesDescription(Integer rolesId, String rolesDescription) {
        SdProjectRoles SdProjectRoles2 = (SdProjectRoles)((Object)this.hibernateDaoOperations.get(SdProjectRoles.class, (Serializable)rolesId));
        SdProjectRoles2.setRoleDescription(rolesDescription);
        this.hibernateDaoOperations.saveOrUpdate((Object)SdProjectRoles2);
        return SdProjectRoles2;
    }

    @Override
    @Transactional
    public SdProjectRoles updateRolesName(SdProjectRolesDTO projectRolesDTO, Integer projectId) {
        SdProjectRoles projectRoles = (SdProjectRoles)((Object)this.hibernateDaoOperations.get(SdProjectRoles.class, (Serializable)projectRolesDTO.getProjectRoleId()));
        projectRoles.setRoleDisplayName(projectRolesDTO.getRoleDisplayName());
        this.hibernateDaoOperations.saveOrUpdate((Object)projectRoles);
        return projectRoles;
    }

    @Override
    @Transactional
    public SdProjectRoles saveRoles(SdProjectRolesDTO projectRolesDTO, Integer projectId) {
        SdProjectRoles projectRoles = new SdProjectRoles();
        projectRoles.setRoleDisplayName(projectRolesDTO.getRoleDisplayName());
        projectRoles.setRoleDescription(projectRolesDTO.getRoleDescription());
        projectRoles.setRoleName(projectRolesDTO.getRoleName());
        SdProjectMaster sdProjectMaster = (SdProjectMaster)((Object)this.hibernateDaoOperations.get(SdProjectMaster.class, (Serializable)projectId));
        projectRoles.setSdProjectMaster(sdProjectMaster);
        this.hibernateDaoOperations.saveOrUpdate((Object)projectRoles);
        return projectRoles;
    }

    @Override
    @Transactional
    public void deleteRoles(int rolesId) {
        this.hibernateDaoOperations.delete(this.hibernateDaoOperations.get(SdProjectRoles.class, (Serializable)Integer.valueOf(rolesId)));
    }

    @Override
    @Transactional
    public List<SdProjectRoles> getCopyFromByRoleName(String roleName, Integer projectId) {
        String query = "FROM SdProjectRoles sdc where sdc.sdProjectMaster.projectId = :projectId AND  sdc.roleName=:roleName";
        String[] params = new String[]{"projectId", "roleName"};
        Object[] values = new Object[]{projectId, roleName};
        return this.hibernateDaoOperations.findByNamedParam(query, params, values, SdProjectRoles.class);
    }

    @Override
    @Transactional
    public SdProjectRoles saveRolesInheritFrom(Integer rolesId, String rolesName) {
        SdProjectRoles SdProjectRoles2 = (SdProjectRoles)((Object)this.hibernateDaoOperations.get(SdProjectRoles.class, (Serializable)rolesId));
        SdProjectRoles2.setRoleName(rolesName);
        this.hibernateDaoOperations.saveOrUpdate((Object)SdProjectRoles2);
        return SdProjectRoles2;
    }

    @Override
    public String getRoleNameByRoleId(int projectId) {
        String defaultrolesName = "";
        String query = "select sr.roleDisplayName from Sd_Project_Roles sr, Sd_Project_Details sd where cast(sd.parameterValue as unsigned) = sr.projectRoleId and sr.projectId = :projectId and sd.parameterId = 2";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        List rolesName = this.hibernateDaoOperations.findByNamedParamSql(query, paramNames, values, String.class);
        if (rolesName != null && rolesName.size() > 0) {
            defaultrolesName = (String)rolesName.get(0);
        }
        return defaultrolesName;
    }

    @Override
    @Transactional
    public void deleteDefaultRoles(int projectId) {
        String query = " delete  SdProjectDetails where sdProjectParametersMaster.parameterId = 2 AND sdProjectMaster.projectId = " + projectId;
        this.hibernateDaoOperations.deleteUpdate((Object)query);
    }

    @Override
    @Transactional
    public void setDefaultRoleId(int projectId, int rolesId) {
        Session session = this.hibernateDaoOperations.getSessionFactory().getCurrentSession();
        String sql = "insert into sd_project_details(ProjectID, ParameterID, ParameterValue) values (:projectId,2,:rolesId)";
        MutationQuery query = session.createNativeMutationQuery(sql);
        query.setParameter("projectId", (Object)projectId);
        query.setParameter("rolesId", (Object)rolesId);
        query.executeUpdate();
    }

    @Transactional
    public List getDefaultRoleList(Integer projectId) {
        String query = "SELECT sdc.projectRoleId FROM SdProjectRoles sdc where sdc.sdProjectMaster.projectId = :projectId AND  sdc.roleName != 'Submitter'";
        String[] params = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, params, values, Integer.class);
    }

    @Override
    public List<SdProjectRoles> getRolesNameByWorkgroupId(Integer workGroupID) {
        String query = " SELECT sp.* FROM Sd_Workgroupdetails sw,sd_project_roles sp where sp.projectRoleId= sw.workGroupValue and sw.workGroupType=6 and sw.workGroupId=:workGroupID";
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("workGroupID", workGroupID);
        return this.hibernateDaoOperations.sqlQuery(query, paramMap, SdProjectRoles.class);
    }

    @Override
    public List<SdProjectRoles> getRolesByRolesNames(Integer projectId) {
        String query = "FROM SdProjectRoles WHERE roleName IN ('Technician', 'Approval Manager') AND sdProjectMaster.projectId = :projectId ORDER BY roleDisplayName";
        String[] params = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, params, values, SdProjectRoles.class);
    }

    @Override
    public List<SdProjectRoles> getRoleListByRole(List<Integer> roleIdList) {
        String query = "from SdProjectRoles where projectRoleId in(:roleIdList)";
        String[] paramNames = new String[]{"roleIdList"};
        Object[] values = new Object[]{roleIdList};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdProjectRoles.class);
    }

    @Override
    public List<SdProjectRoles> getRolesNameByRoleIds(List<Integer> rolesIdList, Integer projectId) {
        String query = "from SdProjectRoles where sdProjectMaster.projectId = :projectId and projectRoleId in(:rolesIdList)";
        String[] paramNames = new String[]{"projectId", "rolesIdList"};
        Object[] values = new Object[]{projectId, rolesIdList};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdProjectRoles.class);
    }
}

