/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.google.common.collect.ImmutableMap;
import com.sapphire.itsm.mailrouting.model.SdProjectRolesDetails;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdProjectRolesDetailsDAO;
import com.sapphireims.util.CollectionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.MutationQuery;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SdProjectRolesDetailsDAO
extends GenericHibernateRepository<SdProjectRolesDetails, Integer>
implements ISdProjectRolesDetailsDAO {
    private static final String SQL = "SELECT   pr.ProjectRoleID FROM  sd_project_roles_details prd,  sd_project_roles pr WHERE prd.ProjectRoleID = pr.ProjectRoleID AND pr.ProjectID=:projectId AND prd.UserID=:userId";

    @Override
    public List<Integer> getProjectRoleIdForUser(Integer userId, Integer projectId) {
        ImmutableMap ma = ImmutableMap.of((Object)"userId", (Object)userId, (Object)"projectId", (Object)projectId);
        List lsts = this.hibernateDaoOperations.sqlQuery(SQL, (Map)ma, Integer.class);
        ArrayList sts = null;
        if (CollectionUtil.isNotEmpty(lsts)) {
            sts = new ArrayList(lsts.size());
            sts.addAll(lsts);
        }
        return sts;
    }

    @Override
    public void saveSdprojectRoleDetails(int userId, int roleId) {
        Session session = this.hibernateDaoOperations.getSessionFactory().getCurrentSession();
        String sql = "insert into sd_project_roles_details(ProjectRoleID, UserID) values (:role,:userId)";
        MutationQuery query = session.createNativeMutationQuery(sql);
        query.setParameter("role", (Object)roleId);
        query.setParameter("userId", (Object)userId);
        query.executeUpdate();
    }

    @Override
    public List<SdProjectRolesDetails> getAllSdProjectRolesofUser(int userId) {
        String query = "From SdProjectRolesDetails where userId = :userId";
        String[] params = new String[]{"userId"};
        Object[] values = new Object[]{userId};
        return this.hibernateDaoOperations.findByNamedParam(query, params, values, SdProjectRolesDetails.class);
    }

    @Override
    public List<SdProjectRolesDetails> getAllUsersBasedonRole(int roleId) {
        String query = "From SdProjectRolesDetails where sdProjectRoles.projectRoleId = :roleId";
        String[] params = new String[]{"roleId"};
        Object[] values = new Object[]{roleId};
        return this.hibernateDaoOperations.findByNamedParam(query, params, values, SdProjectRolesDetails.class);
    }

    @Override
    public void deleteSdProjectRoleDetails(Integer projectId, Integer userId) {
        String query = "select sd.roleDetailsId FROM SdProjectRoles sr, SdProjectRolesDetails sd WHERE sr.sdProjectMaster.projectId =:projectId and sr.projectRoleId = sd.sdProjectRoles.projectRoleId and sd.userId = :userId";
        String[] paramNames = new String[]{"projectId", "userId"};
        Object[] values = new Object[]{projectId, userId};
        List roleDetailsIdList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, Integer.class);
        for (Integer roleDetailsId : roleDetailsIdList) {
            this.hibernateDaoOperations.delete(this.hibernateDaoOperations.get(SdProjectRolesDetails.class, (Serializable)roleDetailsId));
        }
    }

    @Override
    @Transactional
    public void deleteRolesDetails(int rolesId) {
        SdProjectRolesDetails sdProjectRolesDetails = (SdProjectRolesDetails)((Object)this.hibernateDaoOperations.get(SdProjectRolesDetails.class, (Serializable)Integer.valueOf(rolesId)));
        if (sdProjectRolesDetails != null) {
            this.hibernateDaoOperations.delete((Object)sdProjectRolesDetails);
        }
    }
}

