/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdRequestNumberFormatDAO;
import com.sapphireims.itsm.model.SdRequestnumberformat;
import com.sapphireims.itsm.model.SdServiceReqMaster;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class SdRequestNumberFormatDAO
extends GenericHibernateRepository<SdRequestnumberformat, Integer>
implements ISdRequestNumberFormatDAO {
    public static final Logger logger = LoggerFactory.getLogger((String)"ims");
    public static final String PARENT_ID = "parentId";
    public static final String PROJECT_ID = "projectId";

    @Override
    public List<SdRequestnumberformat> getSdRecordNumberFormatByProjectId(Integer projectId) {
        String query = " from SdRequestnumberformat where sdProjectMaster.projectId = :projectId ";
        String[] paramNames = new String[]{PROJECT_ID};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdRequestnumberformat.class);
    }

    @Override
    public int getLastIncrementedRequestNumber(int noOfDigits, int projectId) {
        int highestRequestId = 0;
        try {
            String sql = "SELECT RIGHT(requestId, :noOfDigits) FROM sd_servicereqmaster WHERE projectId = :projectId AND RIGHT(requestId, :noOfDigits) REGEXP '^[0-9]+$' AND RIGHT(requestId, :noOfDigits + 1) REGEXP '[^a-zA-Z0-9]' ORDER BY problemId DESC ";
            NativeQuery query = this.hibernateDaoOperations.getSessionFactory().getCurrentSession().createNativeQuery(sql, Object.class).setParameter(PROJECT_ID, (Object)projectId).setParameter("noOfDigits", (Object)noOfDigits);
            query.setMaxResults(1);
            List result = query.list();
            if (result != null && !result.isEmpty()) {
                highestRequestId = Integer.parseInt(result.getFirst().toString());
            }
        }
        catch (Exception ex) {
            logger.error("SdRequestNumberFormatDAO :: (--Exception Caught- ) occurred in getLastIncrementedRequestNumber {}", (Object)ex.getMessage(), (Object)ex);
        }
        return highestRequestId;
    }

    @Override
    public SdServiceReqMaster getSdServiceReqMaster(int projectId, int parentId, int currentProblemId) {
        try {
            Query query = this.hibernateDaoOperations.getSessionFactory().getCurrentSession().createQuery("from SdServiceReqMaster where sdProjectMaster.projectId=:projectId and parentId=:parentId and problemId!=:problemId order by problemId desc", SdServiceReqMaster.class);
            query.setParameter(PROJECT_ID, (Object)projectId);
            query.setParameter(PARENT_ID, (Object)parentId);
            query.setParameter("problemId", (Object)currentProblemId);
            query.setMaxResults(1);
            return (SdServiceReqMaster)((Object)query.list().getFirst());
        }
        catch (Exception e) {
            logger.error("SdRequestNumberFormatDAO :: (--Exception Caught--) occurred in getSdServiceReqMaster {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    @Override
    public SdServiceReqMaster getSdServiceReqBasedOnRequestFormat(int projectId, String prefix, int requestFormatLength, int parentId) {
        try {
            String hqlQuery = prefix.isEmpty() ? "from SdServiceReqMaster sm WHERE sdProjectMaster.projectId=:projectId and parentId = :parentId AND LENGTH(requestId) >= :reqFormatLength order BY problemId DESC" : (parentId == 0 ? "from SdServiceReqMaster where sdProjectMaster.projectId=:projectId and parentId = :parentId AND requestId LIKE :requestId and LENGTH(requestId) = :reqFormatLength order BY problemId DESC" : "from SdServiceReqMaster where sdProjectMaster.projectId=:projectId and parentId = :parentId AND requestId LIKE :requestId order BY problemId DESC");
            Query query = this.hibernateDaoOperations.getSessionFactory().getCurrentSession().createQuery(hqlQuery, SdServiceReqMaster.class);
            query.setParameter(PROJECT_ID, (Object)projectId);
            query.setParameter(PARENT_ID, (Object)parentId);
            if (prefix.isEmpty()) {
                query.setParameter("reqFormatLength", (Object)requestFormatLength);
            } else {
                query.setParameter("requestId", (Object)(prefix + "%"));
                if (parentId == 0) {
                    query.setParameter("reqFormatLength", (Object)requestFormatLength);
                }
            }
            query.setMaxResults(1);
            return (SdServiceReqMaster)((Object)query.uniqueResult());
        }
        catch (Exception ex) {
            logger.error("SdRequestNumberFormatDAO :: (--Exception Caught--) occurred in getSdServiceReqBasedOnRequestFormat", (Throwable)ex);
            return null;
        }
    }

    @Override
    public int updateSdRequestNumberFormat(int noOfDigits, int projectId) {
        int status = 0;
        try {
            MutationQuery qry = this.hibernateDaoOperations.getSessionFactory().getCurrentSession().createMutationQuery("update SdRequestnumberformat  set noOfDigits =:noOfDigits where sdProjectMaster.projectId=:projectId");
            qry.setParameter(noOfDigits, (Object)noOfDigits);
            qry.setParameter(projectId, (Object)projectId);
            status = qry.executeUpdate();
        }
        catch (NullPointerException | HibernateException he) {
            logger.error("SdRequestNumberFormatDAO :: (--Exception Caught- ) occured in updateSdRequestNumberFormat {}", (Object)he.getMessage(), (Object)he);
        }
        return status;
    }

    @Override
    public int getLastProblemId(int projectId, int parentId) {
        int problemId = 0;
        try {
            Integer max = (Integer)this.hibernateDaoOperations.findByNamedParamUniqueResult("select max(problemId) from SdServiceReqMaster where sdProjectMaster.projectId=:projectId and parentId=:parentId", new String[]{PROJECT_ID, PARENT_ID}, new Object[]{projectId, parentId}, Integer.class);
            if (max != null) {
                problemId = max;
            }
        }
        catch (Exception ex) {
            logger.error("SdRequestNumberFormatDAO :: (--Exception Caught--) occured in getLastProblemId {}", (Object)ex.getMessage(), (Object)ex);
        }
        return problemId;
    }

    @Override
    public String getSiteName(Integer siteId) {
        String siteName = "";
        try {
            String query = "select siteName from Sitemaster where siteId=:siteId";
            String[] paramNames = new String[]{"siteId"};
            Object[] values = new Object[]{siteId};
            String siteNameObj = (String)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, String.class);
            if (siteNameObj != null) {
                siteName = siteNameObj;
            }
        }
        catch (Exception e) {
            logger.error("SdRequestNumberFormatDAO :: (--Exception Caught--) occured in getSiteName {}", (Object)e.getMessage(), (Object)e);
        }
        return siteName;
    }

    @Override
    public void savePrefix(Integer requestFormatId, String prefix) {
        SdRequestnumberformat sdRequestnumberformat = (SdRequestnumberformat)((Object)this.hibernateDaoOperations.get(SdRequestnumberformat.class, (Serializable)requestFormatId));
        sdRequestnumberformat.setPrefix(prefix);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdRequestnumberformat);
    }

    @Override
    public String getInventoryFieldValue(Integer systemId, Integer siteId) {
        String systemName = "";
        try {
            String query = "select HostName from Inventorymaster where id.systemId =:systemId and id.siteId=:siteId";
            String[] paramNames = new String[]{"siteId"};
            Object[] values = new Object[]{siteId};
            String systemObj = (String)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, String.class);
            if (systemObj != null) {
                systemName = systemObj;
            }
            return systemName;
        }
        catch (Exception e) {
            logger.error("SdRequestNumberFormatDAO :: (--Exception Caught--) occurred in getInventoryFieldValue {}", (Object)e.getMessage(), (Object)e);
            return systemName;
        }
    }

    @Override
    public void saveNumberOfDigits(Integer noOfDigits, Integer requestFormatId) {
        SdRequestnumberformat sdRequestnumberformat = (SdRequestnumberformat)((Object)this.hibernateDaoOperations.get(SdRequestnumberformat.class, (Serializable)requestFormatId));
        sdRequestnumberformat.setNoOfDigits(noOfDigits);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdRequestnumberformat);
    }

    @Override
    public void saveStartFrom(Integer requestFormatId, String startFrom) {
        SdRequestnumberformat sdRequestnumberformat = (SdRequestnumberformat)((Object)this.hibernateDaoOperations.get(SdRequestnumberformat.class, (Serializable)requestFormatId));
        sdRequestnumberformat.setStartFrom(startFrom);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdRequestnumberformat);
    }

    @Override
    public void saveConsiderPrefixforIncrement(Integer requestFormatId, Short considerforIncrement) {
        SdRequestnumberformat sdRequestnumberformat = (SdRequestnumberformat)((Object)this.hibernateDaoOperations.get(SdRequestnumberformat.class, (Serializable)requestFormatId));
        sdRequestnumberformat.setConsiderPrefixForIncrementParent(considerforIncrement);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdRequestnumberformat);
    }
}

