/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdRequestTrackerDAO;
import com.sapphireims.itsm.model.SdRequestTracker;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SdRequestTrackerDAO
extends GenericHibernateRepository<SdRequestTracker, Integer>
implements ISdRequestTrackerDAO {
    public static final Logger logger = LoggerFactory.getLogger((String)"ims");

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public SdRequestTracker findLatestByProjectId(int projectId, String prefix) {
        SdRequestTracker srt = null;
        try {
            logger.info("------11------inside SdRequestTrackerDAO");
            Session session = this.hibernateDaoOperations.getSessionFactory().getCurrentSession();
            logger.info("Is transaction active? :: " + session.getTransaction().isActive());
            String hql = "FROM SdRequestTracker s WHERE s.projectId = :projectId AND s.lastRequestId LIKE :prefix ORDER BY s.id DESC";
            Query query1 = session.createQuery(hql, SdRequestTracker.class).setParameter("projectId", (Object)projectId).setParameter("prefix", (Object)(prefix + "%")).setMaxResults(1);
            srt = (SdRequestTracker)((Object)query1.uniqueResult());
            if (srt == null) {
                logger.info("No tracker entry found, returning null");
            }
            logger.info("------------inside SdRequestTrackerDAO 1 srt :: " + String.valueOf((Object)srt));
            if (srt != null) {
                String query = "FROM SdRequestTracker s WHERE s.projectId = :projectId AND s.lastRequestId LIKE :prefix ORDER BY s.id DESC";
                Query hqlQuery = this.hibernateDaoOperations.getSessionFactory().getCurrentSession().createQuery(query, SdRequestTracker.class).setParameter("projectId", (Object)projectId).setParameter("prefix", (Object)prefix).setMaxResults(1).setLockMode("s", LockMode.PESSIMISTIC_WRITE);
                logger.info("------------inside SdRequestTrackerDAO hqlQuery :: " + String.valueOf(hqlQuery));
                srt = (SdRequestTracker)((Object)hqlQuery.uniqueResult());
            }
            logger.info("------------inside SdRequestTrackerDAO 2 srt :: " + String.valueOf((Object)srt));
        }
        catch (Exception ex) {
            logger.error("SdRequestTrackerDAO :: (--Exception Caught- ) occured in findLatestByProjectId" + ex.getMessage());
            ex.printStackTrace();
        }
        return srt;
    }
}

