/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdServiceDAO;
import com.sapphireims.itsm.dto.SdServiceDTO;
import com.sapphireims.itsm.mindto.ServiceMinDTO;
import com.sapphireims.itsm.model.SdService;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SdServiceDAO
extends GenericHibernateRepository<SdService, Integer>
implements ISdServiceDAO {
    private static final String PROJECT_ID = "projectId";

    @Override
    public List<SdService> getSdServiceByProjectId(Integer projectId) {
        String query = " from SdService where sdProjectMaster.projectId = :projectId and status=0";
        String[] paramNames = new String[]{PROJECT_ID};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdService.class);
    }

    @Override
    @Transactional(readOnly=true)
    public SdService getServiceByProjectIdAndServiceId(Integer serviceId, Integer projectId) {
        String query = " from SdService where sdProjectMaster.projectId = :projectId and serviceId =:serviceId";
        String[] paramNames = new String[]{PROJECT_ID, "serviceId"};
        Object[] values = new Object[]{projectId, serviceId};
        List services = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdService.class);
        return services != null && !services.isEmpty() ? (SdService)((Object)services.get(0)) : null;
    }

    @Override
    public List<SdService> getServiceNameByWorkgroupId(Integer workGroupID) {
        String query = "SELECT ss.* FROM Sd_Workgroupdetails sw JOIN Sd_Service ss ON ss.serviceid = CAST(sw.WorkGroupValue AS UNSIGNED) WHERE sw.WorkGroupType = 1 AND sw.workgroupid = :workGroupID";
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("workGroupID", workGroupID);
        return this.hibernateDaoOperations.sqlQuery(query, paramMap, SdService.class);
    }

    @Override
    public List<ServiceMinDTO> getSdServiceMinDataFromProjectId(Integer projectId) {
        String query = "SELECT serviceId AS serviceId,serviceName AS serviceName FROM SdService where status=0 and sdProjectMaster.projectId = :projectId";
        String[] paramNames = new String[]{PROJECT_ID};
        Object[] values = new Object[]{projectId};
        return this.genericHibernateDaoOperations.findByNamedParam(query, paramNames, values, SdDTOEnum.SERVICE_MIN_DTO);
    }

    @Override
    public Integer checkDuplicateService(String servieName, Integer projectId, Integer serviceId) {
        Integer isDuplicate = 0;
        String query = "SELECT serviceName FROM SdService WHERE serviceName=:serviceName and sdProjectMaster.projectId=:projectId and serviceId <> :serviceId";
        String[] paramNames = new String[]{"serviceName", PROJECT_ID, "serviceId"};
        Object[] values = new Object[]{servieName, projectId, serviceId};
        List serviceList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, String.class);
        if (serviceList != null && serviceList.size() > 0) {
            isDuplicate = 1;
        }
        return isDuplicate;
    }

    @Override
    public SdService getServiceByProjectIdAndServiceName(String serviceName, int projectId) {
        String query = " from SdService where sdProjectMaster.projectId = :projectId and serviceName = :serviceName ";
        String[] paramNames = new String[]{PROJECT_ID, "serviceName"};
        Object[] values = new Object[]{projectId, serviceName};
        return (SdService)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdService.class));
    }

    @Override
    public Integer getDefaultServiceId(Integer projectId) {
        Integer defaultServiceID = 0;
        String query = "SELECT ss.serviceId FROM Sd_Project_Details sd,Sd_Service ss WHERE sd.parameterId=6 and sd.projectId=:projectId and cast(sd.parameterValue as unsigned) =ss.serviceId and Status=0";
        String[] paramNames = new String[]{PROJECT_ID};
        Object[] values = new Object[]{projectId};
        List serviceList = this.hibernateDaoOperations.findByNamedParamSql(query, paramNames, values, Integer.class);
        if (serviceList != null && serviceList.size() > 0) {
            defaultServiceID = (int)((Integer)serviceList.get(0));
        }
        return defaultServiceID;
    }

    @Override
    public List<String> getParentServices(List<Integer> serviceList) {
        List<String> services = new ArrayList<String>();
        String query = "SELECT serviceName from SdService where serviceId in(:serviceList)";
        String[] paramNames = new String[]{"serviceList"};
        Object[] values = new Object[]{serviceList};
        List servicesList1 = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, String.class);
        if (servicesList1 != null && servicesList1.size() > 0) {
            services = servicesList1;
        }
        return services;
    }

    @Override
    public List<SdService> getSdServiceByProjectId(Integer projectId, Integer pageNo, Integer pageSize, String sortColumn, String sortDirection) {
        Object query = " from SdService where sdProjectMaster.projectId = :projectId and status in (0,1)";
        String[] paramNames = new String[]{PROJECT_ID};
        Object[] values = new Object[]{projectId};
        Integer defaultServiceId = sortColumn.equalsIgnoreCase("defaultService") ? this.getDefaultServiceId(projectId) : 0;
        if (sortColumn != null && !sortColumn.isEmpty()) {
            query = "defaultService".equals(sortColumn) ? (String)query + " order by (case when serviceId = " + defaultServiceId + " then 0 else 1 end) " + sortDirection : (String)query + " order by " + sortColumn + " " + sortDirection;
        }
        return this.genericHibernateDaoOperations.findByNamedParamAndPagesize((String)query, paramNames, values, pageNo, pageSize, SdDTOEnum.SD_SERVICE);
    }

    @Override
    public List<SdService> getServiceNameByserviceIds(List<Integer> serviceIdList, Integer projectId) {
        String query = "from SdService where status= 0 and sdProjectMaster.projectId = :projectId and serviceId in(:serviceIdList)";
        String[] paramNames = new String[]{PROJECT_ID, "serviceIdList"};
        Object[] values = new Object[]{projectId, serviceIdList};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdService.class);
    }

    @Override
    @Transactional
    public SdService saveSdService(SdServiceDTO serviceDTO, Integer projectId) {
        SdService sdService = new SdService();
        sdService.setServiceName(serviceDTO.getServiceName());
        sdService.setDefaultImageName(serviceDTO.getDefaultImageName());
        sdService.setShortName(serviceDTO.getShortName());
        sdService.setServiceDescription(serviceDTO.getServiceDescription());
        SdProjectMaster sdProjectMaster = (SdProjectMaster)((Object)this.hibernateDaoOperations.get(SdProjectMaster.class, (Serializable)projectId));
        sdService.setSdProjectMaster(sdProjectMaster);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdService);
        return sdService;
    }

    @Override
    @Transactional
    public SdService updateSdServiceName(SdServiceDTO serviceDTO, Integer projectId) {
        SdService sdService = (SdService)((Object)this.hibernateDaoOperations.get(SdService.class, (Serializable)serviceDTO.getServiceId()));
        sdService.setServiceName(serviceDTO.getServiceName());
        this.hibernateDaoOperations.saveOrUpdate((Object)sdService);
        return sdService;
    }

    @Override
    @Transactional
    public SdService saveServiceDescription(Integer serviceId, String serviceDescription) {
        SdService sdService = (SdService)((Object)this.hibernateDaoOperations.get(SdService.class, (Serializable)serviceId));
        sdService.setServiceDescription(serviceDescription);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdService);
        return sdService;
    }

    @Override
    @Transactional
    public SdService saveServiceStatus(Integer serviceId, Integer status) {
        SdService sdService = (SdService)((Object)this.hibernateDaoOperations.get(SdService.class, (Serializable)serviceId));
        sdService.setStatus(status);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdService);
        return sdService;
    }

    @Override
    @Transactional
    public SdService saveImage(Integer serviceId, String image) {
        SdService sdService = (SdService)((Object)this.hibernateDaoOperations.get(SdService.class, (Serializable)serviceId));
        sdService.setDefaultImageName(image);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdService);
        return sdService;
    }

    @Override
    @Transactional
    public SdService saveShortName(Integer serviceId, String shortName) {
        SdService sdService = (SdService)((Object)this.hibernateDaoOperations.get(SdService.class, (Serializable)serviceId));
        sdService.setShortName(shortName);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdService);
        return sdService;
    }

    @Override
    @Transactional
    public void deleteSdService(int serviceId) {
        this.hibernateDaoOperations.delete(this.hibernateDaoOperations.get(SdService.class, (Serializable)Integer.valueOf(serviceId)));
    }
}

