/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdServiceDetailsDAO;
import com.sapphireims.itsm.model.SdServiceDetails;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SdServiceDetailsDAO
extends GenericHibernateRepository<SdServiceDetails, Integer>
implements ISdServiceDetailsDAO {
    @Override
    @Transactional(readOnly=true)
    public List<SdServiceDetails> getSdServiceDetailsByServiceId(Integer serviceId) {
        String query = " from SdServiceDetails where serviceId = :serviceId ";
        String[] paramNames = new String[]{"serviceId"};
        Object[] values = new Object[]{serviceId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdServiceDetails.class);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Integer> getParentServices(Integer serviceId) {
        String query = "SELECT paramValue from SdServiceDetails where serviceId = :serviceId and parmId = 2";
        String[] paramNames = new String[]{"serviceId"};
        Object[] values = new Object[]{serviceId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, Integer.class);
    }

    @Override
    @Transactional
    public void saveIsParentOrChild(int serviceId, int paramId, int paramValue) {
        SdServiceDetails sdServiceDetails = new SdServiceDetails();
        sdServiceDetails.setServiceId(serviceId);
        sdServiceDetails.setParmId(paramId);
        sdServiceDetails.setParamValue(paramValue);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdServiceDetails);
    }

    @Override
    @Transactional
    public void deleteSdServiceDetails(int serviceId) {
        SdServiceDetails sdServiceDetails = (SdServiceDetails)((Object)this.hibernateDaoOperations.get(SdServiceDetails.class, (Serializable)Integer.valueOf(serviceId)));
        if (sdServiceDetails != null) {
            this.hibernateDaoOperations.delete((Object)sdServiceDetails);
        }
    }
}

