/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdServiceParametersDetailsDAO;
import com.sapphireims.itsm.model.SdServiceParametersDetails;
import com.sapphireims.itsm.model.SdServiceParametersMaster;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.MutationQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SdServiceParametersDetailsDAO
extends GenericHibernateRepository<SdServiceParametersDetails, Integer>
implements ISdServiceParametersDetailsDAO {
    private final SessionFactory sessionFactory;

    @Autowired
    public SdServiceParametersDetailsDAO(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public List<SdServiceParametersDetails> getSdServiceParametersDetailsByServiceId(Integer serviceId) {
        String query = " from SdServiceParametersDetails where serviceId = :serviceId ";
        String[] paramNames = new String[]{"serviceId"};
        Object[] values = new Object[]{serviceId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdServiceParametersDetails.class);
    }

    @Override
    public List<SdServiceParametersDetails> getSdServicePramatersDetailsByCategory(Integer serviceId, Integer categoryId) {
        String query = " from SdServiceParametersDetails where serviceId = :serviceId and sdServiceParametersMaster.parameterId = 1 and parameterValue = :categoryId";
        String[] paramNames = new String[]{"serviceId", "categoryId"};
        Object[] values = new Object[]{serviceId, categoryId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdServiceParametersDetails.class);
    }

    @Override
    public List<SdServiceParametersDetails> getSdServicePramatersDetailsBySubCategory(Integer serviceId, Integer subCategoryId) {
        String query = " from SdServiceParametersDetails where serviceId = :serviceId and sdServiceParametersMaster.parameterId = 2 and parameterValue = :subCategoryId";
        String[] paramNames = new String[]{"serviceId", "subCategoryId"};
        Object[] values = new Object[]{serviceId, subCategoryId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdServiceParametersDetails.class);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdServiceParametersDetails> getSdServiceIdBySubCategory(Integer parameterId, Integer paramValue) {
        String query = " from SdServiceParametersDetails where sdServiceParametersMaster.parameterId = :parameterId and parameterValue = :paramValue";
        String[] paramNames = new String[]{"parameterId", "paramValue"};
        Object[] values = new Object[]{parameterId, paramValue};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdServiceParametersDetails.class);
    }

    @Override
    @Transactional
    public void deleteSdServiceParameterDetailsForCategory(int categoryId) {
        Session session = this.sessionFactory.getCurrentSession();
        String Query2 = "delete from SdServiceParametersDetails where sdServiceParametersMaster.parameterId = 1 and parameterValue=:categoryId";
        MutationQuery query = session.createMutationQuery(Query2);
        query.setParameter("categoryId", (Object)String.valueOf(categoryId));
        query.executeUpdate();
    }

    @Override
    @Transactional
    public void deleteSdServiceParameterDetailsForSubCategory(int projectId, List categoryId) {
        Session session = this.sessionFactory.getCurrentSession();
        String Query2 = "delete from SdServiceParametersDetails where sdServiceParametersMaster.parameterId = 2 and parameterValue=:categoryId";
        MutationQuery query = session.createMutationQuery(Query2);
        query.setParameter("categoryId", (Object)String.valueOf(categoryId));
        query.executeUpdate();
    }

    @Override
    @Transactional
    public void saveIsParentOrChild(int serviceId, int paramId, int paramValue) {
        SdServiceParametersMaster sdServiceParametersMaster = (SdServiceParametersMaster)((Object)this.hibernateDaoOperations.get(SdServiceParametersMaster.class, (Serializable)Integer.valueOf(paramId)));
        SdServiceParametersDetails sdServiceParametersDetails = new SdServiceParametersDetails(sdServiceParametersMaster, paramValue, serviceId);
        this.hibernateDaoOperations.save((Object)sdServiceParametersDetails);
    }

    @Override
    public void updateSdParameterService(int parameterID, int parameterValue, int serviceID) {
        SdServiceParametersDetails sdServiceParametersDetails = (SdServiceParametersDetails)((Object)this.hibernateDaoOperations.get(SdServiceParametersDetails.class, (Serializable)Integer.valueOf(parameterValue)));
        if (sdServiceParametersDetails != null && sdServiceParametersDetails.getSdServiceParametersMaster().getParameterId() == parameterID) {
            sdServiceParametersDetails.setServiceId(serviceID);
            this.hibernateDaoOperations.saveOrUpdate((Object)sdServiceParametersDetails);
        }
    }

    @Override
    public void deleteSdServiceParameterDetailsForSubCategory(int projectId, Integer categoryId) {
        Session session = this.sessionFactory.getCurrentSession();
        String Query2 = "delete from SdServiceParametersDetails where sdServiceParametersMaster.parameterId = 2 and parameterValue=:categoryId";
        MutationQuery query = session.createMutationQuery(Query2);
        query.setParameter("categoryId", (Object)String.valueOf(categoryId));
        query.executeUpdate();
    }

    @Override
    public void saveSdServiceParameterDetails(SdServiceParametersDetails sdServiceParametersDetails) {
        this.hibernateDaoOperations.saveOrUpdate((Object)sdServiceParametersDetails);
    }
}

