/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdServicerequestMultiapprovalDAO;
import com.sapphireims.itsm.dto.ticket.TicketDTO;
import com.sapphireims.itsm.model.SdServicerequestMultiapproval;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class SdServicerequestMultiapprovalDAO
extends GenericHibernateRepository<SdServicerequestMultiapproval, Integer>
implements ISdServicerequestMultiapprovalDAO {
    private final Logger logger = LoggerFactory.getLogger(SdServicerequestMultiapprovalDAO.class);

    @Override
    public List<SdServicerequestMultiapproval> getSdServicerequestMultiapproval() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<String> getMultiApprovalStateIdsForManualStateMovemet(TicketDTO t) {
        boolean approvalAction = false;
        List inputValues = null;
        try {
            int currentStateId = t.getCurrentState().getStateId();
            String query = "SELECT sm.accessType FROM SdServicerequestMultiapproval sm WHERE sm.sdServicereqmaster.problemId=:problemId and sm.status=3 and sm.stateId=:stateId";
            String[] paramNames = new String[]{"problemId", "stateId"};
            Object[] values = new Object[]{t.getProblemId(), currentStateId};
            Integer accessType = (Integer)this.hibernateDaoOperations.findByNamedParamMaxResult(query, paramNames, values, 1);
            query = "SELECT sm.accessType FROM SdServicerequestMultiapproval sm WHERE sm.sdServicereqmaster.problemId=:problemId and sm.status=4 and sm.stateId=:stateId";
            Integer minRejections = (Integer)this.hibernateDaoOperations.findByNamedParamMaxResult(query, paramNames, values, 1);
            if (accessType != null && accessType != 0) {
                int inputType = 0;
                int minApprovals = accessType;
                query = "SELECT COUNT(sm.owner) FROM SdServicerequestMultiapproval sm WHERE sm.sdServicereqmaster.problemId=:problemId and sm.status=1 and sm.stateId=:stateId";
                Long ownerCount1 = (Long)this.hibernateDaoOperations.findByNamedParamMaxResult(query, paramNames, values, 1);
                query = "SELECT COUNT(sm.owner) FROM SdServicerequestMultiapproval sm WHERE sm.sdServicereqmaster.problemId=:problemId and sm.status=2 and sm.stateId=:stateId";
                Long rejectedCount = (Long)this.hibernateDaoOperations.findByNamedParamMaxResult(query, paramNames, values, 1);
                if (ownerCount1 != null) {
                    if (rejectedCount >= (long)minRejections.intValue()) {
                        approvalAction = true;
                        inputType = 8;
                    } else if (ownerCount1 >= (long)minApprovals) {
                        approvalAction = true;
                        inputType = 7;
                    } else {
                        query = "SELECT COUNT(sm.owner) FROM SdServicerequestMultiapproval sm WHERE sm.sdServicereqmaster.problemId=:problemId and sm.status=0 and sm.stateId=:stateId";
                        Long ownerCount2 = (Long)this.hibernateDaoOperations.findByNamedParamMaxResult(query, paramNames, values, 1);
                        if (ownerCount2 != null && ownerCount1 + ownerCount2 < (long)minApprovals) {
                            approvalAction = true;
                            inputType = 8;
                        }
                    }
                }
                if (approvalAction) {
                    query = "SELECT ad.inputValue FROM SdMultiapprovalMaster am, SdMultiapprovalDetails ad WHERE am.stateId=:stateId and am.appModuleType = 1 and am.appRuleId = ad.sdMultiapprovalMaster.appRuleId and ad.inputType=:inputType";
                    String[] pn = new String[]{"stateId", "inputType"};
                    Object[] po = new Object[]{currentStateId, inputType};
                    inputValues = this.hibernateDaoOperations.findByNamedParam(query, pn, po, String.class);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return inputValues;
    }

    @Override
    public List<Object> getMultiApprovalProblemIdsForOwner(int owner, String schema) {
        String query = "Select DISTINCT sm.ProblemID from " + schema + ".sd_servicerequest_multiapproval sm," + schema + ".sd_multiapproval_master am where sm.StateID=am.StateID and (if((am.AppType<>0),1,(if(sm.Status<>0,1,0)))) and sm.Owner = :owner";
        String[] params = new String[]{"owner"};
        Object[] values = new Object[]{owner};
        return this.hibernateDaoOperations.findByNamedParamSql(query, params, values, Object.class);
    }

    @Override
    public List<Object> getMultiApproval(int problemId) {
        String query = "from SdServicerequestMultiapproval srma, UserMgmtMaster um where srma.owner = um.userDetails.userId and um.userDetails.userStatus = 0 and srma.sdServicereqmaster.problemId = :problemId ORDER BY srma.id";
        String[] params = new String[]{"problemId"};
        Object[] values = new Object[]{problemId};
        return this.hibernateDaoOperations.findByNamedParam(query, params, values, Object.class);
    }

    @Override
    public List<SdServicerequestMultiapproval> getMultiApprovalWithProblemAndStateId(int problemId, int stateId) {
        String query = "from SdServicerequestMultiapproval srma where srma.sdServicereqmaster.problemId = :problemId and srma.stateId = :stateId ORDER BY srma.id";
        String[] params = new String[]{"problemId", "stateId"};
        Object[] values = new Object[]{problemId, stateId};
        return this.hibernateDaoOperations.findByNamedParam(query, params, values, SdServicerequestMultiapproval.class);
    }

    @Override
    public List<SdServicerequestMultiapproval> getMultiApprovalWithProblemAndStateIdAndOwner(int problemId, int stateId, int owner) {
        String query = "from SdServicerequestMultiapproval srma where srma.sdServicereqmaster.problemId = :problemId and srma.stateId = :stateId and srma.owner = :owner ORDER BY srma.id";
        String[] params = new String[]{"problemId", "stateId", "owner"};
        Object[] values = new Object[]{problemId, stateId, owner};
        return this.hibernateDaoOperations.findByNamedParam(query, params, values, SdServicerequestMultiapproval.class);
    }

    @Override
    public List<Object> getMultiApprovalWothProblemIds(List<Integer> problemIds) {
        String query = "from SdServicerequestMultiapproval srma where srma.sdServicereqmaster.problemId in (:problemId) ORDER BY srma.id";
        String[] params = new String[]{"problemId"};
        Object[] values = new Object[]{problemIds};
        return this.hibernateDaoOperations.findByNamedParam(query, params, values, Object.class);
    }

    @Override
    public void deleteMultiApprovalWithProblemIdStateId(Integer problemId, Integer stateId) {
        String query = "delete from SdServicerequestMultiapproval where stateId=:stateId and sdServicereqmaster.problemId=:problemId";
        String[] params = new String[]{"stateId", "problemId"};
        Object[] values = new Object[]{stateId, problemId};
        this.hibernateDaoOperations.bulkUpdateOrDeleteByParam(query, params, values);
    }
}

