/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphire.itsm.mailrouting.model.SdSettingoperationHistory;
import com.sapphire.itsm.mailrouting.model.SdSettingsModules;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdSettingoperationHistoryDAO;
import com.sapphireims.itsm.dto.SdSettingoperationHistoryDTO;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SdSettingoperationHistoryDAO
extends GenericHibernateRepository<SdSettingoperationHistory, Integer>
implements ISdSettingoperationHistoryDAO {
    @Override
    @Transactional(readOnly=true)
    public List<SdSettingoperationHistory> getSdSettingoperationHistory(Integer moduleId, Integer projectId) {
        String query = " from SdSettingoperationHistory where sdSettingsModules.moduleId = :moduleId and projectId = :projectId";
        String[] paramNames = new String[]{"moduleId", "projectId"};
        Object[] values = new Object[]{moduleId, projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdSettingoperationHistory.class);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdSettingoperationHistory> getSdSettingoperationHistory(Integer moduleId, Integer projectId, Integer pageNo, Integer pageSize) {
        String query = " from SdSettingoperationHistory where sdSettingsModules.moduleId = :moduleId and projectId = :projectId";
        String[] paramNames = new String[]{"moduleId", "projectId"};
        Object[] values = new Object[]{moduleId, projectId};
        return this.genericHibernateDaoOperations.findByNamedParamAndPagesize(query, paramNames, values, pageNo, pageSize, SdDTOEnum.SD_SETTING_OPERATION_HISTORY);
    }

    @Override
    @Transactional
    public void saveSdSettingoperationHistory(SdSettingoperationHistoryDTO historyDto) {
        SdSettingsModules sdSettingsModules = (SdSettingsModules)((Object)this.hibernateDaoOperations.get(SdSettingsModules.class, (Serializable)Integer.valueOf(historyDto.getModuleId())));
        SdSettingoperationHistory history = new SdSettingoperationHistory(sdSettingsModules, historyDto.getDetailId(), historyDto.getProjectId(), historyDto.getActivityTime(), historyDto.getActionPerformedBy(), historyDto.getIpAddress(), historyDto.getNatureOfChange(), historyDto.getParameter(), historyDto.getOldValue(), historyDto.getNewValue());
        this.hibernateDaoOperations.save((Object)history);
    }

    @Override
    @Transactional
    public int saveSdSettingoperationHistory1(SdSettingoperationHistoryDTO historyDto) {
        SdSettingsModules sdSettingsModules = (SdSettingsModules)((Object)this.hibernateDaoOperations.get(SdSettingsModules.class, (Serializable)Integer.valueOf(historyDto.getModuleId())));
        SdSettingoperationHistory history = new SdSettingoperationHistory(sdSettingsModules, historyDto.getDetailId(), historyDto.getProjectId(), historyDto.getActivityTime(), historyDto.getActionPerformedBy(), historyDto.getIpAddress(), historyDto.getNatureOfChange(), historyDto.getParameter(), historyDto.getOldValue(), historyDto.getNewValue(), historyDto.getChildOf(), historyDto.getModeOfOperations());
        this.hibernateDaoOperations.save((Object)history);
        return history.getSlNo();
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdSettingoperationHistory> getSortedAuditRecordsHql(Integer moduleId, Integer projectId, int pageNo, int pageSize, String sortColumn, String sortDirection) {
        String direction = "desc".equalsIgnoreCase(sortDirection) ? "desc" : "asc";
        StringBuilder hql = new StringBuilder("select s from SdSettingoperationHistory s ");
        if ("byUser".equalsIgnoreCase(sortColumn)) {
            hql.append("left join UserMgmtMaster u on s.actionperformedby = u.userDetails.userId ");
        }
        hql.append("where s.sdSettingsModules.moduleId = :moduleId and s.projectId = :projectId ");
        if (sortColumn != null && !sortColumn.isEmpty()) {
            hql.append("order by ");
            switch (sortColumn) {
                case "parameter": {
                    hql.append("s.parameter ");
                    break;
                }
                case "oldValue": {
                    hql.append("s.oldvalue ");
                    break;
                }
                case "newValue": {
                    hql.append("s.newvalue ");
                    break;
                }
                case "ipAddr": {
                    hql.append("s.ipaddress ");
                    break;
                }
                case "atTime": {
                    hql.append("s.activitytime ");
                    break;
                }
                case "byUser": {
                    hql.append("u.fullName ");
                    break;
                }
                case "natureOfChange": {
                    hql.append("case s.natureofchange ").append("when 1 then 'Added' ").append("when 2 then 'Updated' ").append("else 'Deleted' end ");
                    break;
                }
                default: {
                    hql.append("s.activitytime ");
                }
            }
            hql.append(direction);
        }
        String[] paramNames = new String[]{"moduleId", "projectId"};
        Object[] values = new Object[]{moduleId, projectId};
        return this.genericHibernateDaoOperations.findByNamedParamAndPagesize(hql.toString(), paramNames, values, pageNo, pageSize, SdDTOEnum.SD_SETTING_OPERATION_HISTORY);
    }
}

