/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdSlaCommentDAO;
import com.sapphireims.itsm.dto.SdSlaCommentDTO;
import com.sapphireims.itsm.model.SdSlaComment;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class SdSlaCommentDAO
extends GenericHibernateRepository<SdSlaComment, Integer>
implements ISdSlaCommentDAO {
    @Override
    public List<SdSlaComment> getSdSlaCommentByProjectId(Integer projectId) {
        String query = " from SdSlaComment where projectid = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdSlaComment.class);
    }

    @Override
    public List<SdSlaComment> getSdSlaComment(Integer projectId, String comment) {
        String query = " from SdSlaComment where projectid = :projectId and status = 0 and comment = :comment";
        String[] paramNames = new String[]{"projectId", "comment"};
        Object[] values = new Object[]{projectId, comment};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdSlaComment.class);
    }

    @Override
    public List<SdSlaComment> getSdSlaCommentByProjectId(Integer projectId, Integer pageNo, Integer pageSize, String sortColumn, String sortDir) {
        Object query = " from SdSlaComment where projectid = :projectId and status = 0";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        query = (String)query + " order by " + sortColumn + " " + sortDir;
        return this.genericHibernateDaoOperations.findByNamedParamAndPagesize((String)query, paramNames, values, pageNo, pageSize, SdDTOEnum.SD_SLA_COMMENT);
    }

    @Override
    public Integer checkDuplicateComment(String comment, Integer projectId, Integer id) {
        Integer isDuplicate = 0;
        String query = "SELECT comment FROM SdSlaComment WHERE comment=:comment and projectid=:projectId and status=0 and id <> :id";
        String[] paramNames = new String[]{"comment", "projectId", "id"};
        Object[] values = new Object[]{comment, projectId, id};
        List nameList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, String.class);
        if (nameList != null && nameList.size() > 0) {
            isDuplicate = 1;
        }
        return isDuplicate;
    }

    @Override
    public int saveSlaComment(SdSlaCommentDTO sdSlaCommentDTO) {
        SdSlaComment sdSlaComment = new SdSlaComment();
        sdSlaComment.setComment(sdSlaCommentDTO.getComment());
        sdSlaComment.setProjectid(sdSlaCommentDTO.getProjectid());
        sdSlaComment.setAccess(sdSlaCommentDTO.getAccess());
        this.hibernateDaoOperations.save((Object)sdSlaComment);
        return sdSlaComment.getId();
    }

    @Override
    public int updateSlaComment(SdSlaCommentDTO sdSlaCommentDTO) {
        SdSlaComment sdSlaComment = (SdSlaComment)((Object)this.hibernateDaoOperations.get(SdSlaComment.class, (Serializable)sdSlaCommentDTO.getId()));
        sdSlaComment.setComment(sdSlaCommentDTO.getComment());
        this.hibernateDaoOperations.saveOrUpdate((Object)sdSlaComment);
        return sdSlaComment.getId();
    }

    @Override
    public SdSlaComment getSdSlaCommentByIdAndProjectId(Integer commentId, Integer projectId) {
        String query = " from SdSlaComment where projectid = :projectId and id =:commentId";
        String[] paramNames = new String[]{"projectId", "commentId"};
        Object[] values = new Object[]{projectId, commentId};
        return (SdSlaComment)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdSlaComment.class));
    }

    @Override
    public void deleteSdSlaComment(SdSlaCommentDTO sdSlaCommentDTO) {
        SdSlaComment sdSlaComment = (SdSlaComment)((Object)this.hibernateDaoOperations.get(SdSlaComment.class, (Serializable)sdSlaCommentDTO.getId()));
        sdSlaComment.setStatus(sdSlaCommentDTO.getStatus());
        this.hibernateDaoOperations.saveOrUpdate((Object)sdSlaComment);
    }
}

