/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdSmsNotificationDetailsDAO;
import com.sapphireims.itsm.dto.SdSmsNotificationDetailsDTO;
import com.sapphireims.itsm.model.SdSmsNotificationDetails;
import java.util.LinkedHashMap;
import java.util.List;
import org.hibernate.query.MutationQuery;
import org.springframework.stereotype.Repository;

@Repository
public class SdSmsNotificationDetailsDAO
extends GenericHibernateRepository<SdSmsNotificationDetails, Integer>
implements ISdSmsNotificationDetailsDAO {
    private static final String SMS_NOTIFICATION_ID = "smsNotificationId";

    @Override
    public List<SdSmsNotificationDetails> getSdSmsNotificationDetailsBySdSmsNotificationMasterId(Integer smsNotificationId) {
        String query = " from SdSmsNotificationDetails where sdSmsNotificationMaster.smsNotificationId = :smsNotificationId ";
        String[] paramNames = new String[]{SMS_NOTIFICATION_ID};
        Object[] values = new Object[]{smsNotificationId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdSmsNotificationDetails.class);
    }

    @Override
    public SdSmsNotificationDetailsDTO getSdSmsNotificationDetailsDto(Integer smsNotificationId) {
        String query = "Select parameterType, parameterValue from SdSmsNotificationDetails where sdSmsNotificationMaster.smsNotificationId=:smsNotificationId";
        String[] paramName = new String[]{SMS_NOTIFICATION_ID};
        Object[] value = new Object[]{smsNotificationId};
        LinkedHashMap<Integer, String> toMap = new LinkedHashMap<Integer, String>();
        LinkedHashMap<Integer, String> userMap = new LinkedHashMap<Integer, String>();
        int isUserExists = 0;
        int acn = 0;
        int extContactNo = 0;
        SdSmsNotificationDetailsDTO sdSmsNotificationDetailsDto = new SdSmsNotificationDetailsDTO();
        List list = this.hibernateDaoOperations.findByNamedParam(query, paramName, value, Object[].class);
        for (Object[] detail : list) {
            int paramType = (Integer)detail[0];
            String paramValue = (String)detail[1];
            if (paramType == 0) {
                switch (paramValue) {
                    case "0": {
                        toMap.put(Integer.parseInt(paramValue), "Submitter");
                        break;
                    }
                    case "1": {
                        toMap.put(Integer.parseInt(paramValue), "Owner");
                        break;
                    }
                    case "2": {
                        toMap.put(Integer.parseInt(paramValue), "Approval Manager");
                    }
                }
                sdSmsNotificationDetailsDto.setToRoleMap(toMap);
                continue;
            }
            if (paramType == 1) {
                String userQuery = "Select fullName from UserMgmtMaster where userDetails.userId=:userId";
                String[] paramNames = new String[]{"userId"};
                Object[] values = new Object[]{Integer.parseInt(paramValue)};
                String fullNameObj = (String)this.hibernateDaoOperations.findByNamedParamUniqueResult(userQuery, paramNames, values, String.class);
                if (fullNameObj != null) {
                    userMap.put(Integer.parseInt(paramValue), fullNameObj);
                }
                ++isUserExists;
                continue;
            }
            if (paramType == 2) {
                sdSmsNotificationDetailsDto.setAcn(Integer.parseInt(paramValue));
                ++acn;
                continue;
            }
            if (paramType != 3) continue;
            sdSmsNotificationDetailsDto.setExtCno(paramValue);
            ++extContactNo;
        }
        if (userMap != null && userMap.size() > 0) {
            sdSmsNotificationDetailsDto.setUserMap(userMap);
        }
        if (isUserExists == 0) {
            userMap.put(0, "---Choose---");
            sdSmsNotificationDetailsDto.setUserMap(userMap);
        }
        if (acn == 0) {
            sdSmsNotificationDetailsDto.setAcn(0);
        }
        if (extContactNo == 0) {
            sdSmsNotificationDetailsDto.setExtCno("");
        }
        return sdSmsNotificationDetailsDto;
    }

    @Override
    public void deleteDetailsData(Integer smsNotificationId) {
        String query = "delete from SdSmsNotificationDetails where sdSmsNotificationMaster.smsNotificationId=:smsNotificationId";
        MutationQuery queryString = this.hibernateDaoOperations.getSessionFactory().getCurrentSession().createMutationQuery(query);
        queryString.setParameter(SMS_NOTIFICATION_ID, (Object)smsNotificationId);
        queryString.executeUpdate();
    }
}

