/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdSmsNotificationMasterDAO;
import com.sapphireims.itsm.dto.SdSmsNotificationMasterDTO;
import com.sapphireims.itsm.model.SdSmsNotificationDetails;
import com.sapphireims.itsm.model.SdSmsNotificationMaster;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import com.sapphireims.util.CollectionUtil;
import java.util.List;
import org.hibernate.query.MutationQuery;
import org.springframework.stereotype.Repository;

@Repository
public class SdSmsNotificationMasterDAO
extends GenericHibernateRepository<SdSmsNotificationMaster, Integer>
implements ISdSmsNotificationMasterDAO {
    @Override
    public List<SdSmsNotificationMaster> getSdSmsNotificationMasterByProjectId(Integer projectId) {
        String query = " from SdSmsNotificationMaster where sdProjectMaster.projectId = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdSmsNotificationMaster.class);
    }

    @Override
    public void saveSdSmsNotificationDetailses(List<SdSmsNotificationDetails> snd) {
        if (CollectionUtil.isNotEmpty(snd)) {
            for (SdSmsNotificationDetails s : snd) {
                this.hibernateDaoOperations.save((Object)s);
            }
        }
    }

    @Override
    public Integer getIsSMSRuleConfiguredForState(Integer stateId) {
        int isRuleConfigured = 0;
        String query = "Select distinct forState from SdSmsNotificationMaster where forState=:forState";
        String[] paramName = new String[]{"forState"};
        Object[] value = new Object[]{stateId};
        Object isConfigured = this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramName, value, Object.class);
        if (isConfigured != null) {
            isRuleConfigured = 1;
        }
        return isRuleConfigured;
    }

    @Override
    public List<SdSmsNotificationMasterDTO> getSdSmsNotificationMasterDto(Integer stateId) {
        String query = "select st.smsTemplateId AS templateId,st.smsTemplateName AS templateName,sn.smsNotificationId AS smsNotificationId from SdSmsNotificationMaster sn, SdSmsNotificationTemplate st where sn.forState=:forState and st.smsTemplateId=sn.templateId and sn.templateType=0";
        String[] paramName = new String[]{"forState"};
        Object[] value = new Object[]{stateId};
        return this.genericHibernateDaoOperations.findByNamedParam(query, paramName, value, SdDTOEnum.SD_SMS_NOTIFICATION_DTO);
    }

    @Override
    public Integer checkIsUpdate(Integer stateId) {
        String query = "Select smsNotificationId from SdSmsNotificationMaster where forState=:forState and templateType=0";
        String[] paramName = new String[]{"forState"};
        Object[] value = new Object[]{stateId};
        Integer obj = (Integer)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramName, value, Integer.class);
        if (obj != null) {
            return obj;
        }
        return 0;
    }

    @Override
    public void deleteMasterDataForState(Integer smsNotificationId) {
        String query = "delete from SdSmsNotificationMaster where smsNotificationId=:smsNotificationId";
        MutationQuery queryString = this.hibernateDaoOperations.getSessionFactory().getCurrentSession().createMutationQuery(query);
        queryString.setParameter("smsNotificationId", (Object)smsNotificationId);
        queryString.executeUpdate();
    }

    @Override
    public String getSMSNotificationTemplateName(Integer smsNotificationId) {
        String tempName = "";
        String query = "Select smsTemplateName from SdSmsNotificationTemplate where smsTemplateId=:smsNotificationId";
        String[] paramNames = new String[]{"smsNotificationId"};
        Object[] values = new Object[]{smsNotificationId};
        String templateName = (String)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, String.class);
        if (templateName != null) {
            tempName = templateName;
        }
        return tempName;
    }
}

