/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdSourcefilterDAO;
import com.sapphireims.itsm.dto.SdSourcefilterDTO;
import com.sapphireims.itsm.model.SdProjectDetails;
import com.sapphireims.itsm.model.SdProjectParametersMaster;
import com.sapphireims.itsm.model.SdSourcefilter;
import com.sapphireims.itsm.model.SdSourcefilterId;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SdSourcefilterDAO
extends GenericHibernateRepository<SdSourcefilter, SdSourcefilterId>
implements ISdSourcefilterDAO {
    private final SessionFactory sessionFactory;

    @Autowired
    public SdSourcefilterDAO(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdSourcefilter> getSdSourcefilterByProjectId(Integer projectId) {
        String query = " from SdSourcefilter sd where sd.id.projectId = :projectId and sd.sourceFilterStatus=0";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdSourcefilter.class);
    }

    @Override
    public void saveSdSourceFilter(SdSourcefilter sdsf, Integer projectId) {
        Session session = this.sessionFactory.getCurrentSession();
        MutationQuery sqlQuery = null;
        int i = 0;
        String Query2 = "insert into sd_sourcefilter(FilterName, FilterDescription, ConsiderUsersList, sourceFilterStatus, isDefaultSource, sourceFilterID, ProjectID) value(:FilterName, :FilterDescription, :ConsiderUsersList, :sourceFilterStatus, :isDefaultSource, :sourceFilterId, :projectId)";
        if (sdsf != null) {
            Integer sourceId = 0;
            sqlQuery = session.createNativeMutationQuery(Query2);
            sqlQuery.setParameter("FilterName", (Object)sdsf.getFilterName());
            sqlQuery.setParameter("FilterDescription", (Object)sdsf.getFilterDescription());
            sqlQuery.setParameter("ConsiderUsersList", (Object)sdsf.getConsiderUsersList());
            sqlQuery.setParameter("sourceFilterStatus", (Object)sdsf.getSourceFilterStatus());
            sqlQuery.setParameter("isDefaultSource", (Object)sdsf.getIsDefaultSource());
            if (sdsf.getId().getSourceFilterId() == 0) {
                sourceId = sdsf.getId().getSourceFilterId();
                sqlQuery.setParameter("sourceFilterId", (Object)sourceId);
            } else {
                sourceId = this.SourceFilterIDIncDAO();
                sqlQuery.setParameter("sourceFilterId", (Object)sourceId);
                sdsf.getId().setSourceFilterId(sourceId);
            }
            sqlQuery.setParameter("projectId", (Object)projectId);
            sqlQuery.executeUpdate();
            if (sdsf.getIsDefaultSource() == 1 && sourceId != 0) {
                this.updateDefaultValue(sourceId, projectId);
            }
            ++i;
        }
    }

    public Integer SourceFilterIDIncDAO() {
        Session session = this.sessionFactory.getCurrentSession();
        String Query2 = "Select max(sourceFilterID)+1 from sd_sourcefilter";
        NativeQuery sqlQuery = session.createNativeQuery(Query2, Integer.class);
        return (Integer)sqlQuery.getSingleResult();
    }

    @Override
    public void updateDefaultValue(Integer sourceFilterId, Integer projectId) {
        Session session = this.sessionFactory.getCurrentSession();
        if (sourceFilterId != 0) {
            String hql = "select sd.projectDetailsId from SdProjectDetails sd where sd.sdProjectMaster.projectId=:projectId and sd.sdProjectParametersMaster.parameterId=7";
            String[] paramNames = new String[]{"projectId"};
            Object[] values = new Object[]{projectId};
            Integer Id2 = (Integer)this.hibernateDaoOperations.findByNamedParamUniqueResult(hql, paramNames, values, Integer.class);
            if (Id2 == null) {
                Id2 = 0;
            }
            SdProjectDetails spd = null;
            if (Id2 != 0) {
                spd = (SdProjectDetails)((Object)session.get(SdProjectDetails.class, (Object)Id2));
                spd.setParameterValue(String.valueOf(sourceFilterId));
                this.hibernateDaoOperations.update((Object)spd);
            } else {
                SdProjectParametersMaster sppm = (SdProjectParametersMaster)session.get(SdProjectParametersMaster.class, (Object)7);
                if (sppm != null) {
                    SdProjectMaster spm = (SdProjectMaster)((Object)session.get(SdProjectMaster.class, (Object)projectId));
                    spd = new SdProjectDetails(sppm, spm, String.valueOf(sourceFilterId));
                    this.hibernateDaoOperations.save((Object)spd);
                }
            }
            this.hibernateDaoOperations.flush();
            String sql = "update sd_sourcefilter set isdefaultsource = 1 where ProjectID = :ProjectID and sourcefilterid = :sourceFilterID ";
            MutationQuery mutationQuery = session.createNativeMutationQuery(sql);
            mutationQuery.setParameter("sourceFilterID", (Object)sourceFilterId);
            mutationQuery.setParameter("ProjectID", (Object)projectId);
            mutationQuery.executeUpdate();
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdSourcefilter> getSdSourcefilterByProjectId(Integer projectId, Integer pageNo, Integer pageSize, String sortColumn, String sortDir) {
        Object query = " from SdSourcefilter sd where sd.id.projectId = :projectId and sd.sourceFilterStatus = 0";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        query = (String)query + " order by " + sortColumn + " " + sortDir;
        return this.genericHibernateDaoOperations.findByNamedParamAndPagesize((String)query, paramNames, values, pageNo, pageSize, SdDTOEnum.SD_SOURCEFILTER);
    }

    @Override
    @Transactional(readOnly=true)
    public SdSourcefilter getSdSourcefilterBySourceFilterId(Integer projectId, Integer sourceFilterId) {
        String query = " from SdSourcefilter sd where sd.id.projectId = :projectId and sd.id.sourceFilterId=:sourceFilterId";
        String[] paramNames = new String[]{"projectId", "sourceFilterId"};
        Object[] values = new Object[]{projectId, sourceFilterId};
        List source = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdSourcefilter.class);
        return source != null && !source.isEmpty() ? (SdSourcefilter)((Object)source.get(0)) : null;
    }

    @Override
    @Transactional(readOnly=true)
    public SdSourcefilter getDefaultSdSourceId(Integer projectId) {
        String query = " from SdSourcefilter sd where sd.id.projectId = :projectId and sd.isDefaultSource = 1";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        List source = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdSourcefilter.class);
        return source != null && !source.isEmpty() ? (SdSourcefilter)((Object)source.get(0)) : null;
    }

    @Override
    @Transactional
    public int saveSourceName(SdSourcefilterDTO sourceDTO, int projectId) {
        Session session = this.sessionFactory.getCurrentSession();
        boolean i = false;
        String Query2 = "insert into sd_sourcefilter(FilterName, sourceFilterID, ProjectID) value(:FilterName, :sourceFilterId, :projectId)";
        MutationQuery sqlQuery = session.createNativeMutationQuery(Query2);
        sqlQuery.setParameter("FilterName", (Object)sourceDTO.getFilterName());
        Integer sourceId = this.SourceFilterIDIncDAO();
        sqlQuery.setParameter("sourceFilterId", (Object)sourceId);
        sqlQuery.setParameter("projectId", (Object)projectId);
        sqlQuery.executeUpdate();
        return sourceId;
    }

    @Override
    @Transactional
    public void updateSourceName(int sourceId, String sourceFilterName, int projectId) {
        Session session = this.sessionFactory.getCurrentSession();
        String Query2 = "update sd_sourcefilter set FilterName = :sourceFilterName where ProjectID = :projectId and sourcefilterid = :sourceId";
        MutationQuery sqlQuery = session.createNativeMutationQuery(Query2);
        sqlQuery.setParameter("sourceId", (Object)sourceId);
        sqlQuery.setParameter("projectId", (Object)projectId);
        sqlQuery.setParameter("sourceFilterName", (Object)sourceFilterName);
        sqlQuery.executeUpdate();
    }

    @Override
    @Transactional
    public void saveSourceDescription(int sourceId, String sourceDescription, int projectId) {
        Session session = this.sessionFactory.getCurrentSession();
        String Query2 = "update sd_sourcefilter set FilterDescription = :sourceDescription where ProjectID = :projectId and sourcefilterid = :sourceId";
        MutationQuery sqlQuery = session.createNativeMutationQuery(Query2);
        sqlQuery.setParameter("sourceId", (Object)sourceId);
        sqlQuery.setParameter("projectId", (Object)projectId);
        sqlQuery.setParameter("sourceDescription", (Object)sourceDescription);
        sqlQuery.executeUpdate();
    }

    @Override
    @Transactional
    public void saveConsiderUsersList(int sourceId, int displayUsersList, int projectId) {
        Session session = this.sessionFactory.getCurrentSession();
        String Query2 = "update sd_sourcefilter set ConsiderUsersList = :displayUsersList where ProjectID = :projectId and sourcefilterid = :sourceId";
        MutationQuery sqlQuery = session.createNativeMutationQuery(Query2);
        sqlQuery.setParameter("sourceId", (Object)sourceId);
        sqlQuery.setParameter("projectId", (Object)projectId);
        sqlQuery.setParameter("displayUsersList", (Object)displayUsersList);
        sqlQuery.executeUpdate();
    }

    @Override
    @Transactional
    public void deleteSdSource(int sourceId, int projectId) {
        Session session = this.sessionFactory.getCurrentSession();
        String Query2 = "update sd_sourcefilter set sourceFilterStatus = 2 where ProjectID = :projectId and sourcefilterid = :sourceId";
        MutationQuery sqlQuery = session.createNativeMutationQuery(Query2);
        sqlQuery.setParameter("sourceId", (Object)sourceId);
        sqlQuery.setParameter("projectId", (Object)projectId);
        sqlQuery.executeUpdate();
    }

    @Override
    public Integer checkDuplicateSource(String sourceName, Integer projectId, Integer sourceId) {
        Integer isDuplicate = 0;
        Session session = this.sessionFactory.getCurrentSession();
        String query = "SELECT filterName FROM sd_sourcefilter WHERE filterName=:sourceName and sourcefilterid <> :sourceId and projectId=:projectId";
        NativeQuery sqlQuery = session.createNativeQuery(query);
        sqlQuery.setParameter("sourceName", (Object)sourceName);
        sqlQuery.setParameter("sourceId", (Object)sourceId);
        sqlQuery.setParameter("projectId", (Object)projectId);
        sqlQuery.setMaxResults(1);
        if (sqlQuery.uniqueResult() != null) {
            isDuplicate = 1;
        }
        return isDuplicate;
    }

    @Override
    @Transactional
    public void updateDefaultSource(int sourceId, int status, int projectId) {
        Session session = this.sessionFactory.getCurrentSession();
        String Query2 = "update sd_sourcefilter set isdefaultsource = :status where projectId = :projectId and sourcefilterid = :sourceId ";
        MutationQuery sqlQuery = session.createNativeMutationQuery(Query2);
        sqlQuery.setParameter("sourceId", (Object)sourceId);
        sqlQuery.setParameter("status", (Object)status);
        sqlQuery.setParameter("projectId", (Object)projectId);
        sqlQuery.executeUpdate();
    }

    @Override
    public void updateDefaultSourceValue(Integer sourceFilterId, Integer projectId) {
        Session session = this.sessionFactory.getCurrentSession();
        Query query = session.createQuery("select projectDetailsId from SdProjectDetails where sdProjectMaster.projectId=:projectId and sdProjectParametersMaster.parameterId=7");
        query.setParameter("projectId", (Object)projectId);
        SdProjectDetails spd = null;
        if (query.uniqueResult() != null) {
            spd = (SdProjectDetails)((Object)session.get(SdProjectDetails.class, (Object)((Integer)query.uniqueResult())));
            spd.setParameterValue(String.valueOf(sourceFilterId));
            this.hibernateDaoOperations.update((Object)spd);
        } else {
            SdProjectParametersMaster sppm = (SdProjectParametersMaster)session.get(SdProjectParametersMaster.class, (Object)7);
            if (sppm != null) {
                SdProjectMaster spm = (SdProjectMaster)((Object)session.get(SdProjectMaster.class, (Object)projectId));
                spd = new SdProjectDetails(sppm, spm, String.valueOf(sourceFilterId));
                this.hibernateDaoOperations.save((Object)spd);
            }
        }
        this.hibernateDaoOperations.flush();
        MutationQuery sqlQuery = session.createNativeMutationQuery("update sd_sourcefilter set isdefaultsource = 1 where ProjectID = :ProjectID and sourcefilterid = :sourceFilterID ");
        sqlQuery.setParameter("sourceFilterID", (Object)sourceFilterId);
        sqlQuery.setParameter("ProjectID", (Object)projectId);
        sqlQuery.executeUpdate();
    }
}

