/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdStatecategoryMasterDAO;
import com.sapphireims.itsm.mindto.StateCategoryMinDTO;
import com.sapphireims.itsm.model.SdStatecategoryMaster;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class SdStatecategoryMasterDAO
extends GenericHibernateRepository<SdStatecategoryMaster, Integer>
implements ISdStatecategoryMasterDAO {
    @Override
    public List<SdStatecategoryMaster> getSdStatecategoryMasterByProjectId(Integer projectId) {
        String query = " from SdStatecategoryMaster where sdProjectMaster.projectId = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdStatecategoryMaster.class);
    }

    @Override
    public List<StateCategoryMinDTO> getStateCategoryMinDataByProject(Integer projectId) {
        String query = "Select stateCategoryId AS id,stateCategoryName AS name from SdStatecategoryMaster where sdProjectMaster.projectId=:projectId";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.genericHibernateDaoOperations.findByNamedParam(query, paramNames, values, SdDTOEnum.STATE_CATEGORY_MIN_DTO);
    }

    @Override
    public List<SdStatecategoryMaster> getSdStatecategoryMasterByProjectId(Integer projectId, Integer pageNo, Integer pageSize, String sortColumn, String sortDir) {
        Object query = " from SdStatecategoryMaster where sdProjectMaster.projectId = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        if (sortColumn != null && !sortColumn.isEmpty()) {
            query = (String)query + " order by " + sortColumn + " " + sortDir;
        }
        return this.genericHibernateDaoOperations.findByNamedParamAndPagesize((String)query, paramNames, values, pageNo, pageSize, SdDTOEnum.SD_STATE_CATEGORY_MASTER);
    }

    @Override
    public Integer checkDuplicateStateCategoryName(String stateCategoryName, Integer projectId, Integer stateCategoryId) {
        Integer isDuplicate = 0;
        String query = "SELECT stateCategoryName FROM SdStatecategoryMaster WHERE stateCategoryName=:stateCategoryName and sdProjectMaster.projectId=:projectId and stateCategoryId <> :stateCategoryId";
        String[] paramNames = new String[]{"stateCategoryName", "projectId", "stateCategoryId"};
        Object[] values = new Object[]{stateCategoryName, projectId, stateCategoryId};
        List nameList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, String.class);
        if (nameList != null && nameList.size() > 0) {
            isDuplicate = 1;
        }
        return isDuplicate;
    }

    @Override
    public void deleteSdStatecategoryMaster(int stateCategoryId) {
        this.hibernateDaoOperations.delete(this.hibernateDaoOperations.get(SdStatecategoryMaster.class, (Serializable)Integer.valueOf(stateCategoryId)));
    }
}

