/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphire.itsm.mailrouting.model.SdStatesMaster;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdReadunreadrecordsDAO;
import com.sapphireims.itsm.dao.ISdStatesMasterDAO;
import com.sapphireims.itsm.dto.SdStatesMasterDTO;
import com.sapphireims.itsm.mindto.StatesMinDTO;
import com.sapphireims.itsm.model.SdMultiapprovalDetails;
import com.sapphireims.itsm.model.SdMultiapprovalMaster;
import com.sapphireims.itsm.model.SdStateRoles;
import com.sapphireims.itsm.model.SdStatecategoryDetails;
import com.sapphireims.itsm.model.SdStatesFixedfields;
import com.sapphireims.itsm.model.SdStatesFixedfieldsPermissions;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import com.sapphireims.util.CollectionUtil;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SdStatesMasterDAO
extends GenericHibernateRepository<SdStatesMaster, Integer>
implements ISdStatesMasterDAO {
    @Autowired
    private ISdReadunreadrecordsDAO sdReadunreadrecordsDAO;

    @Override
    public List<SdStatesMaster> getSdStatesMasterByProjectId(Integer projectId) {
        String query = " from SdStatesMaster where sdProjectMaster.projectId = :projectId and status=0";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdStatesMaster.class);
    }

    @Override
    public void saveSdStatecategoryDetailses(List<SdStatecategoryDetails> sd) {
        if (CollectionUtil.isNotEmpty(sd)) {
            for (SdStatecategoryDetails s : sd) {
                this.hibernateDaoOperations.save((Object)s);
            }
        }
    }

    @Override
    public void saveSdStatesFixedfieldses(List<SdStatesFixedfields> sd) {
        if (CollectionUtil.isNotEmpty(sd)) {
            for (SdStatesFixedfields s : sd) {
                this.hibernateDaoOperations.save((Object)s);
            }
        }
    }

    @Override
    public void saveSdSdStatesFixedfieldsPermissionses(List<SdStatesFixedfieldsPermissions> sd) {
        if (CollectionUtil.isNotEmpty(sd)) {
            for (SdStatesFixedfieldsPermissions s : sd) {
                this.hibernateDaoOperations.save((Object)s);
            }
        }
    }

    @Override
    public List<SdStateRoles> getSdStateRolesByProjectId(Integer projectId) {
        String query = " from SdStateRoles where projectId = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdStateRoles.class);
    }

    @Override
    public List<SdMultiapprovalMaster> getSdMultiapprovalMastersByStateId(Integer stateId) {
        String query = " from SdMultiapprovalMaster where stateId = :stateId ";
        String[] paramNames = new String[]{"stateId"};
        Object[] values = new Object[]{stateId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdMultiapprovalMaster.class);
    }

    @Override
    public List<SdMultiapprovalDetails> getSdMultiapprovalDetailsByAppRuleId(Integer appRuleId) {
        String query = " from SdMultiapprovalDetails where sdMultiapprovalMaster.appRuleId = :appRuleId ";
        String[] paramNames = new String[]{"appRuleId"};
        Object[] values = new Object[]{appRuleId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdMultiapprovalDetails.class);
    }

    @Override
    public void saveSdStateRole(List<SdStateRoles> roles) {
        if (CollectionUtil.isNotEmpty(roles)) {
            for (SdStateRoles s : roles) {
                this.hibernateDaoOperations.save((Object)s);
            }
        }
    }

    @Override
    public void saveSdMultiapprovalMasters(List<SdMultiapprovalMaster> multiapprovalMasters) {
        if (CollectionUtil.isNotEmpty(multiapprovalMasters)) {
            for (SdMultiapprovalMaster s : multiapprovalMasters) {
                this.hibernateDaoOperations.save((Object)s);
            }
        }
    }

    @Override
    public void saveSdMultiapprovalDetails(List<SdMultiapprovalDetails> multiapprovalDetails) {
        if (CollectionUtil.isNotEmpty(multiapprovalDetails)) {
            for (SdMultiapprovalDetails s : multiapprovalDetails) {
                this.hibernateDaoOperations.save((Object)s);
            }
        }
    }

    @Override
    public List<StatesMinDTO> getSdStateMasterMinDataByProject(Integer projectId) {
        String query = "Select stateId AS id,stateName AS name from SdStatesMaster where status=0 and sdProjectMaster.projectId=:projectId";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.genericHibernateDaoOperations.findByNamedParam(query, paramNames, values, SdDTOEnum.STATE_MIN_DTO);
    }

    @Override
    public SdStatesMasterDTO getStateFields(Integer stateId) {
        String query = "Select stateName AS stateName,shortName AS shortName,color AS color from SdStatesMaster where stateId=:stateId";
        String[] paramName = new String[]{"stateId"};
        Object[] value = new Object[]{stateId};
        List getStateFieldList = this.genericHibernateDaoOperations.findByNamedParam(query, paramName, value, SdDTOEnum.SD_STATESMASTER_DTO);
        SdStatesMasterDTO sdStatesMasterDTO = null;
        if (getStateFieldList != null && getStateFieldList.size() == 1) {
            String inheritedFromQuery;
            String input;
            sdStatesMasterDTO = (SdStatesMasterDTO)((Object)getStateFieldList.get(0));
            String stateCategoryQuery = "Select sd.stateCategoryId AS stateCategoryId, sm.stateCategoryName AS stateCategoryName  from SdStatecategoryDetails sd, SdStatecategoryMaster sm  where sd.sdStatesmaster.stateId=:stateId and sd.stateCategoryId=sm.stateCategoryId";
            String[] paramNames = new String[]{"stateId"};
            Object[] values = new Object[]{stateId};
            List getStateCategoryList = this.genericHibernateDaoOperations.findByNamedParam(stateCategoryQuery, paramNames, values, SdDTOEnum.SD_STATESMASTER_DTO);
            if (getStateCategoryList != null && getStateCategoryList.size() == 1) {
                for (SdStatesMasterDTO dto : getStateCategoryList) {
                    sdStatesMasterDTO.setStateCategoryId(dto.getStateCategoryId());
                    sdStatesMasterDTO.setStateCategoryName(dto.getStateCategoryName());
                }
            }
            if ((input = (String)this.hibernateDaoOperations.findByNamedParamUniqueResult(inheritedFromQuery = "Select input from SdStatesFixedfields where sdStatesmaster.stateId=:stateId and input IN('User ID','App ID','Multi App ID')", paramNames, values, String.class)) != null) {
                switch (input) {
                    case "User ID": {
                        sdStatesMasterDTO.setInheritedFrom("User ID");
                        sdStatesMasterDTO.setInheritedFromText("Assign");
                        break;
                    }
                    case "App ID": {
                        sdStatesMasterDTO.setInheritedFrom("App ID");
                        sdStatesMasterDTO.setInheritedFromText("Waiting for approval");
                        break;
                    }
                    case "Multi App ID": {
                        sdStatesMasterDTO.setInheritedFrom("Multi App ID");
                        sdStatesMasterDTO.setInheritedFromText("Multi-level Approval");
                    }
                }
            }
        }
        return sdStatesMasterDTO;
    }

    @Override
    public Integer checkDuplicateState(String stateName, Integer projectId) {
        Integer isDuplicate = 0;
        String query = "SELECT stateName FROM SdStatesMaster WHERE stateName=:stateName and sdProjectMaster.projectId=:projectId and status!=2";
        String[] paramNames = new String[]{"stateName", "projectId"};
        Object[] values = new Object[]{stateName, projectId};
        List stateNameList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, String.class);
        if (stateNameList != null && stateNameList.size() > 0) {
            isDuplicate = 1;
        }
        return isDuplicate;
    }

    @Override
    public Integer updateState(String stateName, String shortName, String color, Integer stateId) {
        String query = "Update SdStatesMaster set stateName=:stateName, shortName=:shortName,color=:color where stateId=:stateId";
        String[] paramNames = new String[]{"stateName", "shortName", "color", "stateId"};
        Object[] values = new Object[]{stateName, shortName, color, stateId};
        return this.hibernateDaoOperations.bulkUpdateOrDeleteByParam(query, paramNames, values);
    }

    @Override
    public Integer setDeleteStatus(Integer stateId) {
        String query = "Update SdStatesMaster set status=2 where stateId=:stateId and deletionAllowed=0";
        String[] paramNames = new String[]{"stateId"};
        Object[] values = new Object[]{stateId};
        return this.hibernateDaoOperations.bulkUpdateOrDeleteByParam(query, paramNames, values);
    }

    @Override
    public List<SdStatesMaster> getSdStatesMasterDTOForStartState(Integer projectId) {
        String query = " from SdStatesMaster where isStartState=1 and sdProjectMaster.projectId=:projectId";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdStatesMaster.class);
    }

    @Override
    public Long getStateTextTicketCount(Integer problemId, String stateText) {
        stateText = "%" + (String)stateText + "%";
        String query = "SELECT COUNT(enclId) FROM SdEncldetails encl WHERE encl.enclName LIKE :enclosureName and encl.sdServicereqmaster.problemId = :problemId";
        String[] paramNames = new String[]{"enclosureName", "problemId"};
        Object[] values = new Object[]{stateText, problemId};
        return (Long)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, Long.class);
    }

    @Override
    public String getStateCategoryName(Integer stateCategoryId) {
        String sbName = "";
        String query = "select stateCategoryName from SdStatecategoryMaster where stateCategoryId=:stateCategoryId";
        String[] paramNames = new String[]{"stateCategoryId"};
        Object[] values = new Object[]{stateCategoryId};
        String subCatName = (String)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, String.class);
        if (subCatName != null) {
            sbName = subCatName;
        }
        return sbName;
    }

    @Override
    public SdStatesMaster getStateByStateName(String stateName, Integer projectId) {
        String query = "from SdStatesMaster where stateName=:stateName and sdProjectMaster.projectId=:projectId";
        String[] paramNames = new String[]{"stateName", "projectId"};
        Object[] values = new Object[]{stateName, projectId};
        return (SdStatesMaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdStatesMaster.class));
    }

    @Override
    public SdStatesMaster getEndState(Integer projectId) {
        String query = "from SdStatesMaster where sdProjectMaster.projectId=:projectId and status=0 and isEndState=1";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return (SdStatesMaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdStatesMaster.class));
    }

    @Override
    public SdStatesMaster getByProjectIdAndStateId(Integer projectId, Integer stateId) {
        String query = " from SdStatesMaster where sdProjectMaster.projectId = :projectId and stateId =:stateId";
        String[] paramNames = new String[]{"projectId", "stateId"};
        Object[] values = new Object[]{projectId, stateId};
        return (SdStatesMaster)((Object)this.hibernateDaoOperations.findByNamedParamMaxResult(query, paramNames, values, 1));
    }

    @Override
    public List<SdStatesMaster> getStatesNameByWorkgroupId(Integer workGroupID) {
        String query = " SELECT ss.* FROM Sd_Workgroupdetails sw,sd_statesmaster ss where ss.stateId= sw.workGroupValue and sw.workGroupType=11 and sw.workGroupId=:workGroupID";
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("workGroupID", workGroupID);
        return this.hibernateDaoOperations.sqlQuery(query, paramMap, SdStatesMaster.class);
    }

    @Override
    public List<SdStatesMaster> getStatesByProjectId(Integer projectId) {
        String query = "FROM SdStatesMaster WHERE status = 0 AND isStartState <> 1 AND sdProjectMaster.projectId= :projectId";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdStatesMaster.class);
    }

    @Override
    public List<SdStatesMaster> getStatesListByState(List<Integer> statesList) {
        String query = "from SdStatesMaster where stateId in(:statesList)";
        String[] paramNames = new String[]{"statesList"};
        Object[] values = new Object[]{statesList};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdStatesMaster.class);
    }

    @Override
    public List<SdStatesMaster> getSdStateMasterListByProject(Integer projectId) {
        String query = "FROM SdStatesMaster WHERE status = 0 AND sdProjectMaster.projectId= :projectId";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdStatesMaster.class);
    }
}

