/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.dto.DataSource;
import com.sapphireims.itsm.dao.ISdSubcategorymasterDAO;
import com.sapphireims.itsm.dao.impl.SdCategorymasterDAO;
import com.sapphireims.itsm.dto.SdSubCategoryMasterDTO;
import com.sapphireims.itsm.mindto.CategoryMinDTO;
import com.sapphireims.itsm.mindto.SubCategoryMinDTO;
import com.sapphireims.itsm.model.SdCategorymaster;
import com.sapphireims.itsm.model.SdSubcategorymaster;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SdSubcategorymasterDAO
extends GenericHibernateRepository<SdSubcategorymaster, Integer>
implements ISdSubcategorymasterDAO {
    private static final String PROJECT_ID = "projectId";
    private static final String CATEGORY_ID = "categoryId";
    @Autowired
    private SdCategorymasterDAO sdCategorymasterDAO;

    @Override
    public List<SdSubcategorymaster> getSdSubcategorymasterByProjectId(Integer projectId) {
        String query = " from SdSubcategorymaster where sdProjectMaster.projectId = :projectId ";
        String[] paramNames = new String[]{PROJECT_ID};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdSubcategorymaster.class);
    }

    @Override
    public List<SdSubcategorymaster> getSdSubcategorymasterByCategoryIdAndProjectId(Integer projectId, Integer categoryId) {
        String query = " from SdSubcategorymaster where sdProjectMaster.projectId = :projectId and sdCategorymaster.categoryId = :categoryId and status=0";
        String[] paramNames = new String[]{PROJECT_ID, CATEGORY_ID};
        Object[] values = new Object[]{projectId, categoryId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdSubcategorymaster.class);
    }

    @Override
    public List<SubCategoryMinDTO> getSubCategory(DataSource datasource) {
        String sql = "SELECT    s.SubCategoryID AS id,   s.SubCategoryName AS name,    c.CategoryId AS categoryId,    c.CategoryName AS categoryName  FROM   sd_subcategorymaster s,   sd_categorymaster c  WHERE s.CategoryId = c.CategoryId  \tAND s.Status = 0  \tAND c.Status=0    AND c.ProjectId = :projectId ";
        HashMap<String, Integer> params = new HashMap<String, Integer>(2);
        params.put(PROJECT_ID, datasource.getProjectid());
        if (StringUtils.isNotEmpty((CharSequence)datasource.getFilterParm1())) {
            sql = sql.concat("  AND c.CategoryId = :categoryId ");
            params.put(CATEGORY_ID, Integer.parseInt(datasource.getFilterParm1()));
        }
        NativeQuery q = this.hibernateDaoOperations.getSessionFactory().getCurrentSession().createNativeQuery(sql).addScalar("id", StandardBasicTypes.INTEGER).addScalar("name", StandardBasicTypes.STRING).addScalar(CATEGORY_ID, StandardBasicTypes.INTEGER).addScalar("categoryName", StandardBasicTypes.STRING);
        if (params.size() > 0) {
            for (String key : params.keySet()) {
                q.setParameter(key, params.get(key));
            }
        }
        q.setResultTransformer(Transformers.aliasToBean(SubCategoryMinDTO.class));
        return q.list();
    }

    @Override
    public List<CategoryMinDTO> getSdSubcategoryMinDataBasedOnService(DataSource datasource) {
        List<CategoryMinDTO> categoryList = this.sdCategorymasterDAO.getSdCategorymasterByProjectIdAndService(datasource.getProjectid(), datasource.getFilterParm1());
        String[] serviceArray = datasource.getFilterParm1().split(",");
        ArrayList<Integer> serviceList = new ArrayList<Integer>();
        for (String service : serviceArray) {
            serviceList.add(Integer.parseInt(service));
        }
        ArrayList<CategoryMinDTO> categoryMinDTOList = new ArrayList<CategoryMinDTO>();
        String query = "Select distinct(ssub.subCategoryId) AS subcategoryId,ssub.subCategoryName AS subcategoryName from SdSubcategorymaster ssub ,SdServiceParametersDetails ssp where ssub.subCategoryId=ssp.parameterValue and ssub.status=0 and ssub.sdProjectMaster.projectId=:projectId and ssub.sdCategorymaster.categoryId=:categoryId and ssp.sdServiceParametersMaster.parameterId=2 and ssp.serviceId IN(:serviceId) order by subCategoryName";
        for (CategoryMinDTO category : categoryList) {
            CategoryMinDTO categoryMinDto = new CategoryMinDTO();
            String[] paramNames = new String[]{PROJECT_ID, CATEGORY_ID, "serviceId"};
            Object[] values = new Object[]{datasource.getProjectid(), category.getCategoryId(), serviceList};
            List subcategoryList = this.genericHibernateDaoOperations.findByNamedParam(query, paramNames, values, SdDTOEnum.SUBCATEGORY_MIN_DTO);
            categoryMinDto.setCategoryId(category.getCategoryId());
            categoryMinDto.setCategoryName(category.getCategoryName());
            categoryMinDto.setSubcategoryList(subcategoryList);
            categoryMinDTOList.add(categoryMinDto);
        }
        return categoryMinDTOList;
    }

    @Override
    public Integer checkDuplicateSubcategory(String subcategoryName, Integer categoryId, Integer projectId) {
        Integer isDuplicate = 0;
        String query = "SELECT subCategoryName FROM SdSubcategorymaster where status=0 and sdCategorymaster.categoryId=:categoryId and subCategoryName = :subCategoryName and sdProjectMaster.projectId=:projectId";
        String[] paramNames = new String[]{CATEGORY_ID, "subCategoryName", PROJECT_ID};
        Object[] values = new Object[]{categoryId, subcategoryName, projectId};
        List subcategoryList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, String.class);
        if (subcategoryList != null && subcategoryList.size() > 0) {
            isDuplicate = 1;
        }
        return isDuplicate;
    }

    @Override
    public List<SdSubcategorymaster> getSubCategoryNameByWorkgroupId(Integer workGroupID) {
        String query = " SELECT ss.* FROM Sd_Workgroupdetails sw,Sd_Subcategorymaster ss where ss.subCategoryId= sw.workGroupValue and sw.workGroupType=3 and sw.workGroupId=:workGroupID";
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("workGroupID", workGroupID);
        return this.hibernateDaoOperations.sqlQuery(query, paramMap, SdSubcategorymaster.class);
    }

    @Override
    public List<SdSubcategorymaster> getSubCategoryListBySubCategory(List<Integer> subCategoryIdList) {
        String query = "from SdSubcategorymaster where subCategoryId in(:subCategoryIdList)";
        String[] paramNames = new String[]{"subCategoryIdList"};
        Object[] values = new Object[]{subCategoryIdList};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdSubcategorymaster.class);
    }

    @Override
    public List<SdSubcategorymaster> getSubCategoryNameBySubCategoryIds(List<Integer> subCategoryIdList, Integer projectId) {
        String query = "from SdSubcategorymaster where status= 0 and sdProjectMaster.projectId = :projectId and subCategoryId in(:subCategoryIdList)";
        String[] paramNames = new String[]{PROJECT_ID, "subCategoryIdList"};
        Object[] values = new Object[]{projectId, subCategoryIdList};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdSubcategorymaster.class);
    }

    @Override
    public List<SdSubcategorymaster> getSdSubCategoryMasterByProjectId(Integer projectId, Integer pageNo, Integer pageSize, String columnSort, String sortDir) {
        StringBuilder query = new StringBuilder(" from SdSubcategorymaster s left join fetch s.sdCategorymaster c where s.sdProjectMaster.projectId = :projectId");
        query.append(" ORDER BY ").append(columnSort).append(" ").append(sortDir);
        String[] paramNames = new String[]{PROJECT_ID};
        Object[] values = new Object[]{projectId};
        return this.genericHibernateDaoOperations.findByNamedParamAndPagesize(query.toString(), paramNames, values, pageNo, pageSize, SdDTOEnum.SD_SUBCATEGORY_MASTER);
    }

    @Override
    public SdSubcategorymaster getSdSubcategorymasterBySubCategoryIdAndProjectId(Integer projectId, Integer subCategoryId) {
        String query = " from SdSubcategorymaster where sdProjectMaster.projectId = :projectId and subCategoryId = :subCategoryId and status=0";
        String[] paramNames = new String[]{PROJECT_ID, "subCategoryId"};
        Object[] values = new Object[]{projectId, subCategoryId};
        return (SdSubcategorymaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdSubcategorymaster.class));
    }

    @Override
    public SdSubcategorymaster updateSubCategoryShortName(Integer subCategoryId, String shortName) {
        SdSubcategorymaster state = (SdSubcategorymaster)((Object)this.hibernateDaoOperations.get(SdSubcategorymaster.class, (Serializable)subCategoryId));
        state.setShortname(shortName);
        this.hibernateDaoOperations.saveOrUpdate((Object)state);
        return state;
    }

    @Override
    public void updateSubCategoryDescription(Integer subCategoryId, String subCategoryDescription) {
        SdSubcategorymaster sdSubcategorymaster = (SdSubcategorymaster)((Object)this.hibernateDaoOperations.get(SdSubcategorymaster.class, (Serializable)subCategoryId));
        sdSubcategorymaster.setSubCategoryDescription(subCategoryDescription);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdSubcategorymaster);
    }

    @Override
    public void saveSubCategoryStatus(int subCategoryId, int status) {
        SdSubcategorymaster subCategorymaster = (SdSubcategorymaster)((Object)this.hibernateDaoOperations.get(SdSubcategorymaster.class, (Serializable)Integer.valueOf(subCategoryId)));
        subCategorymaster.setStatus((byte)status);
        this.hibernateDaoOperations.saveOrUpdate((Object)subCategorymaster);
    }

    @Override
    public SdSubcategorymaster updateSubCategoryName(Integer subCategoryId, String subCategoryName) {
        SdSubcategorymaster state = (SdSubcategorymaster)((Object)this.hibernateDaoOperations.get(SdSubcategorymaster.class, (Serializable)subCategoryId));
        state.setSubCategoryName(subCategoryName);
        this.hibernateDaoOperations.saveOrUpdate((Object)state);
        return state;
    }

    @Override
    public void updateCategoryID(int subCategoryId, int categoryId) {
        SdSubcategorymaster subCategorymaster = (SdSubcategorymaster)((Object)this.hibernateDaoOperations.get(SdSubcategorymaster.class, (Serializable)Integer.valueOf(subCategoryId)));
        SdCategorymaster categoryMaster = (SdCategorymaster)((Object)this.hibernateDaoOperations.get(SdCategorymaster.class, (Serializable)Integer.valueOf(categoryId)));
        subCategorymaster.setSdCategorymaster(categoryMaster);
        this.hibernateDaoOperations.saveOrUpdate((Object)subCategorymaster);
    }

    @Override
    public SdSubcategorymaster getSdSubcategoryBySubCategoryIdAndProjectId(Integer projectId, Integer subCategoryId) {
        String query = " from SdSubcategorymaster where sdProjectMaster.projectId = :projectId and subCategoryId = :subCategoryId";
        String[] paramNames = new String[]{PROJECT_ID, "subCategoryId"};
        Object[] values = new Object[]{projectId, subCategoryId};
        return (SdSubcategorymaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdSubcategorymaster.class));
    }

    @Override
    public SdSubcategorymaster saveSubCategoryName(SdSubCategoryMasterDTO sdSubcategorymaster, int projectId, int category) {
        SdProjectMaster sdProjectMaster = (SdProjectMaster)((Object)this.hibernateDaoOperations.get(SdProjectMaster.class, (Serializable)Integer.valueOf(projectId)));
        SdCategorymaster sdCategorymaster = (SdCategorymaster)((Object)this.hibernateDaoOperations.get(SdCategorymaster.class, (Serializable)Integer.valueOf(category)));
        SdSubcategorymaster subcategorymaster = new SdSubcategorymaster();
        subcategorymaster.setSubCategoryName(sdSubcategorymaster.getSubCategoryName());
        subcategorymaster.setSubCategoryDescription(sdSubcategorymaster.getSubCategoryDescription());
        subcategorymaster.setShortname(sdSubcategorymaster.getShortname());
        subcategorymaster.setStatus(sdSubcategorymaster.getStatus());
        subcategorymaster.setSdProjectMaster(sdProjectMaster);
        subcategorymaster.setSdCategorymaster(sdCategorymaster);
        this.hibernateDaoOperations.save((Object)subcategorymaster);
        return subcategorymaster;
    }

    @Override
    public Integer checkDuplicateSubcategorys(String subcategoryName, Integer categoryId, Integer projectId, Integer subCategoryId) {
        Integer isDuplicate = 0;
        String query = "SELECT subCategoryName FROM SdSubcategorymaster where status=0 and sdCategorymaster.categoryId=:categoryId and subCategoryName = :subCategoryName and sdProjectMaster.projectId=:projectId and subCategoryId != :subCategoryId";
        String[] paramNames = new String[]{CATEGORY_ID, "subCategoryName", PROJECT_ID, "subCategoryId"};
        Object[] values = new Object[]{categoryId, subcategoryName, projectId, subCategoryId};
        List subcategoryList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, String.class);
        if (subcategoryList != null && subcategoryList.size() > 0) {
            isDuplicate = 1;
        }
        return isDuplicate;
    }

    @Override
    public List<SdSubcategorymaster> getSdSubcategoryBysubCategoryIdsAndProjectId(Integer projectId, List<Integer> subCategoryIdList) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("SELECT sdscm ").append("FROM SdSubcategorymaster sdscm, SdServiceParametersDetails sdspd, SdService sds ").append("WHERE sdscm.sdProjectMaster.projectId = :projectId ").append("AND sdscm.status = 0 ").append("AND sdscm.subCategoryId IN :subCategoryIdList ").append("AND sdspd.sdServiceParametersMaster.parameterId = 2 ").append("AND sdspd.parameterValue = sdscm.subCategoryId ").append("AND sds.status = 0 ").append("AND sds.sdProjectMaster.projectId = :projectId ").append("AND sds.serviceId = sdspd.serviceId ").append("GROUP BY sdscm.subCategoryId, sdscm.subCategoryName ").append("ORDER BY sdscm.subCategoryId ASC");
        String[] paramNames = new String[]{PROJECT_ID, "subCategoryIdList"};
        Object[] values = new Object[]{projectId, subCategoryIdList};
        return this.hibernateDaoOperations.findByNamedParam(queryBuilder.toString(), paramNames, values, SdSubcategorymaster.class);
    }
}

