/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.dto.SearchEntityResponce;
import com.sapphireims.dto.SearchRequestDTO;
import com.sapphireims.itsm.dao.ISdTemplateDAO;
import com.sapphireims.itsm.model.SdTemplate;
import com.sapphireims.util.CollectionUtil;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class SdTemplateDAO
extends GenericHibernateRepository<SdTemplate, Integer>
implements ISdTemplateDAO {
    @Override
    public List<SdTemplate> getTemplatesByProjectId(Integer projectId) {
        String query = " from SdTemplate where sdProjectMaster.projectId = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdTemplate.class);
    }

    @Override
    public SearchEntityResponce getTemplates(SearchRequestDTO search) {
        Object orderByCondition = "";
        if (search.getSortAttribute() != null && search.getSortDirection() != null) {
            orderByCondition = " order by " + search.getSortAttribute() + " " + search.getSortDirection();
        }
        String query = " from SdTemplate where sdProjectMaster.projectId = :projectId " + (String)orderByCondition;
        String countQuery = " select count(id) from SdTemplate where sdProjectMaster.projectId = :projectId ";
        if (search.getIsCMDB() == 1) {
            query = " from SdTemplate where assetModuleId = :projectId " + (String)orderByCondition;
            countQuery = " select count(id) from SdTemplate where assetModuleId = :projectId ";
        }
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{search.getProjectId()};
        return this.hibernateDaoOperations.findByNamedParam(query, countQuery, paramNames, values, search);
    }

    @Override
    public SdTemplate getTmplateByName(String name) {
        List templates = this.hibernateDaoOperations.findByProperty(SdTemplate.class, "name", (Object)name);
        if (CollectionUtil.isNotEmpty(templates)) {
            return (SdTemplate)((Object)templates.get(0));
        }
        return null;
    }

    @Override
    public List<SdTemplate> getTemplatesByModuleId(Integer assetModuleId) {
        String query = " from SdTemplate where assetModuleId = :assetModuleId and isCMDB=1 ";
        String[] paramNames = new String[]{"assetModuleId"};
        Object[] values = new Object[]{assetModuleId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdTemplate.class);
    }
}

