/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdUipMasterDAO;
import com.sapphireims.itsm.dto.SdUipMasterDTO;
import com.sapphireims.itsm.dto.UipRecordDTO;
import com.sapphireims.itsm.model.SdUipMaster;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import jakarta.persistence.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Repository;

@Repository
public class SdUipMasterDAO
extends GenericHibernateRepository<SdUipMaster, Integer>
implements ISdUipMasterDAO {
    @Override
    public List<SdUipMaster> getSdUipMasterByProjectId(Integer projectId) {
        String query = " from SdUipMaster where projectId = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdUipMaster.class);
    }

    @Override
    public SdUipMaster getSdUipMasterByName(String uipName, Integer projectId) {
        String query = " from SdUipMaster where projectId = :projectId and name=:uipName ";
        String[] paramNames = new String[]{"projectId", "uipName"};
        Object[] values = new Object[]{projectId, uipName};
        return (SdUipMaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdUipMaster.class));
    }

    @Override
    public List<SdUipMaster> getSdUipMasterByProjectIdType(Integer projectId, Integer type, Integer pageNo, Integer pageSize) {
        String query = " from SdUipMaster where projectId = :projectId and type = :type";
        String[] paramNames = new String[]{"projectId", "type"};
        Object[] values = new Object[]{projectId, type};
        return this.genericHibernateDaoOperations.findByNamedParamAndPagesize(query, paramNames, values, pageNo, pageSize, SdDTOEnum.UIP_MASTER);
    }

    @Override
    public SdUipMaster getSdUipMasterById(int uipId, Integer projectId) {
        String query = " from SdUipMaster where projectId = :projectId and id=:uipId ";
        String[] paramNames = new String[]{"projectId", "uipId"};
        Object[] values = new Object[]{projectId, uipId};
        return (SdUipMaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdUipMaster.class));
    }

    @Override
    public int saveSdUIPName(SdUipMasterDTO sdUipMasterDTO, int projectId) {
        SdUipMaster sdUipMaster = new SdUipMaster();
        sdUipMaster.setName(sdUipMasterDTO.getName());
        sdUipMaster.setType(sdUipMasterDTO.getType());
        sdUipMaster.setDescription(sdUipMasterDTO.getDescription());
        sdUipMaster.setProjectId(sdUipMasterDTO.getProjectId());
        this.hibernateDaoOperations.save((Object)sdUipMaster);
        return sdUipMaster.getId();
    }

    @Override
    public void updateSdUIPName(SdUipMasterDTO sdUipMasterDTO, int projectId) {
        SdUipMaster sdUipMaster = (SdUipMaster)((Object)this.hibernateDaoOperations.get(SdUipMaster.class, (Serializable)sdUipMasterDTO.getId()));
        sdUipMaster.setName(sdUipMasterDTO.getName());
        this.hibernateDaoOperations.saveOrUpdate((Object)sdUipMaster);
    }

    @Override
    public void saveUIPDescription(int uipId, String description) {
        SdUipMaster sdUipMaster = (SdUipMaster)((Object)this.hibernateDaoOperations.get(SdUipMaster.class, (Serializable)Integer.valueOf(uipId)));
        sdUipMaster.setDescription(description);
        this.hibernateDaoOperations.saveOrUpdate((Object)sdUipMaster);
    }

    @Override
    public void deleteSdUIPmaster(int uipId) {
        this.hibernateDaoOperations.delete(this.hibernateDaoOperations.get(SdUipMaster.class, (Serializable)Integer.valueOf(uipId)));
    }

    @Override
    public Integer checkDuplicateUIPName(String uipName, Integer projectId, Integer type, Integer id) {
        Integer isDuplicate = 0;
        String query = "SELECT name FROM SdUipMaster WHERE name=:uipName and projectId=:projectId and status=0 and type=:type and id <> :id";
        String[] paramNames = new String[]{"uipName", "projectId", "type", "id"};
        Object[] values = new Object[]{uipName, projectId, type, id};
        List nameList = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, String.class);
        if (nameList != null && nameList.size() > 0) {
            isDuplicate = 1;
        }
        return isDuplicate;
    }

    @Override
    public List<SdUipMaster> getUIPbyServiceId(int type, int serviceId, Integer projectId) {
        String query = "select sm from SdUipMaster sm, SdUipDetails sd where sm.id=sd.sdUipMaster.id AND sm.status=0 AND sm.type= :type AND sd.parameterId=1 AND sd.parameterValue= :serviceId AND sm.projectId= :projectId ORDER BY sd.sdUipMaster.id";
        String[] paramNames = new String[]{"type", "serviceId", "projectId"};
        Object[] values = new Object[]{type, serviceId, projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdUipMaster.class);
    }

    @Override
    public SdUipMaster getSdUipMasterByIdandType(int id, Integer type) {
        String query = " from SdUipMaster where id = :id and type=:type ";
        String[] paramNames = new String[]{"id", "type"};
        Object[] values = new Object[]{id, type};
        return (SdUipMaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdUipMaster.class));
    }

    @Override
    public List<UipRecordDTO> getUipRecordsSorted(int projectId, int type, int pageNo, int pageSize, String columnSort, String sortDirection) {
        Session session = this.hibernateDaoOperations.getSessionFactory().getCurrentSession();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT m.id AS uipId, ").append("m.name AS uipName, ").append("m.description, ").append("GROUP_CONCAT(DISTINCT s.servicename ORDER BY s.servicename SEPARATOR ', ') AS serviceNames ").append("FROM sd_uip_master m ").append("LEFT JOIN sd_uip_details d ON m.id = d.id ").append("LEFT JOIN sd_service s ON d.parametervalue = s.serviceid ").append("WHERE m.projectid = :projectId AND m.type = :type ").append("GROUP BY m.id, m.name, m.description ");
        sql.append("ORDER BY " + columnSort + " " + sortDirection + " ");
        if (pageSize > 0) {
            sql.append("LIMIT :limit OFFSET :offset");
        }
        NativeQuery query = session.createNativeQuery(sql.toString(), Tuple.class);
        query.setParameter("projectId", (Object)projectId);
        query.setParameter("type", (Object)type);
        if (pageSize > 0) {
            query.setParameter("limit", (Object)pageSize);
            query.setParameter("offset", (Object)((pageNo - 1) * pageSize));
        }
        ArrayList<UipRecordDTO> result = new ArrayList<UipRecordDTO>();
        for (Tuple tuple : query.getResultList()) {
            result.add(new UipRecordDTO(((Number)tuple.get("uipId")).intValue(), (String)tuple.get("uipName", String.class), (String)tuple.get("description", String.class), (String)tuple.get("serviceNames", String.class)));
        }
        return result;
    }
}

