/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.itsm.dao.ISdCategorymasterDAO;
import com.sapphireims.itsm.dao.ISdWorkFlowMasterDAO;
import com.sapphireims.itsm.dto.SdWorkFlowBuilderDTO;
import com.sapphireims.itsm.dto.SdWorkFlowMasterDTO;
import com.sapphireims.itsm.dto.SdWorkflowFilterDTO;
import com.sapphireims.itsm.dto.SdWorkflowStatesDTO;
import com.sapphireims.itsm.mindto.CategoryMinDTO;
import com.sapphireims.itsm.mindto.DerivedFieldMinDTO;
import com.sapphireims.itsm.mindto.ProjectRolesMinDTO;
import com.sapphireims.itsm.mindto.ServiceMinDTO;
import com.sapphireims.itsm.mindto.SubCategoryMinDTO;
import com.sapphireims.itsm.model.SdWorkFlowDetail;
import com.sapphireims.itsm.model.SdWorkFlowMaster;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import jakarta.persistence.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.query.MutationQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SdWorkFlowMasterDAO
extends GenericHibernateRepository<SdWorkFlowMaster, Integer>
implements ISdWorkFlowMasterDAO {
    @Autowired
    private ISdCategorymasterDAO sdCategorymasterDAO;

    @Override
    public List<SdWorkFlowMaster> getSdWorkFlowMasterByProjectId(Integer projectId) {
        String query = " from SdWorkFlowMaster where sdProjectMaster.projectId = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdWorkFlowMaster.class);
    }

    @Override
    public void batchSaveSdWorkFlowDetailWithoutFlush(Set<SdWorkFlowDetail> sdWorkFlowDetails) {
        for (SdWorkFlowDetail sd : sdWorkFlowDetails) {
            this.hibernateDaoOperations.save((Object)sd);
        }
    }

    @Override
    public List<SdWorkflowStatesDTO> getLeftStateForWorkFlow(Integer projectId) {
        String query = "select distinct pState from SdWorkFlowMaster where sdProjectMaster.projectId=:projectId";
        String paramName = "projectId";
        Integer value = projectId;
        List pstateList = this.hibernateDaoOperations.findByNamedParam(query, paramName, (Object)value, Integer.class);
        String query2 = "select distinct aState from SdWorkFlowMaster where sdProjectMaster.projectId=:projectId";
        List astateList = this.hibernateDaoOperations.findByNamedParam(query2, paramName, (Object)value, Integer.class);
        if (pstateList.size() == 0) {
            pstateList.add(0);
        }
        if (astateList.size() == 0) {
            astateList.add(0);
        }
        String query3 = "Select distinct ss.stateId AS stateId,ss.stateName AS stateName,ss.color AS color,(case when ss.isstartstate=1||ss.isendstate=1 then 'circle' when sf.input='App ID' || sf.input='Multi App ID' then 'diamond' else  'ellipse' end) AS shape from sd_statesmaster ss, sd_states_fixedfields sf where ss.stateId=sf.stateId and ss.stateId not in(:pstateList) and ss.stateId not in(:astateList) and ss.status=0 and ss.projectid=:projectid group by ss.stateId";
        String[] paramNames = new String[]{"pstateList", "astateList", "projectid"};
        Object[] values = new Object[]{pstateList, astateList, projectId};
        ArrayList<SdWorkflowStatesDTO> sdWorkflowStatesList = new ArrayList<SdWorkflowStatesDTO>();
        List statesList = this.hibernateDaoOperations.findByNamedParamSql(query3, paramNames, values, Tuple.class);
        for (Tuple tuple : statesList) {
            SdWorkflowStatesDTO sdWorkflowStatesDto = new SdWorkflowStatesDTO((Integer)tuple.get("stateId", Integer.class), (String)tuple.get("stateName", String.class), (String)tuple.get("color", String.class), (String)tuple.get("shape", String.class));
            this.setRuleInfo(sdWorkflowStatesDto);
            sdWorkflowStatesList.add(sdWorkflowStatesDto);
        }
        return sdWorkflowStatesList;
    }

    private SdWorkflowStatesDTO setRuleInfo(SdWorkflowStatesDTO sdWorkflowStatesDto) {
        String smsQuery;
        Long smsCount;
        Object[] emailValue;
        String[] emailParam;
        String emailQuery;
        Long emailcount;
        long isRuleConfigued = 0L;
        Object ruleInfo = "";
        String cbrQuery = "Select count(sp.id) from SdPrePostActions sp,SdPrePostActionsDetails spd where sp.id=spd.sdPrePostActions.id and spd.categoryId=3 and spd.categoryValue=:stateId";
        String[] cbrParam = new String[]{"stateId"};
        Object[] cbrValue = new Object[]{String.valueOf(sdWorkflowStatesDto.getStateId())};
        Long count = (Long)this.hibernateDaoOperations.findByNamedParamUniqueResult(cbrQuery, cbrParam, cbrValue, Long.class);
        if (count > 0L) {
            ++isRuleConfigued;
            ruleInfo = " [CBR";
        }
        if ((emailcount = (Long)this.hibernateDaoOperations.findByNamedParamUniqueResult(emailQuery = "Select count(notificationId) from SdNotificationMaster where forState=:stateId", emailParam = new String[]{"stateId"}, emailValue = new Object[]{sdWorkflowStatesDto.getStateId()}, Long.class)) > 0L) {
            ++isRuleConfigued;
            ruleInfo = ((String)ruleInfo).equals("") ? " [Email" : (String)ruleInfo + ",Email";
        }
        if ((smsCount = (Long)this.hibernateDaoOperations.findByNamedParamUniqueResult(smsQuery = "Select count(smsNotificationId) from SdSmsNotificationMaster where forState=:stateId", emailParam, emailValue, Long.class)) > 0L) {
            ++isRuleConfigued;
            ruleInfo = ((String)ruleInfo).equals("") ? " [SMS" : (String)ruleInfo + ",SMS";
        }
        if (!((String)ruleInfo).equals("")) {
            ruleInfo = (String)ruleInfo + "]";
        }
        sdWorkflowStatesDto.setIsRuleConfigured(isRuleConfigued);
        sdWorkflowStatesDto.setRuleInfo((String)ruleInfo);
        return sdWorkflowStatesDto;
    }

    @Override
    public List<SdWorkFlowBuilderDTO> getSdWorkFlowBuilderNodes(Integer projectId) {
        String query = "select distinct pState from SdWorkFlowMaster where sdProjectMaster.projectId=:projectId";
        String paramName = "projectId";
        Integer value = projectId;
        List pstateList = this.hibernateDaoOperations.findByNamedParam(query, paramName, (Object)value, Integer.class);
        String query2 = "select distinct aState from SdWorkFlowMaster where sdProjectMaster.projectId=:projectId";
        List astateList = this.hibernateDaoOperations.findByNamedParam(query2, paramName, (Object)value, Integer.class);
        if (pstateList.isEmpty()) {
            pstateList.add(0);
        }
        if (astateList.isEmpty()) {
            astateList.add(0);
        }
        String query3 = "Select distinct ss.stateId AS nodeId, ss.stateName AS nodeLabel, ss.color AS nodeColor,(case when ss.isstartstate=1||ss.isendstate=1 then 'circle' when sf.input='App ID' || sf.input='Multi App ID' then 'diamond' else  'ellipse' end) AS nodeShape from sd_statesmaster ss, sd_states_fixedfields sf  where ss.stateId=sf.stateId and ss.status=0 and ss.projectId=:projectId and (ss.stateId in(:pstateList) or ss.stateId in(:astateList)) group by ss.stateId order by ss.stateId ";
        String[] paramNames = new String[]{"projectId", "pstateList", "astateList"};
        Object[] values = new Object[]{projectId, pstateList, astateList};
        List result = this.hibernateDaoOperations.findByNamedParamSql(query3, paramNames, values, Tuple.class);
        ArrayList<SdWorkFlowBuilderDTO> sdWorkFlowBuilderDtoList = new ArrayList<SdWorkFlowBuilderDTO>(result.size());
        for (Tuple tuple : result) {
            SdWorkFlowBuilderDTO sdWorkFlowBuilderDto = new SdWorkFlowBuilderDTO((Integer)tuple.get("nodeId", Integer.class), (String)tuple.get("nodeLabel", String.class), (String)tuple.get("nodeColor", String.class), (String)tuple.get("nodeShape", String.class));
            this.setRuleInfoForNode(sdWorkFlowBuilderDto);
            sdWorkFlowBuilderDtoList.add(sdWorkFlowBuilderDto);
        }
        return sdWorkFlowBuilderDtoList;
    }

    private SdWorkFlowBuilderDTO setRuleInfoForNode(SdWorkFlowBuilderDTO sdWorkflowStatesDto) {
        String smsQuery;
        Long smsCount;
        Object[] emailValue;
        String[] emailParam;
        String emailQuery;
        Long emailcount;
        long isRuleConfigued = 0L;
        Object ruleInfo = "";
        String cbrQuery = "Select count(sp.id) from SdPrePostActions sp,SdPrePostActionsDetails spd where sp.id=spd.sdPrePostActions.id and spd.categoryId=3 and spd.categoryValue=:stateId";
        String[] cbrParam = new String[]{"stateId"};
        Object[] cbrValue = new Object[]{String.valueOf(sdWorkflowStatesDto.getNodeId())};
        Long count = (Long)this.hibernateDaoOperations.findByNamedParamUniqueResult(cbrQuery, cbrParam, cbrValue, Long.class);
        if (count > 0L) {
            ++isRuleConfigued;
            ruleInfo = " [CBR";
        }
        if ((emailcount = (Long)this.hibernateDaoOperations.findByNamedParamUniqueResult(emailQuery = "Select count(notificationId) from SdNotificationMaster where forState=:stateId", emailParam = new String[]{"stateId"}, emailValue = new Object[]{sdWorkflowStatesDto.getNodeId()}, Long.class)) > 0L) {
            ++isRuleConfigued;
            ruleInfo = ((String)ruleInfo).equals("") ? " [Email" : (String)ruleInfo + ",Email";
        }
        if ((smsCount = (Long)this.hibernateDaoOperations.findByNamedParamUniqueResult(smsQuery = "Select count(smsNotificationId) from SdSmsNotificationMaster where forState=:stateId", emailParam, emailValue, Long.class)) > 0L) {
            ++isRuleConfigued;
            ruleInfo = ((String)ruleInfo).equals("") ? " [SMS" : (String)ruleInfo + ",SMS";
        }
        if (!((String)ruleInfo).equals("")) {
            ruleInfo = (String)ruleInfo + "]";
        }
        sdWorkflowStatesDto.setIsRuleConfigured(isRuleConfigued);
        sdWorkflowStatesDto.setRuleInfo((String)ruleInfo);
        return sdWorkflowStatesDto;
    }

    @Override
    public List<SdWorkFlowBuilderDTO> getSdWorkFlowBuilderEdges(Integer projectId) {
        String query = "Select pState AS fromNode,aState AS toNode,color AS edgeColor,stateMovementID AS edgeId  from SdWorkFlowMaster where sdProjectMaster.projectId=:projectId";
        String[] paramName = new String[]{"projectId"};
        Object[] value = new Object[]{projectId};
        return this.genericHibernateDaoOperations.findByNamedParam(query, paramName, value, SdDTOEnum.SD_WORKFLOW_BUILDER_DTO);
    }

    private void setFilterQuery(List<Integer> serviceList, List<Integer> subcatList, List<Integer> d1List, List<Integer> d2List, List<Integer> d3List, List<Integer> roleList, Integer projectId, StringBuilder fromBuilder, StringBuilder whereBuilder, List<String> paramList, List<Object> valuesList) {
        paramList.add("projectId");
        valuesList.add(projectId);
        if (serviceList != null && serviceList.size() > 0) {
            whereBuilder.append(" and sw.stateMovementID=sd.sdWorkFlowMaster.stateMovementID and sd.workflowCategoryId=1 and sd.workflowCategoryValue IN(:serviceList)");
            fromBuilder.append(",SdWorkFlowDetail sd");
            paramList.add("serviceList");
            valuesList.add(serviceList);
        }
        if (subcatList != null && subcatList.size() > 0 && !subcatList.contains(0)) {
            whereBuilder.append(" and sw.stateMovementID=sd2.sdWorkFlowMaster.stateMovementID and sd2.workflowCategoryId=2 and (sd2.workflowCategoryValue IN(:subcatList) OR sd2.workflowCategoryValue IN(0))");
            fromBuilder.append(",SdWorkFlowDetail sd2");
            paramList.add("subcatList");
            valuesList.add(subcatList);
        }
        if (d1List != null && d1List.size() > 0 && !d1List.contains(0)) {
            whereBuilder.append(" and sw.stateMovementID=sd3.sdWorkFlowMaster.stateMovementID and sd3.workflowCategoryId=4 and (sd3.workflowCategoryValue IN(:d1List) OR sd3.workflowCategoryValue IN(0))");
            fromBuilder.append(",SdWorkFlowDetail sd3");
            paramList.add("d1List");
            valuesList.add(d1List);
        }
        if (d2List != null && d2List.size() > 0 && !d2List.contains(0)) {
            whereBuilder.append(" and sw.stateMovementID=sd4.sdWorkFlowMaster.stateMovementID and sd4.workflowCategoryId=5 and (sd4.workflowCategoryValue IN(:d2List) OR sd4.workflowCategoryValue IN(0))");
            fromBuilder.append(",SdWorkFlowDetail sd4");
            paramList.add("d2List");
            valuesList.add(d2List);
        }
        if (d3List != null && d3List.size() > 0 && !d3List.contains(0)) {
            d3List.add(0);
            whereBuilder.append(" and sw.stateMovementID=sd5.sdWorkFlowMaster.stateMovementID and sd5.workflowCategoryId=6 and (sd5.workflowCategoryValue IN(:d3List) OR sd5.workflowCategoryValue IN(0))");
            fromBuilder.append(",SdWorkFlowDetail sd5");
            paramList.add("d3List");
            valuesList.add(d3List);
        }
        if (roleList.size() > 0) {
            whereBuilder.append(" and sw.stateMovementID=sd1.sdWorkFlowMaster.stateMovementID and sd1.workflowCategoryId=3 and sd1.workflowCategoryValue IN(:roleList)");
            fromBuilder.append(",SdWorkFlowDetail sd1");
            paramList.add("roleList");
            valuesList.add(roleList);
        }
        fromBuilder.append(" where sw.sdProjectMaster.projectId=:projectId").append((CharSequence)whereBuilder);
    }

    @Override
    public List<SdWorkflowStatesDTO> getLeftStateForWorkFlowByServiceParams(List<Integer> serviceList, List<Integer> subcatList, List<Integer> d1List, List<Integer> d2List, List<Integer> d3List, List<Integer> roleList, Integer projectId) {
        StringBuilder fromBuilder = new StringBuilder();
        StringBuilder whereBuilder = new StringBuilder();
        fromBuilder.append("select distinct sw.pState from SdWorkFlowMaster sw ");
        ArrayList<String> paramList = new ArrayList<String>();
        ArrayList<Object> valuesList = new ArrayList<Object>();
        this.setFilterQuery(serviceList, subcatList, d1List, d2List, d3List, roleList, projectId, fromBuilder, whereBuilder, paramList, valuesList);
        String[] paramNames = new String[paramList.size()];
        paramNames = paramList.toArray(paramNames);
        Object[] values = new Object[valuesList.size()];
        values = valuesList.toArray(values);
        List pstateList = this.hibernateDaoOperations.findByNamedParam(fromBuilder.toString(), paramNames, values, Integer.class);
        String aStateQuery = fromBuilder.toString().replace("sw.pState", "sw.aState");
        List astateList = this.hibernateDaoOperations.findByNamedParam(aStateQuery, paramNames, values, Integer.class);
        if (pstateList.size() == 0) {
            pstateList.add(0);
        }
        if (astateList.size() == 0) {
            astateList.add(0);
        }
        String query = "Select distinct ss.stateId AS stateId,ss.stateName AS stateName,ss.color AS color,(case when ss.isstartstate=1||ss.isendstate=1 then 'circle' when sf.input='App ID' || sf.input='Multi App ID' then 'diamond' else  'ellipse' end) AS shape from sd_statesmaster ss, sd_states_fixedfields sf where ss.stateId=sf.stateId and ss.stateId not in(:pstateList) and ss.stateId not in(:astateList) and ss.status=0 and ss.projectid=:projectid group by ss.stateId";
        String[] paramName = new String[]{"pstateList", "astateList", "projectid"};
        Object[] value = new Object[]{pstateList, astateList, projectId};
        List statesList = this.hibernateDaoOperations.findByNamedParamSql(query, paramName, value, Tuple.class);
        ArrayList<SdWorkflowStatesDTO> sdWorkflowStatesList = new ArrayList<SdWorkflowStatesDTO>();
        for (Tuple tuple : statesList) {
            SdWorkflowStatesDTO sdWorkflowStatesDto = new SdWorkflowStatesDTO((Integer)tuple.get("stateId", Integer.class), (String)tuple.get("stateName", String.class), (String)tuple.get("color", String.class), (String)tuple.get("shape", String.class));
            this.setRuleInfo(sdWorkflowStatesDto);
            sdWorkflowStatesList.add(sdWorkflowStatesDto);
        }
        return sdWorkflowStatesList;
    }

    @Override
    public List<SdWorkFlowBuilderDTO> getWorkFlowBuilderNodesByServiceParams(List<Integer> serviceList, List<Integer> subcatList, List<Integer> d1List, List<Integer> d2List, List<Integer> d3List, List<Integer> roleList, Integer projectId) {
        StringBuilder fromBuilder = new StringBuilder();
        StringBuilder whereBuilder = new StringBuilder();
        fromBuilder.append("select distinct sw.pState from SdWorkFlowMaster sw ");
        ArrayList<String> paramList = new ArrayList<String>();
        ArrayList<Object> valuesList = new ArrayList<Object>();
        this.setFilterQuery(serviceList, subcatList, d1List, d2List, d3List, roleList, projectId, fromBuilder, whereBuilder, paramList, valuesList);
        String[] paramNames = new String[paramList.size()];
        paramNames = paramList.toArray(paramNames);
        Object[] values = new Object[valuesList.size()];
        values = valuesList.toArray(values);
        List pstateList = this.hibernateDaoOperations.findByNamedParam(fromBuilder.toString(), paramNames, values, Integer.class);
        String aStateQuery = fromBuilder.toString().replace("sw.pState", "sw.aState");
        List astateList = this.hibernateDaoOperations.findByNamedParam(aStateQuery, paramNames, values, Integer.class);
        if (pstateList.size() == 0) {
            pstateList.add(0);
        }
        if (astateList.size() == 0) {
            astateList.add(0);
        }
        String query = "Select distinct ss.stateId AS nodeId, ss.stateName AS nodeLabel, ss.color AS nodeColor,(case when ss.isstartstate=1||ss.isendstate=1 then 'circle' when sf.input='App ID' || sf.input='Multi App ID' then 'diamond' else  'ellipse' end) AS nodeShape from sd_statesmaster ss, sd_states_fixedfields sf  where ss.stateId=sf.stateId and ss.status=0 and ss.projectId=:projectId and (ss.stateId in(:pstateList) or ss.stateId in(:astateList)) group by ss.stateId order by ss.stateId ";
        String[] paramName = new String[]{"projectId", "pstateList", "astateList"};
        Object[] value = new Object[]{projectId, pstateList, astateList};
        List stateList = this.hibernateDaoOperations.findByNamedParamSql(query, paramName, value, Tuple.class);
        ArrayList<SdWorkFlowBuilderDTO> sdWorkFlowBuilderDtoList = new ArrayList<SdWorkFlowBuilderDTO>();
        for (Tuple tuple : stateList) {
            SdWorkFlowBuilderDTO sdWorkFlowBuilderDto = new SdWorkFlowBuilderDTO((Integer)tuple.get("nodeId", Integer.class), (String)tuple.get("nodeLabel", String.class), (String)tuple.get("nodeColor", String.class), (String)tuple.get("nodeShape", String.class));
            this.setRuleInfoForNode(sdWorkFlowBuilderDto);
            sdWorkFlowBuilderDtoList.add(sdWorkFlowBuilderDto);
        }
        return sdWorkFlowBuilderDtoList;
    }

    @Override
    public List<SdWorkFlowBuilderDTO> getSdWorkFlowBuilderEdgesByServiceParams(List<Integer> serviceList, List<Integer> subcatList, List<Integer> d1List, List<Integer> d2List, List<Integer> d3List, List<Integer> roleList, Integer projectId) {
        StringBuilder fromBuilder = new StringBuilder();
        StringBuilder whereBuilder = new StringBuilder();
        fromBuilder.append("Select distinct sw.stateMovementID AS edgeId,sw.pState AS fromNode,sw.aState AS toNode,sw.color AS edgeColor from Sd_WorkFlowMaster sw ");
        ArrayList<String> paramList = new ArrayList<String>();
        ArrayList<Object> valuesList = new ArrayList<Object>();
        paramList.add("projectId");
        valuesList.add(projectId);
        if (serviceList != null && serviceList.size() > 0) {
            whereBuilder.append(" and sw.stateMovementID=sd.stateMovementID and sd.workflow_CategoryId=1 and sd.workflow_Category_Value IN(:serviceList)");
            fromBuilder.append(",Sd_WorkFlowDetail sd");
            paramList.add("serviceList");
            valuesList.add(serviceList);
        }
        if (subcatList != null && subcatList.size() > 0 && !subcatList.contains(0)) {
            whereBuilder.append(" and sw.stateMovementID=sd2.stateMovementID and sd2.workflow_CategoryId=2 and (sd2.workflow_Category_Value IN(:subcatList) OR sd2.workflow_Category_Value IN(0))");
            fromBuilder.append(",Sd_WorkFlowDetail sd2");
            paramList.add("subcatList");
            valuesList.add(subcatList);
        }
        if (d1List != null && d1List.size() > 0 && !d1List.contains(0)) {
            whereBuilder.append(" and sw.stateMovementID=sd3.stateMovementID and sd3.workflow_CategoryId=4 and (sd3.workflow_Category_Value IN(:d1List) OR sd3.workflow_Category_Value IN(0))");
            fromBuilder.append(",Sd_WorkFlowDetail sd3");
            paramList.add("d1List");
            valuesList.add(d1List);
        }
        if (d2List != null && d2List.size() > 0 && !d2List.contains(0)) {
            whereBuilder.append(" and sw.stateMovementID=sd4.stateMovementID and sd4.workflow_CategoryId=5 and (sd4.workflow_Category_Value IN(:d2List) OR sd4.workflow_Category_Value IN(0))");
            fromBuilder.append(",Sd_WorkFlowDetail sd4");
            paramList.add("d2List");
            valuesList.add(d2List);
        }
        if (d3List != null && d3List.size() > 0 && !d3List.contains(0)) {
            whereBuilder.append(" and sw.stateMovementID=sd5.stateMovementID and sd5.workflow_CategoryId=6 and (sd5.workflow_Category_Value IN(:d3List) OR sd5.workflow_Category_Value IN(0))");
            fromBuilder.append(",Sd_WorkFlowDetail sd5");
            paramList.add("d3List");
            valuesList.add(d3List);
        }
        if (roleList.size() > 0) {
            whereBuilder.append(" and sw.stateMovementID=sd1.stateMovementID and sd1.WORKFLOW_CATEGORYID=3 and sd1.WORKFLOW_CATEGORY_VALUE IN(:roleList)");
            fromBuilder.append(",Sd_WorkFlowDetail sd1");
            paramList.add("roleList");
            valuesList.add(roleList);
        }
        fromBuilder.append(" where sw.projectId=:projectId").append((CharSequence)whereBuilder);
        String[] paramNames = new String[paramList.size()];
        paramNames = paramList.toArray(paramNames);
        Object[] values = new Object[valuesList.size()];
        values = valuesList.toArray(values);
        ArrayList<SdWorkFlowBuilderDTO> dtoList = new ArrayList<SdWorkFlowBuilderDTO>();
        List tuples = this.hibernateDaoOperations.findByNamedParamSql(fromBuilder.toString(), paramNames, values, Tuple.class);
        for (Tuple tuple : tuples) {
            SdWorkFlowBuilderDTO sdWorkflowStatesDto = new SdWorkFlowBuilderDTO();
            sdWorkflowStatesDto.setEdgeId((Integer)tuple.get("edgeId", Integer.class));
            sdWorkflowStatesDto.setFromNode((Integer)tuple.get("fromNode", Integer.class));
            sdWorkflowStatesDto.setToNode((Integer)tuple.get("toNode", Integer.class));
            sdWorkflowStatesDto.setEdgeColor((String)tuple.get("edgeColor", String.class));
            dtoList.add(sdWorkflowStatesDto);
        }
        return dtoList;
    }

    @Override
    public Integer checkIsDuplicateWorkflow(Integer pstate, Integer astate) {
        int isDuplicate = 0;
        String query = "select stateMovementID from SdWorkFlowMaster where pState=:pState and aState=:aState";
        String[] paramNames = new String[]{"pState", "aState"};
        Object[] values = new Object[]{pstate, astate};
        Integer isduplicate = (Integer)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, Integer.class);
        if (isduplicate != null) {
            isDuplicate = isduplicate;
        }
        return isDuplicate;
    }

    @Override
    public void deleteSdWorkFlowMasterService(Integer stateMovementId) {
        String query = "delete from SdWorkFlowMaster where stateMovementID=:stateMovementID";
        MutationQuery queryString = this.hibernateDaoOperations.getSessionFactory().getCurrentSession().createMutationQuery(query);
        queryString.setParameter("stateMovementID", (Object)stateMovementId);
        queryString.executeUpdate();
    }

    @Override
    public SdWorkflowFilterDTO getAddWorkflowFieldsData(String services, String subcats, String d1, String d2, String d3, String roles) {
        SdWorkflowFilterDTO sdWorkflowFilterDto = new SdWorkflowFilterDTO();
        ArrayList<ServiceMinDTO> serviceList = new ArrayList();
        ArrayList<CategoryMinDTO> subcatList = new ArrayList<CategoryMinDTO>();
        List<DerivedFieldMinDTO> d1List = new ArrayList<DerivedFieldMinDTO>();
        List<DerivedFieldMinDTO> d2List = new ArrayList<DerivedFieldMinDTO>();
        List<DerivedFieldMinDTO> d3List = new ArrayList<DerivedFieldMinDTO>();
        ArrayList<ProjectRolesMinDTO> roleList = new ArrayList();
        ArrayList<Integer> nserviceList = new ArrayList<Integer>();
        for (String service : services.split(",")) {
            nserviceList.add(Integer.parseInt(service));
        }
        String serviceQuery = "Select serviceId AS serviceId,serviceName AS serviceName from SdService where serviceId IN(:serviceList)";
        String[] paramNames = new String[]{"serviceList"};
        Object[] values = new Object[]{nserviceList};
        serviceList = this.genericHibernateDaoOperations.findByNamedParam(serviceQuery, paramNames, values, SdDTOEnum.SERVICE_MIN_DTO);
        sdWorkflowFilterDto.setServiceList(serviceList);
        ArrayList<Integer> nsubcatList = new ArrayList<Integer>();
        int subCatAllCount = 0;
        for (String sucat : subcats.split(",")) {
            if (sucat.equals("0")) {
                if (subCatAllCount == 0) {
                    CategoryMinDTO catMinDto = new CategoryMinDTO();
                    ArrayList<SubCategoryMinDTO> subcatMinDtoList = new ArrayList<SubCategoryMinDTO>();
                    SubCategoryMinDTO subCategoryMinDto = new SubCategoryMinDTO();
                    subCategoryMinDto.setSubcategoryId(0);
                    subCategoryMinDto.setSubcategoryName("All");
                    subcatMinDtoList.add(subCategoryMinDto);
                    catMinDto.setSubcategoryList(subcatMinDtoList);
                    subcatList.add(catMinDto);
                    sdWorkflowFilterDto.setSubcatList(subcatList);
                }
                ++subCatAllCount;
                continue;
            }
            nsubcatList.add(Integer.parseInt(sucat));
        }
        if (nsubcatList.size() > 0) {
            List<CategoryMinDTO> categoryList = this.sdCategorymasterDAO.getCategoryListBySubcategory(nsubcatList);
            for (CategoryMinDTO category : categoryList) {
                CategoryMinDTO catMinDto = new CategoryMinDTO();
                String subcatQuery = "Select subCategoryId AS subcategoryId,subCategoryName AS subcategoryName from SdSubcategorymaster where sdCategorymaster.categoryId IN(:categoryId) and subCategoryId IN(:nsubcatList)";
                String[] paramName = new String[]{"categoryId", "nsubcatList"};
                Object[] value = new Object[]{category.getCategoryId(), nsubcatList};
                List subcatMinList = this.genericHibernateDaoOperations.findByNamedParam(subcatQuery, paramName, value, SdDTOEnum.SUBCATEGORY_MIN_DTO);
                catMinDto.setCategoryId(category.getCategoryId());
                catMinDto.setCategoryName(category.getCategoryName());
                catMinDto.setSubcategoryList(subcatMinList);
                subcatList.add(catMinDto);
            }
            sdWorkflowFilterDto.setSubcatList(subcatList);
        }
        ArrayList<Integer> nd1List = new ArrayList<Integer>();
        int d1AllCount = 0;
        for (String der1 : d1.split(",")) {
            if (der1.equals("0")) {
                if (d1AllCount == 0) {
                    DerivedFieldMinDTO derivedFieldMinDto = new DerivedFieldMinDTO();
                    derivedFieldMinDto.setDerivedFieldId(0);
                    derivedFieldMinDto.setDerivedFieldName("All");
                    d1List.add(derivedFieldMinDto);
                    sdWorkflowFilterDto.setD1List(d1List);
                }
                ++d1AllCount;
                continue;
            }
            nd1List.add(Integer.parseInt(der1));
        }
        if (nd1List.size() > 0) {
            String d1Query = "Select dependentFieldId AS derivedFieldId,dependentFieldName AS derivedFieldName from SdDependentMaster where dependentFieldId IN(:d1List)";
            String[] paramName = new String[]{"d1List"};
            Object[] value = new Object[]{nd1List};
            d1List = this.genericHibernateDaoOperations.findByNamedParam(d1Query, paramName, value, SdDTOEnum.DERIVED_FIELD_MIN_DTO);
            sdWorkflowFilterDto.setD1List(d1List);
        }
        ArrayList<Integer> nd2List = new ArrayList<Integer>();
        int d2AllCount = 0;
        for (String der2 : d2.split(",")) {
            if (der2.equals("0")) {
                if (d2AllCount == 0) {
                    DerivedFieldMinDTO derivedFieldMinDto = new DerivedFieldMinDTO();
                    derivedFieldMinDto.setDerivedFieldId(0);
                    derivedFieldMinDto.setDerivedFieldName("All");
                    d2List.add(derivedFieldMinDto);
                    sdWorkflowFilterDto.setD2List(d2List);
                }
                ++d2AllCount;
                continue;
            }
            nd2List.add(Integer.parseInt(der2));
        }
        if (nd2List.size() > 0) {
            String d2Query = "Select dependentFieldId AS derivedFieldId,dependentFieldName AS derivedFieldName from SdDependentMaster where dependentFieldId IN(:d2List)";
            String[] paramName = new String[]{"d2List"};
            Object[] value = new Object[]{nd2List};
            d2List = this.genericHibernateDaoOperations.findByNamedParam(d2Query, paramName, value, SdDTOEnum.DERIVED_FIELD_MIN_DTO);
            sdWorkflowFilterDto.setD2List(d2List);
        }
        ArrayList<Integer> nd3List = new ArrayList<Integer>();
        int d3AllCount = 0;
        for (String der3 : d3.split(",")) {
            if (der3.equals("0")) {
                if (d3AllCount == 0) {
                    DerivedFieldMinDTO derivedFieldMinDto = new DerivedFieldMinDTO();
                    derivedFieldMinDto.setDerivedFieldId(0);
                    derivedFieldMinDto.setDerivedFieldName("All");
                    d3List.add(derivedFieldMinDto);
                    sdWorkflowFilterDto.setD3List(d3List);
                }
                ++d3AllCount;
                continue;
            }
            nd3List.add(Integer.parseInt(der3));
        }
        if (nd3List.size() > 0) {
            String d3Query = "Select dependentFieldId AS derivedFieldId,dependentFieldName AS derivedFieldName from SdDependentMaster where dependentFieldId IN(:d3List)";
            String[] paramName = new String[]{"d3List"};
            Object[] value = new Object[]{nd3List};
            d3List = this.genericHibernateDaoOperations.findByNamedParam(d3Query, paramName, value, SdDTOEnum.DERIVED_FIELD_MIN_DTO);
            sdWorkflowFilterDto.setD3List(d3List);
        }
        ArrayList<Integer> nRoleList = new ArrayList<Integer>();
        for (String role : roles.split(",")) {
            nRoleList.add(Integer.parseInt(role));
        }
        String roleQuery = "Select projectRoleId AS projectRoleId,roleDisplayName AS roleDisplayName from SdProjectRoles where projectRoleId IN(:projectRoleId)";
        String[] paramName = new String[]{"projectRoleId"};
        Object[] value = new Object[]{nRoleList};
        roleList = this.genericHibernateDaoOperations.findByNamedParam(roleQuery, paramName, value, SdDTOEnum.PROJECT_ROLE_MIN_DTO);
        sdWorkflowFilterDto.setRoleList(roleList);
        return sdWorkflowFilterDto;
    }

    @Override
    public SdWorkFlowMasterDTO getWorkFlowMasterValues(Integer stateMovementId, SdWorkFlowMasterDTO workflowMasterDto) {
        String query = "Select pState, aState, sdProjectMaster.projectId from SdWorkFlowMaster where stateMovementID=:stateMovementId";
        String paramName = "stateMovementId";
        Integer value = stateMovementId;
        List list = this.hibernateDaoOperations.findByNamedParam(query, paramName, (Object)value, Object[].class);
        for (Object[] detail : list) {
            workflowMasterDto.setpState(Integer.parseInt(detail[0].toString()));
            workflowMasterDto.setaState(Integer.parseInt(detail[1].toString()));
            workflowMasterDto.setProjectId(Integer.parseInt(detail[2].toString()));
        }
        return workflowMasterDto;
    }

    @Override
    public String getSubCategoryNameForID(Integer subCategoryId) {
        String sbName = "";
        String query = "select subCategoryName from SdSubcategorymaster where subCategoryId=:subcategoryId";
        String[] paramNames = new String[]{"subcategoryId"};
        Object[] values = new Object[]{subCategoryId};
        String subCatName = (String)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, String.class);
        if (subCatName != null) {
            sbName = subCatName;
        }
        return sbName;
    }

    @Override
    public List<SdWorkFlowMaster> getSdWorkFlowMasterByProjectId(Integer projectId, Integer pageNo, Integer pageSize) {
        String query = " from SdWorkFlowMaster where sdProjectMaster.projectId = :projectId";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.genericHibernateDaoOperations.findByNamedParamAndPagesize(query, paramNames, values, pageNo, pageSize, SdDTOEnum.SD_WORKFLOW_MASTER);
    }

    @Override
    public SdWorkFlowMaster getSdWorkflowMasterByWorkflowID(Integer stateMovementId) {
        String query = " from SdWorkFlowMaster where stateMovementID=:stateMovementId ";
        String[] paramNames = new String[]{"stateMovementId"};
        Object[] values = new Object[]{stateMovementId};
        return (SdWorkFlowMaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdWorkFlowMaster.class));
    }

    @Override
    public void saveSdWorkflowdetails(SdWorkFlowDetail sWorkFlowDetail) {
        this.hibernateDaoOperations.saveOrUpdate((Object)sWorkFlowDetail);
    }

    @Override
    public Integer updatWorkflowAstatePState(Integer newPstate, Integer newAstate, Integer oldPstate, Integer oldAstate, Integer projectId) {
        String query = "Update SdWorkFlowMaster set pState=:newPstate, aState=:newAstate where pState=:oldPstate and aState=:oldAstate and sdProjectMaster.projectId = :projectId";
        String[] paramNames = new String[]{"newPstate", "newAstate", "oldPstate", "oldAstate", "projectId"};
        Object[] values = new Object[]{newPstate, newAstate, oldPstate, oldAstate, projectId};
        return this.hibernateDaoOperations.bulkUpdateOrDeleteByParam(query, paramNames, values);
    }

    @Override
    public SdWorkFlowMaster saveWorkflow(SdWorkFlowMasterDTO workflowMasterDto, Integer projectId) {
        SdProjectMaster sdProjectMaster = (SdProjectMaster)((Object)this.hibernateDaoOperations.get(SdProjectMaster.class, (Serializable)projectId));
        SdWorkFlowMaster workflowmaster = new SdWorkFlowMaster();
        workflowmaster.setpState(workflowMasterDto.getpState());
        workflowmaster.setaState(workflowMasterDto.getaState());
        workflowmaster.setSdProjectMaster(sdProjectMaster);
        workflowmaster.setScriptName("");
        workflowmaster.setScriptProperties("");
        this.hibernateDaoOperations.saveOrUpdate((Object)workflowmaster);
        return workflowmaster;
    }
}

