/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.dto.DataSource;
import com.sapphireims.itsm.dao.ISdWorkgroupMasterDAO;
import com.sapphireims.itsm.dto.SdWorkgroupMasterDTO;
import com.sapphireims.itsm.mindto.WorkGroupMinDTO;
import com.sapphireims.itsm.model.SdWorkgroupdetails;
import com.sapphireims.itsm.model.SdWorkgroupmaster;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import com.sapphireims.util.CollectionUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.MutationQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.stereotype.Repository;

@Repository
public class SdWorkgroupMasterDAO
extends GenericHibernateRepository<SdWorkgroupmaster, Integer>
implements ISdWorkgroupMasterDAO {
    @Override
    public List<SdWorkgroupmaster> getSdWorkgroupMasterByProjectId(Integer projectId) {
        String query = " from SdWorkgroupmaster where projectId = :projectId and workGroupStatus=0";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdWorkgroupmaster.class);
    }

    @Override
    public void saveWorkgroupDetails(List<SdWorkgroupdetails> sdWorkgroupdetailses) {
        if (CollectionUtil.isNotEmpty(sdWorkgroupdetailses)) {
            for (SdWorkgroupdetails s : sdWorkgroupdetailses) {
                this.hibernateDaoOperations.save((Object)s);
            }
        }
    }

    @Override
    public List<WorkGroupMinDTO> getWorkGroup(DataSource datasource) {
        return this.hibernateDaoOperations.getSessionFactory().getCurrentSession().createNativeQuery("SELECT WorkGroupID AS id, WorkGroupName AS name FROM sd_workgroupmaster WHERE ProjectId= :projectId").addScalar("id", StandardBasicTypes.INTEGER).addScalar("name", StandardBasicTypes.STRING).setParameter("projectId", (Object)datasource.getProjectid()).setResultTransformer(Transformers.aliasToBean(WorkGroupMinDTO.class)).list();
    }

    @Override
    public SdWorkgroupmaster getWorkgroupMasterByName(String workGroupName, Integer projectId) {
        String query = " from SdWorkgroupmaster where projectId = :projectId and workGroupName = :workGroupName and workGroupStatus = 0";
        String[] paramNames = new String[]{"projectId", "workGroupName"};
        Object[] values = new Object[]{projectId};
        return (SdWorkgroupmaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdWorkgroupmaster.class));
    }

    @Override
    public List<SdWorkgroupmaster> getSdWorkgroupMasterByProjectIds(List<Integer> projectIds) {
        String query = " from SdWorkgroupmaster where projectId in (:projectId) ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectIds};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdWorkgroupmaster.class);
    }

    @Override
    public List<Object[]> getUserWorkGroups(String projectRoleIds, Integer userId, Integer projectId) {
        String query = "SELECT wm.WorkGroupID, wm.WorkGroupName FROM sd_workgroupmaster wm, sd_workgroupdetails wd, sd_project_roles rm, sd_project_roles_details rd where wm.ProjectID = :projectId and wm.ProjectID = rm.ProjectID and wm.workGroupStatus = 0 and wm.WorkGroupID = wd.WorkGroupID and ((wd.WorkGroupType = 6 and (wd.WorkGroupValue = rm.ProjectRoleID and rm.ProjectRoleID = rd.ProjectRoleID and rd.UserID = :userId ))) union (SELECT wm.WorkGroupID, wm.WorkGroupName FROM sd_workgroupmaster wm, sd_workgroupdetails wd, sd_project_roles rm where wm.ProjectID = :projectId and wm.ProjectID = rm.ProjectID and wm.workGroupStatus = 0 and wm.WorkGroupID = wd.WorkGroupID and wd.WorkGroupType = 7 and wd.WorkGroupValue = :userId )";
        String[] paramNames = new String[]{"projectId", "userId"};
        Object[] values = new Object[]{projectId, userId};
        return this.hibernateDaoOperations.findByNamedParamSql(query, paramNames, values, Object[].class);
    }

    @Override
    public List<SdWorkgroupmaster> listOfWorkgroup(int projectId) {
        List<Integer> types = Arrays.asList(1, 2, 3, 4, 5, 8, 9, 10);
        String query = "SELECT wm from SdWorkgroupmaster wm,SdWorkgroupdetails wd where wm.workGroupStatus=0 and wm.projectId=:projectId and wm.workGroupId=wd.sdWorkgroupmaster.workGroupId and wd.workGroupType in (:workGroupType) group by wm.workGroupId";
        String[] paramNames = new String[]{"projectId", "workGroupType"};
        Object[] values = new Object[]{projectId, types};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdWorkgroupmaster.class);
    }

    @Override
    public Integer getWorkGroupParameterMatched(int key, int workgroupType, int workgroupValue) {
        int isParameter = 0;
        String workGroupVal = "";
        String query = "from SdWorkgroupdetails where sdWorkgroupmaster.workGroupId = :workGroupId and workGroupType = :workGroupType";
        String[] paramNames = new String[]{"workGroupId", "workGroupType"};
        Object[] values = new Object[]{key, workgroupType};
        SdWorkgroupdetails wd = (SdWorkgroupdetails)((Object)this.hibernateDaoOperations.findByNamedParamMaxResult(query, paramNames, values, 1));
        if (wd == null) {
            isParameter = 1;
        } else {
            query = "from SdWorkgroupdetails where sdWorkgroupmaster.workGroupId = :workGroupId and workGroupType = :workGroupType and workGroupValue = :workGroupValue";
            String[] paramNamesTemp = new String[]{"workGroupId", "workGroupType", "workGroupValue"};
            Object[] valuesTemp = new Object[]{key, workgroupType, Integer.toString(workgroupValue)};
            List listOfSdWorkgroupdetails = this.hibernateDaoOperations.findByNamedParam(query, paramNamesTemp, valuesTemp, SdWorkgroupdetails.class);
            isParameter = !listOfSdWorkgroupdetails.isEmpty() ? 1 : 0;
        }
        return isParameter;
    }

    @Override
    public List<SdWorkgroupmaster> getSdWorkgroupMasterByProjectId(Integer projectId, Integer pageNo, Integer pageSize, String sortColumn, String sortDirection) {
        Object query = " from SdWorkgroupmaster where workGroupStatus = 0 and projectId = :projectId ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        if (sortColumn != null && !sortColumn.isEmpty()) {
            String direction = sortDirection != null && sortDirection.equalsIgnoreCase("desc") ? "desc" : "asc";
            query = (String)query + " order by " + sortColumn + " " + direction;
        }
        return this.genericHibernateDaoOperations.findByNamedParamAndPagesize((String)query, paramNames, values, pageNo, pageSize, SdDTOEnum.SD_WORKGROUP_MASTER);
    }

    @Override
    public SdWorkgroupdetails getWorkGroupValueByType(int workGroupType, Integer workGroupID) {
        String query = "from SdWorkgroupdetails where workGroupType = :workGroupType and sdWorkgroupmaster.workGroupId = :workGroupID ";
        String[] paramNames = new String[]{"workGroupType", "workGroupID"};
        Object[] values = new Object[]{workGroupType, workGroupID};
        return (SdWorkgroupdetails)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdWorkgroupdetails.class));
    }

    @Override
    public SdWorkgroupmaster getSdWorkgroupMasterByWorkgroupID(Integer workGroupID) {
        String query = " from SdWorkgroupmaster where workGroupId = :workGroupID ";
        String[] paramNames = new String[]{"workGroupID"};
        Object[] values = new Object[]{workGroupID};
        return (SdWorkgroupmaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, SdWorkgroupmaster.class));
    }

    @Override
    public void deleteWorkgroup(Integer workgroupId) {
        Session session = this.hibernateDaoOperations.getSessionFactory().getCurrentSession();
        MutationQuery sqlQuery = null;
        String Query2 = "update sd_workgroupmaster set workGroupStatus=2 where WorkgroupID=:workgroupId";
        sqlQuery = session.createNativeMutationQuery(Query2);
        sqlQuery.setParameter("workgroupId", (Object)workgroupId);
        sqlQuery.executeUpdate();
    }

    @Override
    public List<SdWorkgroupmaster> checkDuplicateWorkgroupName(String workgroupName, Integer projectId) {
        String query = "FROM SdWorkgroupmaster WHERE workGroupStatus=0 AND workGroupName=:workgroupName and projectId = :projectId";
        String[] paramNames = new String[]{"workgroupName", "projectId"};
        Object[] values = new Object[]{workgroupName, projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdWorkgroupmaster.class);
    }

    @Override
    public SdWorkgroupmaster updateWorkgroupName(SdWorkgroupMasterDTO workgroupMasterDTO, Integer projectId) {
        SdWorkgroupmaster workgroup = (SdWorkgroupmaster)((Object)this.hibernateDaoOperations.get(SdWorkgroupmaster.class, (Serializable)workgroupMasterDTO.getWorkGroupId()));
        workgroup.setWorkGroupName(workgroupMasterDTO.getWorkGroupName());
        this.hibernateDaoOperations.saveOrUpdate((Object)workgroup);
        return workgroup;
    }

    @Override
    public SdWorkgroupmaster saveWorkgroup(SdWorkgroupMasterDTO workgroupMasterDTO, Integer projectId) {
        SdWorkgroupmaster workgroupmaster = new SdWorkgroupmaster();
        workgroupmaster.setWorkGroupName(workgroupMasterDTO.getWorkGroupName());
        workgroupmaster.setWorkGroupDescription(workgroupMasterDTO.getWorkGroupDescription());
        workgroupmaster.setProjectId(projectId);
        this.hibernateDaoOperations.saveOrUpdate((Object)workgroupmaster);
        return workgroupmaster;
    }

    @Override
    public SdWorkgroupmaster saveWorkgroupDescription(Integer workgroupId, String workgroupDesc) {
        SdWorkgroupmaster workgroupmaster = (SdWorkgroupmaster)((Object)this.hibernateDaoOperations.get(SdWorkgroupmaster.class, (Serializable)workgroupId));
        workgroupmaster.setWorkGroupDescription(workgroupDesc);
        this.hibernateDaoOperations.saveOrUpdate((Object)workgroupmaster);
        return workgroupmaster;
    }

    @Override
    public void saveSdWorkgroupdetails(SdWorkgroupdetails workgroupdetails) {
        this.hibernateDaoOperations.saveOrUpdate((Object)workgroupdetails);
    }

    @Override
    public void deleteworkgroupdetails(Integer workgroupId, int workGroupType) {
        String query = "delete from SdWorkgroupdetails where workGroupType = :workGroupType and sdWorkgroupmaster.workGroupId = :workgroupId";
        String[] paramNames = new String[]{"workGroupType", "workgroupId"};
        Object[] values = new Object[]{workGroupType, workgroupId};
        this.hibernateDaoOperations.bulkUpdateOrDeleteByParam(query, paramNames, values);
    }
}

