/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.IHibernateRepositoryOperations;
import com.sapphireims.itsm.dao.ISlaprofileBusinesshrsDetailsDAO;
import com.sapphireims.itsm.model.SlaprofileBusinesshrsDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class SlaprofileBusinesshrsDetailsDAO
implements ISlaprofileBusinesshrsDetailsDAO {
    @Autowired
    @Qualifier(value="hibernateRepositoryOperations")
    protected IHibernateRepositoryOperations hibernateDaoOperations;

    @Override
    public SlaprofileBusinesshrsDetails getSlaprofileBusinesshrsDetails(Integer businessProfile, Integer weekDay, Integer typeOfValue) {
        String queryString = "from SlaprofileBusinesshrsDetails where slaprofileBusinesshrsMaster.profileId= :businessProfile and weekDay=:weekDay and typeOfValue=:typeOfValue";
        String[] paramNames = new String[]{"businessProfile", "weekDay", "typeOfValue"};
        Object[] values = new Object[]{businessProfile, weekDay, typeOfValue};
        return (SlaprofileBusinesshrsDetails)this.hibernateDaoOperations.findByNamedParamMaxResult(queryString, paramNames, values, 1);
    }

    @Override
    public SlaprofileBusinesshrsDetails getSlaprofileBusinesshrsDetails(Integer bussinessHrsProfile, Integer weekDay, Integer typeOfValue, String dateTime) {
        String queryString = "from SlaprofileBusinesshrsDetails where slaprofileBusinesshrsMaster.profileId= :businessProfile and weekDay=:weekDay and typeOfValue=:typeOfValue and Time(:dateTime) between Time(startHour) and Time(endHour)";
        String[] paramNames = new String[]{"businessProfile", "weekDay", "typeOfValue", "dateTime"};
        Object[] values = new Object[]{bussinessHrsProfile, weekDay, typeOfValue, dateTime};
        return (SlaprofileBusinesshrsDetails)this.hibernateDaoOperations.findByNamedParamMaxResult(queryString, paramNames, values, 1);
    }

    @Override
    public Integer getTimeGapSum(Integer bussinessHrsProfile, Integer weekDay, Integer typeOfValue, String startTime, String endTime) {
        String queryString = "SELECT sum(timeGap) from SlaprofileBusinesshrsDetails where slaprofileBusinesshrsMaster.profileId= :businessProfile and weekDay=:weekDay and typeOfValue=:typeOfValue and Time(endHour) between Time(:startTime) and Time(:endTime) and Time(endHour) <> Time(:startTime1) and Time(endHour) <> Time(:endTime1)";
        String[] paramNames = new String[]{"businessProfile", "weekDay", "typeOfValue", "startTime", "endTime", "startTime1", "endTime1"};
        Object[] values = new Object[]{bussinessHrsProfile, weekDay, typeOfValue, startTime, endTime, startTime, endTime};
        Object timeGap = this.hibernateDaoOperations.findByNamedParamMaxResult(queryString, paramNames, values, 1);
        Integer val = 0;
        if (timeGap != null) {
            if (timeGap instanceof Integer) {
                val = (Integer)timeGap;
            } else if (timeGap instanceof Long) {
                val = ((Long)timeGap).intValue();
            }
        }
        return val;
    }

    @Override
    public SlaprofileBusinesshrsDetails getSlaprofileBusinesshrsDetailsbyEndTime(Integer bussinessHrsProfile, Integer weekDay, String dateTime) {
        String queryString = "from SlaprofileBusinesshrsDetails where slaprofileBusinesshrsMaster.profileId= :businessProfile and weekDay=:weekDay and Time(endHour)<=Time(:dateTime) order by endHour desc";
        String[] paramNames = new String[]{"businessProfile", "weekDay", "dateTime"};
        Object[] values = new Object[]{bussinessHrsProfile, weekDay, dateTime};
        return (SlaprofileBusinesshrsDetails)this.hibernateDaoOperations.findByNamedParamMaxResult(queryString, paramNames, values, 1);
    }

    @Override
    public SlaprofileBusinesshrsDetails getSlaprofileBusinesshrsDetailsByEndHour(Integer bussinessHrsProfile, Integer weekDay, Integer typeOfValue, String dateTime) {
        String queryString = "from SlaprofileBusinesshrsDetails where slaprofileBusinesshrsMaster.profileId= :businessProfile and weekDay=:weekDay and typeOfValue=:typeOfValue and Time(:dateTime) between Time(startHour) and Time(endHour) and Time(:dateTime1) <> Time(endHour)";
        String[] paramNames = new String[]{"businessProfile", "weekDay", "typeOfValue", "dateTime", "dateTime1"};
        Object[] values = new Object[]{bussinessHrsProfile, weekDay, typeOfValue, dateTime, dateTime};
        return (SlaprofileBusinesshrsDetails)this.hibernateDaoOperations.findByNamedParamMaxResult(queryString, paramNames, values, 1);
    }

    @Override
    public SlaprofileBusinesshrsDetails getSlaprofileBusinesshrsDetailsEndHourLessThanStartTime(Integer bussinessHrsProfile, Integer weekDay, String dateTime) {
        String queryString = "from SlaprofileBusinesshrsDetails where slaprofileBusinesshrsMaster.profileId= :businessProfile and weekDay=:weekDay and Time(endHour)<=Time(:dateTime) order by endHour desc";
        String[] paramNames = new String[]{"businessProfile", "weekDay", "dateTime"};
        Object[] values = new Object[]{bussinessHrsProfile, weekDay, dateTime};
        return (SlaprofileBusinesshrsDetails)this.hibernateDaoOperations.findByNamedParamMaxResult(queryString, paramNames, values, 1);
    }

    @Override
    public SlaprofileBusinesshrsDetails getSlaprofileBusinesshrsDetailsCumulativeValidTime(Integer bussinessHrsProfile, Integer weekDay, Integer timeLeft) {
        String queryString = "from SlaprofileBusinesshrsDetails where slaprofileBusinesshrsMaster.profileId= :businessProfile and weekDay=:weekDay and cumulativeValidTime<=:timeLeft order by cumulativeValidTime desc";
        String[] paramNames = new String[]{"businessProfile", "weekDay", "timeLeft"};
        Object[] values = new Object[]{bussinessHrsProfile, weekDay, timeLeft};
        return (SlaprofileBusinesshrsDetails)this.hibernateDaoOperations.findByNamedParamMaxResult(queryString, paramNames, values, 1);
    }

    @Override
    public SlaprofileBusinesshrsDetails getSlaprofileBusinesshrsDetailsIsWeekDayConsider(Integer bussinessHrsProfile, Integer weekDay, Integer isWeekDayConsider, Integer typeOfValue) {
        String queryString = "from SlaprofileBusinesshrsDetails where slaprofileBusinesshrsMaster.profileId= :businessProfile and typeOfValue=:typeOfValue and weekDay=:weekDay and isWeekDayConsider=:isWeekDayConsider ";
        String[] paramNames = new String[]{"businessProfile", "typeOfValue", "weekDay", "isWeekDayConsider"};
        Object[] values = new Object[]{bussinessHrsProfile, typeOfValue, weekDay, isWeekDayConsider};
        return (SlaprofileBusinesshrsDetails)this.hibernateDaoOperations.findByNamedParamMaxResult(queryString, paramNames, values, 1);
    }

    @Override
    public Integer getMaxWeekDayFromSlaprofileBusinesshrsDetails(Integer bussinessHrsProfile, Integer isWeekDayConsider) {
        String queryString = "select MAX(weekDay) from SlaprofileBusinesshrsDetails where slaprofileBusinesshrsMaster.profileId= :businessProfile and isWeekDayConsider=:isWeekDayConsider ";
        String[] paramNames = new String[]{"businessProfile", "isWeekDayConsider"};
        Object[] values = new Object[]{bussinessHrsProfile, isWeekDayConsider};
        return (Integer)this.hibernateDaoOperations.findByNamedParamUniqueResult(queryString, paramNames, values, Integer.class);
    }
}

