/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dao.impl;

import com.sapphireims.dao.IHibernateRepositoryOperations;
import com.sapphireims.itsm.dao.ITempEscalationDAO;
import com.sapphireims.itsm.model.SdServiceReqMaster;
import com.sapphireims.itsm.model.TempEscalation;
import com.sapphireims.util.CollectionUtil;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class TempEscalationDAO
implements ITempEscalationDAO {
    @Autowired
    @Qualifier(value="hibernateRepositoryOperations")
    protected IHibernateRepositoryOperations hibernateDaoOperations;

    @Override
    public void deleteTempEscalations(Integer type) {
        String query = "delete TempEscalation where type =  " + type;
        this.hibernateDaoOperations.deleteUpdate(query);
    }

    @Override
    public void insertTempEscalations(TempEscalation tempEscalation) {
        this.hibernateDaoOperations.save(tempEscalation);
    }

    @Override
    public List<TempEscalation> getTempEscalationList(Integer type) {
        String query = "from TempEscalation where type = :type";
        String[] paramNames = new String[]{"type"};
        Object[] values = new Object[]{type};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, TempEscalation.class);
    }

    @Override
    public Integer insertTempEscalationsBasedOnUserQueries(Integer type, Integer queryType, String value, String escalationParams, SdServiceReqMaster sdServiceReqMaster) {
        Object query = "";
        if (queryType == 1) {
            query = "select um.emailAddress from UserMgmtMaster um, UserDetails ud where um.userDetails.userId = ud.userId and ud.userStatus = 0 and um.userDetails.userId in (" + value + ")";
        } else if (queryType == 2) {
            query = "select um.emailAddress from UserMgmtMaster um, UserDetails ud where um.userDetails.userId = ud.userId and ud.userStatus = 0 and um.accessId in (" + value + ")";
        } else if (queryType == 3) {
            query = "select um.emailAddress from UserMgmtMaster um, UserDetails ud where um.userDetails.userId = ud.userId and ud.userStatus = 0 and um.accessId in (" + value + ")";
            if (!escalationParams.equals("")) {
                if (escalationParams.substring(0, 1).equals("1")) {
                    query = (String)query + " and um.departmentId = " + sdServiceReqMaster.getDepartmentId();
                }
                if (escalationParams.substring(1, 2).equals("1")) {
                    query = (String)query + " and um.locationId = " + sdServiceReqMaster.getLocationId();
                }
                if (escalationParams.substring(2, 3).equals("1")) {
                    query = (String)query + " and um.specializationId like '%" + sdServiceReqMaster.getSubCategory() + "%'";
                }
            }
        }
        if (!((String)query).equals("")) {
            List list = this.hibernateDaoOperations.find((String)query, String.class);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String detail;
                String emailAddress = detail = (String)iterator.next();
                TempEscalation tempEscalation = new TempEscalation(emailAddress, "", type);
                this.hibernateDaoOperations.save(tempEscalation);
            }
        }
        return 1;
    }

    @Override
    public Integer insertTempEscalationsBasedOnUserAccessQueries(Integer type, Integer accessType, Integer notifyProfileType) {
        String query = "select um.emailAddress from UserMgmtMaster um, UserDetails ud, SdNotifyAccessDetails sn,TempNotifications tn where  um.userDetails.userId = ud.userId and ud.userStatus = 0 and cast(um.userDetails.userId as string)=sn.accessValue and sn.accessType = :accessType and sn.notifyId=tn.notifyId and tn.notifyProfileType = :notifyProfileType and tn.type = :type";
        String[] paramName = new String[]{"accessType", "notifyProfileType", "type"};
        Object[] value = new Object[]{accessType, notifyProfileType, type};
        List list = this.hibernateDaoOperations.findByNamedParam(query, paramName, value, String.class);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String detail;
            String emailAddress = detail = (String)iterator.next();
            TempEscalation tempEscalation = new TempEscalation(emailAddress, "", type);
            this.hibernateDaoOperations.save(tempEscalation);
        }
        return 1;
    }

    @Override
    public Integer insertTempEscalationsBasedOnUserAccessQueries(Integer type, Integer userId, Integer accessType, Integer notifyProfileType) {
        String query = "select sn.notifyId from SdNotifyAccessDetails sn, TempNotifications tn where sn.notifyId=tn.notifyId and sn.accessType = :accessType and tn.notifyProfileType = :notifyProfileType and tn.type = :type";
        String[] paramName = new String[]{"accessType", "notifyProfileType", "type"};
        Object[] value = new Object[]{accessType, notifyProfileType, type};
        List list1 = this.hibernateDaoOperations.findByNamedParam(query, paramName, value, Integer.class);
        Integer count = 0;
        if (!CollectionUtil.isEmpty(list1)) {
            count = list1.size();
        }
        if (count != 0) {
            query = "select um.emailAddress from UserMgmtMaster um where um.userDetails.userId = :userId";
            String[] paramName1 = new String[]{"userId"};
            Object[] value1 = new Object[]{userId};
            List list = this.hibernateDaoOperations.findByNamedParam(query, paramName1, value1, String.class);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String detail;
                String emailAddress = detail = (String)iterator.next();
                TempEscalation tempEscalation = new TempEscalation(emailAddress, "", type);
                this.hibernateDaoOperations.save(tempEscalation);
            }
        }
        return 1;
    }

    @Override
    public Integer insertTempEscalationsForSLANotifyProfile(Integer type, String value, String escalationParams, SdServiceReqMaster sdServiceReqMaster) {
        Object query = "";
        query = "select um.emailAddress from UserMgmtMaster um, UserDetails ud, SdProjectRolesDetails sdp where um.userDetails.userId = ud.userId and ud.userStatus = 0 and um.userDetails.userId = sdp.userId and sdp.sdProjectRoles.projectRoleId = :value";
        if (!escalationParams.equals("")) {
            if (escalationParams.substring(0, 1).equals("1")) {
                query = (String)query + " and um.locationId = " + sdServiceReqMaster.getLocationId();
            }
            if (escalationParams.substring(1, 2).equals("1")) {
                query = (String)query + " and um.departmentId = " + sdServiceReqMaster.getDepartmentId();
            }
            if (escalationParams.substring(2, 3).equals("1")) {
                String query1 = "select us.userId from SdUserspecializations us, SdServiceReqMaster s where us.specializationType = 3 and us.specializationValue = s.subCategory and s.problemId = :problemId";
                String[] paramName = new String[]{"problemId"};
                Object[] paramvalue = new Object[]{sdServiceReqMaster.getProblemId()};
                List list = this.hibernateDaoOperations.findByNamedParam(query1, paramName, paramvalue, Integer.class);
                String userIDs = "";
                if (!list.isEmpty()) {
                    userIDs = list.stream().map(String::valueOf).collect(Collectors.joining(","));
                }
                if (!userIDs.isEmpty()) {
                    query = (String)query + " and um.userDetails.userId in (" + userIDs + ")";
                }
            }
        }
        if (!((String)query).equals("")) {
            String[] paramName1 = new String[]{"value"};
            Object[] value1 = new Object[]{Integer.parseInt(value)};
            List list = this.hibernateDaoOperations.findByNamedParam((String)query, paramName1, value1, String.class);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String detail;
                String emailAddress = detail = (String)iterator.next();
                TempEscalation tempEscalation = new TempEscalation(emailAddress, "", type);
                this.hibernateDaoOperations.save(tempEscalation);
            }
        }
        return 1;
    }
}

