/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.sapphireims.dto.BaseDTO;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class CreateDirectoriesDTO
extends BaseDTO {
    private static final long serialVersionUID = 367828138040134718L;
    private String parent;
    private String child1;
    private String child2;
    private String child3;
    private String child4;
    private String child5;
    private String child6;
    private String child7;
    private String child8;
    private String child9;
    private String child10;
    private List<String> all;

    public CreateDirectoriesDTO() {
    }

    public CreateDirectoriesDTO(String warPath, String moduleType) throws FileNotFoundException, IOException {
        if (moduleType.isEmpty() || moduleType == null || warPath.isEmpty() || warPath == null) {
            throw new IllegalArgumentException("CreateDirectoriesDTO -- Module type or War path is null or empty");
        }
        Properties props = new Properties();
        String moduleTypePath = "";
        try (FileInputStream fis = new FileInputStream(warPath + "/WEB-INF/classes/resource/modulecopy.properties");){
            props.load(fis);
            Set<Object> keys = props.keySet();
            for (Object key : keys) {
                String k = (String)key;
                if (!k.contains(moduleType.toLowerCase())) continue;
                moduleTypePath = props.getProperty(k);
            }
            if (moduleTypePath.isEmpty() || moduleTypePath == null) {
                throw new InvalidPropertiesFormatException("CreateDirectoriesDTO -- Path of module type is null or empty");
            }
            String[] pathSplitArray = moduleTypePath.split("\\\\");
            block19: for (int i = 0; i < pathSplitArray.length; ++i) {
                switch (i) {
                    case 1: {
                        this.parent = pathSplitArray[i];
                        continue block19;
                    }
                    case 2: {
                        this.child1 = pathSplitArray[i];
                        continue block19;
                    }
                    case 3: {
                        this.child2 = pathSplitArray[i];
                        continue block19;
                    }
                    case 4: {
                        this.child3 = pathSplitArray[i];
                        continue block19;
                    }
                    case 5: {
                        this.child4 = pathSplitArray[i];
                        continue block19;
                    }
                    case 6: {
                        this.child5 = pathSplitArray[i];
                        continue block19;
                    }
                    case 7: {
                        this.child6 = pathSplitArray[i];
                        continue block19;
                    }
                    case 8: {
                        this.child7 = pathSplitArray[i];
                        continue block19;
                    }
                    case 9: {
                        this.child8 = pathSplitArray[i];
                        continue block19;
                    }
                    case 10: {
                        this.child9 = pathSplitArray[i];
                        continue block19;
                    }
                    case 11: {
                        this.child10 = pathSplitArray[i];
                        continue block19;
                    }
                }
            }
        }
    }

    public CreateDirectoriesDTO(String parent, String child1, String child2, String child3, String child4, String child5) {
        this.parent = parent;
        this.child1 = child1;
        this.child2 = child2;
        this.child3 = child3;
        this.child4 = child4;
        this.child5 = child5;
    }

    private CreateDirectoriesDTO(Builder builder) {
        this.parent = builder.parent;
        this.child1 = builder.child1;
        this.child2 = builder.child2;
        this.child3 = builder.child3;
        this.child4 = builder.child4;
        this.child5 = builder.child5;
        this.all = builder.allPaths;
    }

    public List<String> getAll() {
        this.all = new LinkedList<String>();
        this.all.add(this.parent);
        this.all.add(this.child1);
        this.all.add(this.child2);
        this.all.add(this.child3);
        this.all.add(this.child4);
        this.all.add(this.child5);
        return this.all;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getChild1() {
        return this.child1;
    }

    public void setChild1(String child1) {
        this.child1 = child1;
    }

    public String getChild2() {
        return this.child2;
    }

    public void setChild2(String child2) {
        this.child2 = child2;
    }

    public String getChild3() {
        return this.child3;
    }

    public void setChild3(String child3) {
        this.child3 = child3;
    }

    public String getChild4() {
        return this.child4;
    }

    public void setChild4(String child4) {
        this.child4 = child4;
    }

    public String getChild5() {
        return this.child5;
    }

    public void setChild5(String child5) {
        this.child5 = child5;
    }

    public String getChild6() {
        return this.child6;
    }

    public void setChild6(String child6) {
        this.child6 = child6;
    }

    public String getChild7() {
        return this.child7;
    }

    public void setChild7(String child7) {
        this.child7 = child7;
    }

    public String getChild8() {
        return this.child8;
    }

    public void setChild8(String child8) {
        this.child8 = child8;
    }

    public String getChild9() {
        return this.child9;
    }

    public void setChild9(String child9) {
        this.child9 = child9;
    }

    public String getChild10() {
        return this.child10;
    }

    public void setChild10(String child10) {
        this.child10 = child10;
    }

    public Integer getId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setId(Integer id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String parent;
        private String child1;
        private String child2;
        private String child3;
        private String child4;
        private String child5;
        private List<String> allPaths;

        private Builder() {
        }

        public Builder withParent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder withChild1(String child1) {
            this.child1 = child1;
            return this;
        }

        public Builder withChild2(String child2) {
            this.child2 = child2;
            return this;
        }

        public Builder withChild3(String child3) {
            this.child3 = child3;
            return this;
        }

        public Builder withChild4(String child4) {
            this.child4 = child4;
            return this;
        }

        public Builder withChild5(String child5) {
            this.child5 = child5;
            return this;
        }

        public CreateDirectoriesDTO build() {
            return new CreateDirectoriesDTO(this);
        }
    }
}

