/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.KnowledgeAccessDTO;
import com.sapphireims.itsm.dto.KnowledgeCategorymasterDTO;
import com.sapphireims.itsm.dto.KnowledgeSubcategorymasterDTO;
import com.sapphireims.itsm.model.KnowledgeAccess;
import com.sapphireims.itsm.model.KnowledgeCategorymaster;
import com.sapphireims.itsm.model.KnowledgeSubcategorymaster;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class KnowledgeStoreDTO
extends BaseDTO {
    private static final long serialVersionUID = -4086212852336580867L;
    private Integer slno;
    private String title;
    private String problemDesc;
    private KnowledgeCategorymasterDTO knowledgeCategory;
    private KnowledgeSubcategorymasterDTO knowledgeSubCategory;
    private String resolutionDesc;
    private String submittedBy;
    private Integer approvedBy;
    private int isApproved;
    private Date time;
    private Integer accessType;
    private String keywords;
    private int knowledgeType;
    private String rootCause;
    private String symptoms;
    private String errorCode;
    private int baseType;
    private int userViews;
    private int isKbvisible;
    private int projectId;
    private int status;
    private List<KnowledgeAccessDTO> knowledgeAccesses = new ArrayList<KnowledgeAccessDTO>(0);

    private KnowledgeStoreDTO(Builder builder) {
        this.id = builder.id;
        this.updated = builder.updated;
        this.tenanatId = builder.tenanatId;
        this.history = builder.history;
        this.slno = builder.slno;
        this.knowledgeCategory = builder.knowledgeCategory;
        this.knowledgeSubCategory = builder.knowledgeSubCategory;
        this.title = builder.title;
        this.problemDesc = builder.problemDesc;
        this.resolutionDesc = builder.resolutionDesc;
        this.submittedBy = builder.submittedBy;
        this.approvedBy = builder.approvedBy;
        this.isApproved = builder.isApproved;
        this.time = builder.time;
        this.accessType = builder.accessType;
        this.keywords = builder.keywords;
        this.knowledgeType = builder.knowledgeType;
        this.rootCause = builder.rootCause;
        this.symptoms = builder.symptoms;
        this.errorCode = builder.errorCode;
        this.baseType = builder.baseType;
        this.userViews = builder.userViews;
        this.isKbvisible = builder.isKbvisible;
        this.projectId = builder.projectId;
        this.status = builder.status;
        this.knowledgeAccesses = builder.knowledgeAccesses;
    }

    public KnowledgeStoreDTO() {
    }

    public KnowledgeStoreDTO(Integer slno) {
        this.slno = slno;
    }

    public KnowledgeStoreDTO(Integer slno, KnowledgeCategorymaster knowledgeCategory, KnowledgeSubcategorymaster knowledgeSubCategory, String title, String problemDesc, String resolutionDesc, String submittedBy, Integer approvedBy, int isApproved, Date time, Integer accessType, String keywords, int knowledgeType, String rootCause, String symptoms, String errorCode, int baseType, int userViews, int isKbvisible, int projectId, int status, Set<KnowledgeAccess> knowledgeAccesses) {
        this.slno = slno;
        this.knowledgeCategory = new KnowledgeCategorymasterDTO(knowledgeCategory);
        this.knowledgeSubCategory = new KnowledgeSubcategorymasterDTO(knowledgeSubCategory);
        this.title = title;
        this.problemDesc = problemDesc;
        this.resolutionDesc = resolutionDesc;
        this.submittedBy = submittedBy;
        this.approvedBy = approvedBy;
        this.isApproved = isApproved;
        this.time = time;
        this.accessType = accessType;
        this.keywords = keywords;
        this.knowledgeType = knowledgeType;
        this.rootCause = rootCause;
        this.symptoms = symptoms;
        this.errorCode = errorCode;
        this.baseType = baseType;
        this.userViews = userViews;
        this.isKbvisible = isKbvisible;
        this.projectId = projectId;
        this.status = status;
        if (CollectionUtil.isNotEmpty(knowledgeAccesses)) {
            this.knowledgeAccesses = knowledgeAccesses.stream().map(KnowledgeAccessDTO::new).collect(Collectors.toList());
        }
    }

    public KnowledgeCategorymasterDTO getKnowledgeCategory() {
        return this.knowledgeCategory;
    }

    public void setKnowledgeCategory(KnowledgeCategorymasterDTO knowledgeCategory) {
        this.knowledgeCategory = knowledgeCategory;
    }

    public KnowledgeSubcategorymasterDTO getKnowledgeSubCategory() {
        return this.knowledgeSubCategory;
    }

    public void setKnowledgeSubCategory(KnowledgeSubcategorymasterDTO knowledgeSubCategory) {
        this.knowledgeSubCategory = knowledgeSubCategory;
    }

    public Integer getSlno() {
        return this.slno;
    }

    public void setSlno(Integer slno) {
        this.slno = slno;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getProblemDesc() {
        return this.problemDesc;
    }

    public void setProblemDesc(String problemDesc) {
        this.problemDesc = problemDesc;
    }

    public String getResolutionDesc() {
        return this.resolutionDesc;
    }

    public void setResolutionDesc(String resolutionDesc) {
        this.resolutionDesc = resolutionDesc;
    }

    public String getSubmittedBy() {
        return this.submittedBy;
    }

    public void setSubmittedBy(String submittedBy) {
        this.submittedBy = submittedBy;
    }

    public Integer getApprovedBy() {
        return this.approvedBy;
    }

    public void setApprovedBy(Integer approvedBy) {
        this.approvedBy = approvedBy;
    }

    public int getIsApproved() {
        return this.isApproved;
    }

    public void setIsApproved(int isApproved) {
        this.isApproved = isApproved;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public Integer getAccessType() {
        return this.accessType;
    }

    public void setAccessType(Integer accessType) {
        this.accessType = accessType;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public int getKnowledgeType() {
        return this.knowledgeType;
    }

    public void setKnowledgeType(int knowledgeType) {
        this.knowledgeType = knowledgeType;
    }

    public String getRootCause() {
        return this.rootCause;
    }

    public void setRootCause(String rootCause) {
        this.rootCause = rootCause;
    }

    public String getSymptoms() {
        return this.symptoms;
    }

    public void setSymptoms(String symptoms) {
        this.symptoms = symptoms;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public int getBaseType() {
        return this.baseType;
    }

    public void setBaseType(int baseType) {
        this.baseType = baseType;
    }

    public int getUserViews() {
        return this.userViews;
    }

    public void setUserViews(int userViews) {
        this.userViews = userViews;
    }

    public int getIsKbvisible() {
        return this.isKbvisible;
    }

    public void setIsKbvisible(int isKbvisible) {
        this.isKbvisible = isKbvisible;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public List<KnowledgeAccessDTO> getKnowledgeAccesses() {
        return this.knowledgeAccesses;
    }

    public void setKnowledgeAccesses(List<KnowledgeAccessDTO> knowledgeAccesses) {
        this.knowledgeAccesses = knowledgeAccesses;
    }

    public Integer getId() {
        return this.getSlno();
    }

    public void setId(Integer id) {
        this.setSlno(id);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private boolean updated;
        private String tenanatId;
        private Object history;
        private Integer slno;
        private KnowledgeCategorymasterDTO knowledgeCategory;
        private KnowledgeSubcategorymasterDTO knowledgeSubCategory;
        private String title;
        private String problemDesc;
        private String resolutionDesc;
        private String submittedBy;
        private Integer approvedBy;
        private int isApproved;
        private Date time;
        private Integer accessType;
        private String keywords;
        private int knowledgeType;
        private String rootCause;
        private String symptoms;
        private String errorCode;
        private int baseType;
        private int userViews;
        private int isKbvisible;
        private int projectId;
        private int status;
        private List<KnowledgeAccessDTO> knowledgeAccesses = Collections.emptyList();

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withTenanatId(String tenanatId) {
            this.tenanatId = tenanatId;
            return this;
        }

        public Builder withHistory(Object history) {
            this.history = history;
            return this;
        }

        public Builder withSlno(Integer slno) {
            this.slno = slno;
            return this;
        }

        public Builder withKnowledgeCategory(KnowledgeCategorymasterDTO knowledgeCategory) {
            this.knowledgeCategory = knowledgeCategory;
            return this;
        }

        public Builder withKnowledgeSubCategory(KnowledgeSubcategorymasterDTO knowledgeSubCategory) {
            this.knowledgeSubCategory = knowledgeSubCategory;
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withProblemDesc(String problemDesc) {
            this.problemDesc = problemDesc;
            return this;
        }

        public Builder withResolutionDesc(String resolutionDesc) {
            this.resolutionDesc = resolutionDesc;
            return this;
        }

        public Builder withSubmittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
            return this;
        }

        public Builder withApprovedBy(Integer approvedBy) {
            this.approvedBy = approvedBy;
            return this;
        }

        public Builder withIsApproved(int isApproved) {
            this.isApproved = isApproved;
            return this;
        }

        public Builder withTime(Date time) {
            this.time = time;
            return this;
        }

        public Builder withAccessType(Integer accessType) {
            this.accessType = accessType;
            return this;
        }

        public Builder withKeywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder withKnowledgeType(int knowledgeType) {
            this.knowledgeType = knowledgeType;
            return this;
        }

        public Builder withRootCause(String rootCause) {
            this.rootCause = rootCause;
            return this;
        }

        public Builder withSymptoms(String symptoms) {
            this.symptoms = symptoms;
            return this;
        }

        public Builder withErrorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder withBaseType(int baseType) {
            this.baseType = baseType;
            return this;
        }

        public Builder withUserViews(int userViews) {
            this.userViews = userViews;
            return this;
        }

        public Builder withIsKbvisible(int isKbvisible) {
            this.isKbvisible = isKbvisible;
            return this;
        }

        public Builder withProjectId(int projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withStatus(int status) {
            this.status = status;
            return this;
        }

        public Builder withKnowledgeAccesses(List<KnowledgeAccessDTO> knowledgeAccesses) {
            this.knowledgeAccesses = knowledgeAccesses;
            return this;
        }

        public KnowledgeStoreDTO build() {
            return new KnowledgeStoreDTO(this);
        }
    }
}

