/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.validationScripting.model.MethodMapping;

public class MethodMappingDTO
extends BaseDTO {
    private static final long serialVersionUID = 6395316262002512528L;
    private Integer mappingId;
    private String methodName;
    private String description;
    private String displayname;
    private String newUIMethodName;

    public MethodMappingDTO() {
    }

    public MethodMappingDTO(Integer mappingId, String methodName, String description, String displayname, String newUIMethodName) {
        this.mappingId = mappingId;
        this.methodName = methodName;
        this.description = description;
        this.displayname = displayname;
        this.newUIMethodName = newUIMethodName;
    }

    public MethodMappingDTO(MethodMapping mm) {
        this(mm.getMappingId(), mm.getMethodName(), mm.getDescription(), mm.getDisplayname(), mm.getNewUIMethodName());
    }

    @JsonIgnore
    public MethodMapping getMethodMappingEntity() {
        return new MethodMapping(this.methodName, this.description, this.displayname, this.newUIMethodName);
    }

    private MethodMappingDTO(Builder builder) {
        this.mappingId = builder.mappingId;
        this.methodName = builder.methodName;
        this.description = builder.description;
        this.displayname = builder.displayname;
        this.newUIMethodName = builder.newUIMethodName;
    }

    public Integer getMappingId() {
        return this.mappingId;
    }

    public void setMappingId(Integer mappingId) {
        this.mappingId = mappingId;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public void setDisplayname(String displayname) {
        this.displayname = displayname;
    }

    public String getNewUIMethodName() {
        return this.newUIMethodName;
    }

    public void setNewUIMethodName(String newUIMethodName) {
        this.newUIMethodName = newUIMethodName;
    }

    public Integer getId() {
        return this.getMappingId();
    }

    public void setId(Integer id) {
        this.setMappingId(id);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer mappingId;
        private String methodName;
        private String description;
        private String displayname;
        private String newUIMethodName;

        private Builder() {
        }

        public Builder withMappingId(Integer mappingId) {
            this.mappingId = mappingId;
            return this;
        }

        public Builder withMethodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withDisplayName(String displayname) {
            this.displayname = displayname;
            return this;
        }

        public Builder withNewUIMethodName(String newUIMethodName) {
            this.newUIMethodName = newUIMethodName;
            return this;
        }

        public MethodMappingDTO build() {
            return new MethodMappingDTO(this);
        }
    }
}

