/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.MoreObjects;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.ticket.TicketAttachmentDTO;
import com.sapphireims.itsm.model.SdAttachmentdetails;
import com.sapphireims.itsm.model.SdServiceReqMaster;
import java.util.Date;
import java.util.Objects;

public class SdAttachmentDetailsDTO
extends BaseDTO {
    private static final long serialVersionUID = -7518193550843760297L;
    private Integer attachmentId;
    private Integer problemId;
    private String attachmentName;
    private String attachment;
    private byte access;
    private int userId;
    private int fieldId;
    private int stateId;
    private String comment;
    private Date time;
    private byte type;
    private byte displayType;
    private String latitude;
    private String longitude;

    private SdAttachmentDetailsDTO(Builder builder) {
        this.attachmentId = builder.attachmentId;
        this.problemId = builder.problemId;
        this.attachmentName = builder.attachmentName;
        this.attachment = builder.attachment;
        this.access = builder.access;
        this.userId = builder.userId;
        this.fieldId = builder.fieldId;
        this.stateId = builder.stateId;
        this.comment = builder.comment;
        this.time = builder.time;
        this.type = builder.type;
        this.displayType = builder.displayType;
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
    }

    public SdAttachmentDetailsDTO() {
    }

    public SdAttachmentDetailsDTO(Integer id) {
        super(id);
    }

    public SdAttachmentDetailsDTO(TicketAttachmentDTO a, Integer pid, Integer userId) {
        this.attachmentId = a.getAttachmentId();
        this.problemId = pid;
        this.attachmentName = a.getAttachmentName();
        this.attachment = a.getAttachment();
        this.access = a.getAccess();
        this.userId = userId != null ? userId : 0;
        this.fieldId = a.getFieldId();
        this.stateId = a.getStateId();
        this.comment = a.getComment();
        this.time = new Date();
        this.type = 0;
        this.displayType = 1;
    }

    public SdAttachmentDetailsDTO(SdAttachmentdetails att) {
        this(att.getAttachmentId(), att.getSdServicereqmaster().getProblemId(), att.getAttachmentName(), att.getAttachment(), att.getAccess(), att.getUserId(), att.getFieldId(), att.getStateId(), att.getComment(), att.getTime(), att.getType(), att.getDisplayType());
    }

    public SdAttachmentDetailsDTO(Integer attachmentId, Integer problemId, String attachmentName, String attachment, byte access, int userId, int fieldId, int stateId, String comment, Date time, byte type, byte displayType) {
        this.attachmentId = attachmentId;
        this.problemId = problemId;
        this.attachmentName = attachmentName;
        this.attachment = attachment;
        this.access = access;
        this.userId = userId;
        this.fieldId = fieldId;
        this.stateId = stateId;
        this.comment = comment;
        this.time = time;
        this.type = type;
        this.displayType = displayType;
    }

    @JsonIgnore
    public SdAttachmentdetails getSdAttachmenDetails(SdServiceReqMaster sdServicereqmaster) {
        return new SdAttachmentdetails(sdServicereqmaster, this.attachmentName, this.attachment, this.access, this.userId, this.fieldId, this.stateId, this.comment, this.time, this.type, this.displayType);
    }

    public Integer getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(Integer attachmentId) {
        this.attachmentId = attachmentId;
    }

    public Integer getProblemId() {
        return this.problemId;
    }

    public void setProblemId(Integer problemId) {
        this.problemId = problemId;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public byte getAccess() {
        return this.access;
    }

    public void setAccess(byte access) {
        this.access = access;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(int fieldId) {
        this.fieldId = fieldId;
    }

    public int getStateId() {
        return this.stateId;
    }

    public void setStateId(int stateId) {
        this.stateId = stateId;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public byte getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(byte displayType) {
        this.displayType = displayType;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public Integer getId() {
        return this.getAttachmentId();
    }

    public void setId(Integer id) {
        this.setAttachmentId(id);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.attachmentId, this.problemId, this.attachmentName, this.attachment, this.access, this.userId, this.fieldId, this.stateId, this.comment, this.time, this.type, this.displayType);
    }

    public boolean equals(Object object) {
        if (object instanceof SdAttachmentDetailsDTO) {
            if (!super.equals(object)) {
                return false;
            }
            SdAttachmentDetailsDTO that = (SdAttachmentDetailsDTO)((Object)object);
            return Objects.equals(this.attachmentId, that.attachmentId) && Objects.equals(this.problemId, that.problemId) && Objects.equals(this.attachmentName, that.attachmentName) && Objects.equals(this.attachment, that.attachment) && this.access == that.access && this.userId == that.userId && this.fieldId == that.fieldId && this.stateId == that.stateId && Objects.equals(this.comment, that.comment) && Objects.equals(this.time, that.time) && this.type == that.type && this.displayType == that.displayType;
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", -7518193550843760297L).add("attachmentId", (Object)this.attachmentId).add("problemId", (Object)this.problemId).add("attachmentName", (Object)this.attachmentName).add("attachment", (Object)this.attachment).add("access", (int)this.access).add("userId", this.userId).add("fieldId", this.fieldId).add("stateId", this.stateId).add("comment", (Object)this.comment).add("time", (Object)this.time).add("type", (int)this.type).add("displayType", (int)this.displayType).toString();
    }

    public static final class Builder {
        private Integer attachmentId;
        private Integer problemId;
        private String attachmentName;
        private String attachment;
        private byte access;
        private int userId;
        private int fieldId;
        private int stateId;
        private String comment;
        private Date time;
        private byte type;
        private byte displayType;
        private String latitude;
        private String longitude;

        private Builder() {
        }

        public Builder withAttachmentId(Integer attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public Builder withProblemId(Integer problemId) {
            this.problemId = problemId;
            return this;
        }

        public Builder withAttachmentName(String attachmentName) {
            this.attachmentName = attachmentName;
            return this;
        }

        public Builder withAttachment(String attachment) {
            this.attachment = attachment;
            return this;
        }

        public Builder withAccess(byte access) {
            this.access = access;
            return this;
        }

        public Builder withUserId(int userId) {
            this.userId = userId;
            return this;
        }

        public Builder withFieldId(int fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public Builder withStateId(int stateId) {
            this.stateId = stateId;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder withTime(Date time) {
            this.time = time;
            return this;
        }

        public Builder withType(byte type) {
            this.type = type;
            return this;
        }

        public Builder withDisplayType(byte displayType) {
            this.displayType = displayType;
            return this;
        }

        public Builder withLatitude(String latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder withLongitude(String longitude) {
            this.longitude = longitude;
            return this;
        }

        public SdAttachmentDetailsDTO build() {
            return new SdAttachmentDetailsDTO(this);
        }
    }
}

