/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.exception.DomainException;
import com.sapphireims.itsm.dto.SdSubCategoryMasterDTO;
import com.sapphireims.itsm.model.SdCategorymaster;
import com.sapphireims.itsm.model.SdSubcategorymaster;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SdCategoryMasterDTO
extends BaseDTO {
    private static final long serialVersionUID = -5935205977348755177L;
    private Integer categoryId;
    private Integer projectId;
    private String projectName;
    private String categoryName;
    private String categoryDescription;
    private int additionalParamId;
    private int status;
    private String shortname;
    @JsonProperty(value="subcategorymasters")
    private List<SdSubCategoryMasterDTO> sdSubcategorymasters;

    private SdCategoryMasterDTO(Builder builder) {
        this.categoryId = builder.categoryId;
        this.projectId = builder.projectId;
        this.projectName = builder.projectName;
        this.categoryName = builder.categoryName;
        this.categoryDescription = builder.categoryDescription;
        this.additionalParamId = builder.additionalParamId;
        this.status = builder.status;
        this.sdSubcategorymasters = builder.sdSubcategorymasters;
        this.shortname = builder.shortname;
    }

    public SdCategoryMasterDTO() {
    }

    public SdCategoryMasterDTO(Integer id) {
        super(id);
        this.setCategoryId(id);
    }

    public SdCategoryMasterDTO(SdCategorymaster category, List<SdSubcategorymaster> subCategory, SdProjectMaster project) {
        this.categoryId = category.getCategoryId();
        this.id = category.getCategoryId();
        this.projectId = project.getProjectId();
        this.projectName = project.getProjectName();
        this.categoryName = category.getCategoryName();
        this.categoryDescription = category.getCategoryDescription();
        this.additionalParamId = category.getAdditionalParamId();
        this.status = category.getStatus();
        this.shortname = category.getShortname();
        if (CollectionUtil.isNotEmpty(subCategory)) {
            this.sdSubcategorymasters = new ArrayList<SdSubCategoryMasterDTO>(subCategory.size());
            for (SdSubcategorymaster su : subCategory) {
                this.sdSubcategorymasters.add(new SdSubCategoryMasterDTO(category, su, project));
            }
        }
    }

    public SdCategoryMasterDTO(SdCategorymaster category) {
        Set<SdSubcategorymaster> subCategory = category.getSdSubcategorymasters();
        this.categoryId = category.getCategoryId();
        this.id = category.getCategoryId();
        this.categoryName = category.getCategoryName();
        this.categoryDescription = category.getCategoryDescription();
        this.additionalParamId = category.getAdditionalParamId();
        this.status = category.getStatus();
        this.shortname = category.getShortname();
        if (CollectionUtil.isNotEmpty(subCategory)) {
            this.sdSubcategorymasters = new ArrayList<SdSubCategoryMasterDTO>(subCategory.size());
            for (SdSubcategorymaster su : subCategory) {
                this.sdSubcategorymasters.add(new SdSubCategoryMasterDTO(category, su));
            }
        }
    }

    @JsonIgnore
    public SdSubCategoryMasterDTO getSdSubCategory(Integer subcategoryId) throws DomainException {
        if (CollectionUtil.isNotEmpty(this.sdSubcategorymasters)) {
            for (SdSubCategoryMasterDTO sub : this.sdSubcategorymasters) {
                if (sub.getSubCategoryId().intValue() != subcategoryId.intValue() || sub.getStatus() != 0) continue;
                return sub;
            }
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, " No such Sub Category Id %d for category id %d  ", new Object[]{subcategoryId, this.categoryId});
    }

    @JsonIgnore
    public SdSubCategoryMasterDTO getSubCategoryByName(String name) throws DomainException {
        if (CollectionUtil.isNotEmpty(this.sdSubcategorymasters)) {
            for (SdSubCategoryMasterDTO sub : this.sdSubcategorymasters) {
                if (!sub.getSubCategoryName().equals(name) || sub.getStatus() != 0) continue;
                return sub;
            }
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, " No such Sub Category name %s for category name %s ", new Object[]{name, this.categoryName});
    }

    public Integer getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Integer categoryId) {
        this.categoryId = categoryId;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryDescription() {
        return this.categoryDescription;
    }

    public void setCategoryDescription(String categoryDescription) {
        this.categoryDescription = categoryDescription;
    }

    public int getAdditionalParamId() {
        return this.additionalParamId;
    }

    public void setAdditionalParamId(int additionalParamId) {
        this.additionalParamId = additionalParamId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public List<SdSubCategoryMasterDTO> getSdSubcategorymasters() {
        return this.sdSubcategorymasters;
    }

    public void setSdSubcategorymasters(List<SdSubCategoryMasterDTO> sdSubcategorymasters) {
        this.sdSubcategorymasters = sdSubcategorymasters;
    }

    public String getShortname() {
        return this.shortname;
    }

    public void setShortname(String shortname) {
        this.shortname = shortname;
    }

    public Integer getId() {
        return this.getCategoryId();
    }

    public void setId(Integer id) {
        this.setCategoryId(id);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.categoryId, this.projectId, this.projectName, this.categoryName, this.categoryDescription, this.additionalParamId, this.status, this.sdSubcategorymasters);
    }

    public boolean equals(Object object) {
        if (object instanceof SdCategoryMasterDTO) {
            if (!super.equals(object)) {
                return false;
            }
            SdCategoryMasterDTO that = (SdCategoryMasterDTO)((Object)object);
            return Objects.equals(this.categoryId, that.categoryId) && Objects.equals(this.projectId, that.projectId) && Objects.equals(this.projectName, that.projectName) && Objects.equals(this.categoryName, that.categoryName) && Objects.equals(this.categoryDescription, that.categoryDescription) && this.additionalParamId == that.additionalParamId && this.status == that.status && Objects.equals(this.sdSubcategorymasters, that.sdSubcategorymasters);
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", -5935205977348755177L).add("categoryId", (Object)this.categoryId).add("projectId", (Object)this.projectId).add("projectName", (Object)this.projectName).add("categoryName", (Object)this.categoryName).add("categoryDescription", (Object)this.categoryDescription).add("additionalParamId", this.additionalParamId).add("status", this.status).add("sdSubcategorymasters", this.sdSubcategorymasters).toString();
    }

    public static final class Builder {
        private Integer categoryId;
        private Integer projectId;
        private String projectName;
        private String categoryName;
        private String categoryDescription;
        private int additionalParamId;
        private int status;
        private String shortname;
        private List<SdSubCategoryMasterDTO> sdSubcategorymasters;

        private Builder() {
        }

        public Builder withCategoryId(Integer categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public Builder withProjectId(Integer projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder withCategoryName(String categoryName) {
            this.categoryName = categoryName;
            return this;
        }

        public Builder withCategoryDescription(String categoryDescription) {
            this.categoryDescription = categoryDescription;
            return this;
        }

        public Builder withAdditionalParamId(int additionalParamId) {
            this.additionalParamId = additionalParamId;
            return this;
        }

        public Builder withStatus(int status) {
            this.status = status;
            return this;
        }

        public Builder withShortName(String shortname) {
            this.shortname = shortname;
            return this;
        }

        public Builder withSdSubcategorymasters(List<SdSubCategoryMasterDTO> sdSubcategorymasters) {
            this.sdSubcategorymasters = sdSubcategorymasters;
            return this;
        }

        public SdCategoryMasterDTO build() {
            return new SdCategoryMasterDTO(this);
        }
    }
}

