/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.model.SdCustomSpecialization;

public class SdCustomSpecializationDTO
extends BaseDTO {
    private static final long serialVersionUID = -5935205977348755177L;
    private Integer specializationId;
    private Integer projectId;
    private String specializationName;
    private String specializationDescription;
    private int status;

    public SdCustomSpecializationDTO() {
    }

    public SdCustomSpecializationDTO(Integer specializationId, Integer projectId, String specializationName, String specializationDescription, int status) {
        this.specializationId = specializationId;
        this.projectId = projectId;
        this.specializationName = specializationName;
        this.specializationDescription = specializationDescription;
        this.status = status;
    }

    public SdCustomSpecializationDTO(SdCustomSpecialization sdcs) {
        this.specializationId = sdcs.getSpecializationId();
        this.projectId = sdcs.getSdProjectMaster().getProjectId();
        this.specializationName = sdcs.getSpecializationName();
        this.specializationDescription = sdcs.getSpecializationDescription();
        this.status = sdcs.getStatus();
    }

    private SdCustomSpecializationDTO(Builder builder) {
        this.specializationId = builder.specializationId;
        this.projectId = builder.projectId;
        this.specializationName = builder.specializationName;
        this.specializationDescription = builder.specializationDescription;
        this.status = builder.status;
    }

    public Integer getSpecializationId() {
        return this.specializationId;
    }

    public void setSpecializationId(Integer specializationId) {
        this.specializationId = specializationId;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getSpecializationName() {
        return this.specializationName;
    }

    public void setSpecializationName(String specializationName) {
        this.specializationName = specializationName;
    }

    public String getSpecializationDescription() {
        return this.specializationDescription;
    }

    public void setSpecializationDescription(String specializationDescription) {
        this.specializationDescription = specializationDescription;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Integer getId() {
        return this.getSpecializationId();
    }

    public void setId(Integer id) {
        this.setSpecializationId(id);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer specializationId;
        private Integer projectId;
        private String specializationName;
        private String specializationDescription;
        private int status;

        public Builder withSpecializationId(Integer specializationId) {
            this.specializationId = specializationId;
            return this;
        }

        public Builder withProjectId(Integer projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withSpecializationName(String specializationName) {
            this.specializationName = specializationName;
            return this;
        }

        public Builder withSpecializationDescription(String specializationDescription) {
            this.specializationDescription = specializationDescription;
            return this;
        }

        public Builder withStatus(int status) {
            this.status = status;
            return this;
        }

        public SdCustomSpecializationDTO build() {
            return new SdCustomSpecializationDTO(this);
        }
    }
}

