/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.sapphireims.dto.BaseDTO;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dto.SdOnactionDTO;
import com.sapphireims.itsm.dto.SdSettingoperationHistoryDTO;
import com.sapphireims.itsm.model.SdDependentMaster;
import com.sapphireims.itsm.model.enummodel.DerivedFieldType;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class SdDependentMasterDTO
extends BaseDTO {
    private static final long serialVersionUID = 4811404827301847044L;
    private Integer dependentFieldId;
    private byte moduleId;
    private String dependentFieldName;
    private int status;
    private String shortname;
    private DerivedFieldType type;
    private List<SdOnactionDTO> onactionList;
    private SdSettingoperationHistoryDTO sdSettingoperationHistoryDTO;
    private List<SdSettingoperationHistoryDTO> sdSettingoperationHistoryDTOList;

    private SdDependentMasterDTO(Builder builder) {
        this.dependentFieldId = builder.dependentFieldId;
        this.moduleId = builder.moduleId;
        this.dependentFieldName = builder.dependentFieldName;
        this.status = builder.status;
        this.type = builder.type;
        this.shortname = builder.shortname;
    }

    public SdDependentMasterDTO() {
    }

    public SdDependentMasterDTO(SdDependentMaster sd) {
        this(sd.getDependentFieldId(), sd.getModuleId(), sd.getDependentFieldName(), sd.getStatus(), sd.getShortname());
    }

    public SdDependentMasterDTO(Integer dependentFieldId, byte moduleId, String dependentFieldName, int status, String shortname) {
        this.dependentFieldId = dependentFieldId;
        this.moduleId = moduleId;
        this.dependentFieldName = dependentFieldName;
        this.status = status;
        this.type = DerivedFieldType.getSdServiceParametersMasterEnum(moduleId);
        this.shortname = shortname;
    }

    public Integer getDependentFieldId() {
        return this.dependentFieldId;
    }

    public void setDependentFieldId(Integer dependentFieldId) {
        this.dependentFieldId = dependentFieldId;
    }

    public byte getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(byte moduleId) {
        this.moduleId = moduleId;
    }

    public String getDependentFieldName() {
        return this.dependentFieldName;
    }

    public void setDependentFieldName(String dependentFieldName) {
        this.dependentFieldName = dependentFieldName;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getShortname() {
        return this.shortname;
    }

    public void setShortname(String shortname) {
        this.shortname = shortname;
    }

    public DerivedFieldType getType() {
        return this.type;
    }

    public void setType(DerivedFieldType type) {
        this.type = type;
    }

    public List<SdOnactionDTO> getOnactionList() {
        return this.onactionList;
    }

    public void setOnactionList(List<SdOnactionDTO> onactionList) {
        this.onactionList = onactionList;
    }

    public SdSettingoperationHistoryDTO getSdSettingoperationHistoryDTO() {
        return this.sdSettingoperationHistoryDTO;
    }

    public void setSdSettingoperationHistoryDTO(SdSettingoperationHistoryDTO sdSettingoperationHistoryDTO) {
        this.sdSettingoperationHistoryDTO = sdSettingoperationHistoryDTO;
    }

    public List<SdSettingoperationHistoryDTO> getSdSettingoperationHistoryDTOList() {
        return this.sdSettingoperationHistoryDTOList;
    }

    public void setSdSettingoperationHistoryDTOList(List<SdSettingoperationHistoryDTO> sdSettingoperationHistoryDTOList) {
        this.sdSettingoperationHistoryDTOList = sdSettingoperationHistoryDTOList;
    }

    public Integer getId() {
        return this.getDependentFieldId();
    }

    public void setId(Integer id) {
        this.setDependentFieldId(id);
    }

    public void validate() throws DomainException, ValidationException {
        Validate.notNull(this.getOnactionList(), (String)"OnactionList can't be null", (Object[])new Object[0]);
        Validate.notNull((Object)this.getDependentFieldName(), (String)"DependentFieldName can't be null", (Object[])new Object[0]);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer dependentFieldId;
        private byte moduleId;
        private String dependentFieldName;
        private int status;
        private String shortname;
        private DerivedFieldType type;

        private Builder() {
        }

        public Builder withDependentFieldId(Integer dependentFieldId) {
            this.dependentFieldId = dependentFieldId;
            return this;
        }

        public Builder withModuleId(byte moduleId) {
            this.moduleId = moduleId;
            return this;
        }

        public Builder withDependentFieldName(String dependentFieldName) {
            this.dependentFieldName = dependentFieldName;
            return this;
        }

        public Builder withStatus(int status) {
            this.status = status;
            return this;
        }

        public Builder withShortName(String shortname) {
            this.shortname = shortname;
            return this;
        }

        public Builder withType(DerivedFieldType type) {
            this.type = type;
            return this;
        }

        public SdDependentMasterDTO build() {
            return new SdDependentMasterDTO(this);
        }
    }
}

