/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectCopyExportResponce;
import com.sapphireims.itsm.dto.projectcopy.ProjectCopyType;
import com.sapphireims.itsm.model.SdEmailLimitConfig;
import com.sapphireims.itsm.model.enummodel.ServiceDeskEmailModuleEnum;

public class SdEmailLimitConfigDTO
extends BaseDTO {
    private Integer slno;
    private String limitType;
    private Integer limitValue;
    private Integer projectId;
    private ServiceDeskEmailModuleEnum emailLimitType;

    public SdEmailLimitConfigDTO() {
    }

    public SdEmailLimitConfigDTO(SdEmailLimitConfig limit) {
        this.slno = limit.getSlno();
        this.limitType = limit.getLimitType();
        this.limitValue = limit.getLimitValue();
        this.projectId = limit.getProjectId();
        this.emailLimitType = ServiceDeskEmailModuleEnum.getServiceDeskEmailModuleEnum(limit.getLimitType());
    }

    public SdEmailLimitConfig getInstaceSdEmailLimitConfig(ProjectCopyExportResponce request, Integer projectId) {
        ServiceDeskEmailModuleEnum limitEnum = ServiceDeskEmailModuleEnum.getServiceDeskEmailModuleEnum(this.limitType);
        int limitVal = 0;
        switch (limitEnum) {
            case To: {
                limitVal = request.getType() != ProjectCopyType.UAT_TO_PRODUCTION ? 60 : this.limitValue;
                break;
            }
            case Cc: {
                limitVal = request.getType() != ProjectCopyType.UAT_TO_PRODUCTION ? 10 : this.limitValue;
                break;
            }
            case STATE_CHANGE: {
                limitVal = request.getType() != ProjectCopyType.UAT_TO_PRODUCTION ? 300 : this.limitValue;
                break;
            }
            case SLA_AND_ESCALATION: {
                limitVal = request.getType() != ProjectCopyType.UAT_TO_PRODUCTION ? 100 : this.limitValue;
                break;
            }
            case MAIL_ON_ENCLOSURE: {
                limitVal = request.getType() != ProjectCopyType.UAT_TO_PRODUCTION ? 100 : this.limitValue;
                break;
            }
            case MAIL_ON_UPDATE: {
                limitVal = request.getType() != ProjectCopyType.UAT_TO_PRODUCTION ? 200 : this.limitValue;
                break;
            }
            case MAIL_ON_PROJECT_TRANSFER: {
                limitVal = request.getType() != ProjectCopyType.UAT_TO_PRODUCTION ? 50 : this.limitValue;
                break;
            }
            case MAIL_ON_WORKGROUP_UPDATE: {
                limitVal = request.getType() != ProjectCopyType.UAT_TO_PRODUCTION ? 50 : this.limitValue;
                break;
            }
            case REMINDER: {
                limitVal = request.getType() != ProjectCopyType.UAT_TO_PRODUCTION ? 100 : this.limitValue;
                break;
            }
            case SEND_MAIL: {
                limitVal = request.getType() != ProjectCopyType.UAT_TO_PRODUCTION ? 100 : this.limitValue;
                break;
            }
            case REPORT: {
                limitVal = request.getType() != ProjectCopyType.UAT_TO_PRODUCTION ? 100 : this.limitValue;
                break;
            }
            case LINK_AND_DELINK_REQUEST: {
                limitVal = request.getType() != ProjectCopyType.UAT_TO_PRODUCTION ? 100 : this.limitValue;
                break;
            }
            case KB_AND_KEDB: {
                limitVal = request.getType() != ProjectCopyType.UAT_TO_PRODUCTION ? 50 : this.limitValue;
            }
        }
        return new SdEmailLimitConfig(limitEnum.getName(), limitVal, projectId);
    }

    public Integer getId() {
        return this.getSlno();
    }

    public void setId(Integer id) {
        this.setSlno(this.slno);
    }

    public String toString() {
        return "SdEmailLimitConfigDTO(slno=" + this.getSlno() + ", limitType=" + this.getLimitType() + ", limitValue=" + this.getLimitValue() + ", projectId=" + this.getProjectId() + ", emailLimitType=" + String.valueOf((Object)this.getEmailLimitType()) + ")";
    }

    public Integer getSlno() {
        return this.slno;
    }

    public String getLimitType() {
        return this.limitType;
    }

    public Integer getLimitValue() {
        return this.limitValue;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public ServiceDeskEmailModuleEnum getEmailLimitType() {
        return this.emailLimitType;
    }

    public void setSlno(Integer slno) {
        this.slno = slno;
    }

    public void setLimitType(String limitType) {
        this.limitType = limitType;
    }

    public void setLimitValue(Integer limitValue) {
        this.limitValue = limitValue;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public void setEmailLimitType(ServiceDeskEmailModuleEnum emailLimitType) {
        this.emailLimitType = emailLimitType;
    }
}

