/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.SdEnclosureTemplateDetailsDTO;
import com.sapphireims.itsm.model.SdEnclosureTemplate;
import com.sapphireims.itsm.model.SdEnclosureTemplateDetails;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.List;

public class SdEnclosureTemplateDTO
extends BaseDTO {
    private static final long serialVersionUID = 490532171838384689L;
    private Integer templateId;
    private Integer projectId;
    private String projectName;
    private String templateName;
    private String description;
    private String templateBody;
    private byte type;
    private List<SdEnclosureTemplateDetailsDTO> sdEnclosureTemplateDetails;

    private SdEnclosureTemplateDTO(Builder builder) {
        this.templateId = builder.templateId;
        this.projectId = builder.projectId;
        this.projectName = builder.projectName;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.templateBody = builder.templateBody;
        this.type = builder.type;
        this.sdEnclosureTemplateDetails = builder.sdEnclosureTemplateDetails;
    }

    public SdEnclosureTemplateDTO() {
    }

    public SdEnclosureTemplateDTO(SdEnclosureTemplate t) {
        this(t.getTemplateId(), t.getSdProjectMaster().getProjectId(), t.getSdProjectMaster().getProjectName(), t.getTemplateName(), t.getDescription(), t.getTemplateBody(), t.getType());
    }

    public SdEnclosureTemplateDTO(SdEnclosureTemplate t, SdProjectMaster m) {
        this(t.getTemplateId(), m.getProjectId(), m.getProjectName(), t.getTemplateName(), t.getDescription(), t.getTemplateBody(), t.getType());
    }

    public SdEnclosureTemplateDTO(Integer templateId, Integer projectId, String projectName, String templateName, String description, String templateBody, byte type) {
        this.templateId = templateId;
        this.projectId = projectId;
        this.projectName = projectName;
        this.templateName = templateName;
        this.description = description;
        this.templateBody = templateBody;
        this.type = type;
    }

    public SdEnclosureTemplateDTO(SdEnclosureTemplate request, List<SdEnclosureTemplateDetails> sdEnclosureTemplateDetails, SdProjectMaster sdpm) {
        this.templateId = request.getTemplateId();
        this.projectId = sdpm.getProjectId();
        this.projectName = sdpm.getProjectName();
        this.templateName = request.getTemplateName();
        this.description = request.getDescription();
        this.templateBody = request.getTemplateBody();
        this.type = request.getType();
        if (CollectionUtil.isNotEmpty(sdEnclosureTemplateDetails)) {
            this.sdEnclosureTemplateDetails = new ArrayList<SdEnclosureTemplateDetailsDTO>(sdEnclosureTemplateDetails.size());
            for (SdEnclosureTemplateDetails sd : sdEnclosureTemplateDetails) {
                this.sdEnclosureTemplateDetails.add(new SdEnclosureTemplateDetailsDTO(sd, request));
            }
        }
    }

    @JsonIgnore
    public SdEnclosureTemplate getSdEnclosureTemplate(SdProjectMaster m) {
        return new SdEnclosureTemplate(m, this.templateName, this.description, this.templateBody, this.type);
    }

    public Integer getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Integer templateId) {
        this.templateId = templateId;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTemplateBody() {
        return this.templateBody;
    }

    public void setTemplateBody(String templateBody) {
        this.templateBody = templateBody;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public List<SdEnclosureTemplateDetailsDTO> getSdEnclosureTemplateDetails() {
        return this.sdEnclosureTemplateDetails;
    }

    public void setSdEnclosureTemplateDetails(List<SdEnclosureTemplateDetailsDTO> sdEnclosureTemplateDetails) {
        this.sdEnclosureTemplateDetails = sdEnclosureTemplateDetails;
    }

    public Integer getId() {
        return this.getTemplateId();
    }

    public void setId(Integer id) {
        this.setTemplateId(id);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer templateId;
        private Integer projectId;
        private String projectName;
        private String templateName;
        private String description;
        private String templateBody;
        private byte type;
        private List<SdEnclosureTemplateDetailsDTO> sdEnclosureTemplateDetails;

        private Builder() {
        }

        public Builder withTemplateId(Integer templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder withProjectId(Integer projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder withTemplateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withTemplateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public Builder withType(byte type) {
            this.type = type;
            return this;
        }

        public Builder withSdNotificationTemplateDetails(List<SdEnclosureTemplateDetailsDTO> sdEnclosureTemplateDetails) {
            this.sdEnclosureTemplateDetails = sdEnclosureTemplateDetails;
            return this;
        }

        public SdEnclosureTemplateDTO build() {
            return new SdEnclosureTemplateDTO(this);
        }
    }
}

