/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sapphire.itsm.mailrouting.model.SdStatesMaster;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectExportRequestDTO;
import com.sapphireims.itsm.model.SdMultiapprovalDetails;
import com.sapphireims.itsm.model.SdMultiapprovalMaster;
import com.sapphireims.itsm.model.enummodel.SdMultiLevelApprovalDetailsEnum;
import java.util.LinkedList;

public class SdMultiapprovalDetailsDTO
extends BaseDTO {
    private static final long serialVersionUID = -1367494431496279523L;
    private Integer detailsId;
    private Integer appRuleId;
    private int inputType;
    private String inputValue;
    private int appOrder;

    private SdMultiapprovalDetailsDTO(Builder builder) {
        this.detailsId = builder.detailsId;
        this.appRuleId = builder.appRuleId;
        this.inputType = builder.inputType;
        this.inputValue = builder.inputValue;
        this.appOrder = builder.appOrder;
    }

    public SdMultiapprovalDetailsDTO(SdMultiapprovalDetails sd, SdMultiapprovalMaster sdMultiapprovalMaster) {
        this(sd.getDetailsId(), sdMultiapprovalMaster.getAppRuleId(), sd.getInputType(), sd.getInputValue(), sd.getAppOrder());
    }

    public SdMultiapprovalDetailsDTO() {
    }

    public SdMultiapprovalDetailsDTO(Integer detailsId, Integer appRuleId, int inputType, String inputValue, int appOrder) {
        this.detailsId = detailsId;
        this.appRuleId = appRuleId;
        this.inputType = inputType;
        this.inputValue = inputValue;
        this.appOrder = appOrder;
    }

    @JsonIgnore
    public SdMultiapprovalDetails getModelObject(SdMultiapprovalMaster smam, ProjectExportRequestDTO pReq) {
        SdMultiLevelApprovalDetailsEnum smladEnum = SdMultiLevelApprovalDetailsEnum.getSdMultiLevelApprovalDetailsEnum(this.inputType);
        String tempInputValue = "";
        LinkedList<String> ll = new LinkedList<String>();
        switch (smladEnum) {
            case Roles: {
                if (this.inputValue.trim().equals("All")) {
                    tempInputValue = this.inputValue.trim();
                    break;
                }
                tempInputValue = String.valueOf(pReq.getOldIdSdProjectRoles().containsKey(Integer.parseInt(this.inputValue.trim())) ? pReq.getOldIdSdProjectRoles().get(Integer.parseInt(this.inputValue.trim())).getProjectRoleId() : 0);
                if (!tempInputValue.trim().equals("0")) break;
                tempInputValue = "All";
                break;
            }
            case Caption: 
            case ApprovalLabel: 
            case RejectLabel: 
            case Editable: {
                tempInputValue = this.inputValue.trim();
                break;
            }
            case StatesOnApprove: 
            case StatesOnReject: {
                String[] states;
                for (String state : states = this.inputValue.trim().split(",")) {
                    SdStatesMaster ssm;
                    SdStatesMaster sdStatesMaster = ssm = pReq.getOldIdSdStatesMasters().containsKey(Integer.parseInt(state.trim())) ? pReq.getOldIdSdStatesMasters().get(Integer.parseInt(state.trim())) : null;
                    if (ssm == null) continue;
                    ll.add(String.valueOf(ssm.getStateId()));
                }
                if (ll.isEmpty() || ll.size() <= 0) break;
                tempInputValue = String.join((CharSequence)",", ll);
                break;
            }
            case OnApprovalCheckState: 
            case OnRejectCheckState: {
                SdStatesMaster ssm;
                SdStatesMaster sdStatesMaster = ssm = pReq.getOldIdSdStatesMasters().containsKey(Integer.parseInt(this.inputValue.trim())) ? pReq.getOldIdSdStatesMasters().get(Integer.parseInt(this.inputValue.trim())) : null;
                if (ssm == null) break;
                tempInputValue = String.valueOf(ssm.getStateId());
            }
        }
        if (!tempInputValue.trim().equals("") || this.inputType == 2) {
            return new SdMultiapprovalDetails(smam, this.inputType, tempInputValue, this.appOrder);
        }
        return null;
    }

    public Integer getDetailsId() {
        return this.detailsId;
    }

    public void setDetailsId(Integer detailsId) {
        this.detailsId = detailsId;
    }

    public Integer getAppRuleId() {
        return this.appRuleId;
    }

    public void setAppRuleId(Integer appRuleId) {
        this.appRuleId = appRuleId;
    }

    public int getInputType() {
        return this.inputType;
    }

    public void setInputType(int inputType) {
        this.inputType = inputType;
    }

    public String getInputValue() {
        return this.inputValue;
    }

    public void setInputValue(String inputValue) {
        this.inputValue = inputValue;
    }

    public int getAppOrder() {
        return this.appOrder;
    }

    public void setAppOrder(int appOrder) {
        this.appOrder = appOrder;
    }

    public Integer getId() {
        return this.getDetailsId();
    }

    public void setId(Integer id) {
        this.setDetailsId(id);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer detailsId;
        private Integer appRuleId;
        private int inputType;
        private String inputValue;
        private int appOrder;

        private Builder() {
        }

        public Builder withDetailsId(Integer detailsId) {
            this.detailsId = detailsId;
            return this;
        }

        public Builder withAppRuleId(Integer appRuleId) {
            this.appRuleId = appRuleId;
            return this;
        }

        public Builder withInputType(int inputType) {
            this.inputType = inputType;
            return this;
        }

        public Builder withInputValue(String inputValue) {
            this.inputValue = inputValue;
            return this;
        }

        public Builder withAppOrder(int appOrder) {
            this.appOrder = appOrder;
            return this;
        }

        public SdMultiapprovalDetailsDTO build() {
            return new SdMultiapprovalDetailsDTO(this);
        }
    }
}

