/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.sapphire.itsm.mailrouting.model.SdStatesMaster;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.SdMultiapprovalDetailsDTO;
import com.sapphireims.itsm.model.SdMultiapprovalDetails;
import com.sapphireims.itsm.model.SdMultiapprovalMaster;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.List;

public class SdMultiapprovalMasterDTO
extends BaseDTO {
    private static final long serialVersionUID = 6967963147319371267L;
    private Integer appRuleId;
    private int stateId;
    private int noOfApp;
    private int appType;
    private int appModuleType;
    private int minimumApprovals;
    private int isEditable;
    private int minimumRejections;
    private List<SdMultiapprovalDetailsDTO> sdMultiapprovalDetailsDTO;

    private SdMultiapprovalMasterDTO(Builder builder) {
        this.appRuleId = builder.appRuleId;
        this.stateId = builder.stateId;
        this.noOfApp = builder.noOfApp;
        this.appType = builder.appType;
        this.appModuleType = builder.appModuleType;
        this.minimumApprovals = builder.minimumApprovals;
        this.isEditable = builder.isEditable;
        this.minimumRejections = builder.minimumRejections;
        this.sdMultiapprovalDetailsDTO = builder.sdMultiapprovalDetailsDTO;
    }

    public SdMultiapprovalMasterDTO() {
    }

    public SdMultiapprovalMasterDTO(SdMultiapprovalMaster sd, SdStatesMaster stataeMaster) {
        this(sd.getAppRuleId(), stataeMaster.getStateId(), sd.getNoOfApp(), sd.getAppType(), sd.getAppModuleType(), sd.getMinimumApprovals(), sd.getIsEditable(), sd.getMinimumRejections());
    }

    public SdMultiapprovalMasterDTO(Integer appRuleId, int stateId, int noOfApp, int appType, int appModuleType, int minimumApprovals, int isEditable, int minimumRejections) {
        this.appRuleId = appRuleId;
        this.stateId = stateId;
        this.noOfApp = noOfApp;
        this.appType = appType;
        this.appModuleType = appModuleType;
        this.minimumApprovals = minimumApprovals;
        this.isEditable = isEditable;
        this.minimumRejections = minimumRejections;
    }

    public SdMultiapprovalMasterDTO addMultiapprovalDetails(List<SdMultiapprovalDetails> list, SdMultiapprovalMaster master) {
        if (CollectionUtil.isNotEmpty(list)) {
            this.sdMultiapprovalDetailsDTO = new ArrayList<SdMultiapprovalDetailsDTO>(list.size());
            for (SdMultiapprovalDetails sd : list) {
                this.sdMultiapprovalDetailsDTO.add(new SdMultiapprovalDetailsDTO(sd, master));
            }
        }
        return this;
    }

    public List<SdMultiapprovalDetailsDTO> getSdMultiapprovalDetailsDTO() {
        return this.sdMultiapprovalDetailsDTO;
    }

    public void setSdMultiapprovalDetailsDTO(List<SdMultiapprovalDetailsDTO> sdMultiapprovalDetailsDTO) {
        this.sdMultiapprovalDetailsDTO = sdMultiapprovalDetailsDTO;
    }

    public Integer getAppRuleId() {
        return this.appRuleId;
    }

    public void setAppRuleId(Integer appRuleId) {
        this.appRuleId = appRuleId;
    }

    public int getStateId() {
        return this.stateId;
    }

    public void setStateId(int stateId) {
        this.stateId = stateId;
    }

    public int getNoOfApp() {
        return this.noOfApp;
    }

    public void setNoOfApp(int noOfApp) {
        this.noOfApp = noOfApp;
    }

    public int getAppType() {
        return this.appType;
    }

    public void setAppType(int appType) {
        this.appType = appType;
    }

    public int getAppModuleType() {
        return this.appModuleType;
    }

    public void setAppModuleType(int appModuleType) {
        this.appModuleType = appModuleType;
    }

    public int getMinimumApprovals() {
        return this.minimumApprovals;
    }

    public void setMinimumApprovals(int minimumApprovals) {
        this.minimumApprovals = minimumApprovals;
    }

    public int getIsEditable() {
        return this.isEditable;
    }

    public void setIsEditable(int isEditable) {
        this.isEditable = isEditable;
    }

    public int getMinimumRejections() {
        return this.minimumRejections;
    }

    public void setMinimumRejections(int minimumRejections) {
        this.minimumRejections = minimumRejections;
    }

    public Integer getId() {
        return this.getAppRuleId();
    }

    public void setId(Integer id) {
        this.setAppRuleId(id);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer appRuleId;
        private int stateId;
        private int noOfApp;
        private int appType;
        private int appModuleType;
        private int minimumApprovals;
        private int isEditable;
        private int minimumRejections;
        private List<SdMultiapprovalDetailsDTO> sdMultiapprovalDetailsDTO;

        private Builder() {
        }

        public Builder withAppRuleId(Integer appRuleId) {
            this.appRuleId = appRuleId;
            return this;
        }

        public Builder withStateId(int stateId) {
            this.stateId = stateId;
            return this;
        }

        public Builder withNoOfApp(int noOfApp) {
            this.noOfApp = noOfApp;
            return this;
        }

        public Builder withAppType(int appType) {
            this.appType = appType;
            return this;
        }

        public Builder withAppModuleType(int appModuleType) {
            this.appModuleType = appModuleType;
            return this;
        }

        public Builder withMinimumApprovals(int minimumApprovals) {
            this.minimumApprovals = minimumApprovals;
            return this;
        }

        public Builder withIsEditable(int isEditable) {
            this.isEditable = isEditable;
            return this;
        }

        public Builder withMinimumRejections(int minimumRejections) {
            this.minimumRejections = minimumRejections;
            return this;
        }

        public Builder withSdMultiapprovalDetailsDTO(List<SdMultiapprovalDetailsDTO> sdMultiapprovalDetailsDTO) {
            this.sdMultiapprovalDetailsDTO = sdMultiapprovalDetailsDTO;
            return this;
        }

        public SdMultiapprovalMasterDTO build() {
            return new SdMultiapprovalMasterDTO(this);
        }
    }
}

